/*
 * Decompiled with CFR 0.152.
 */
package testsX.detailed.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cef.OS;
import org.cef.browser.CefBrowser;

public class ControlPanel
extends JPanel {
    private final JButton backButton_;
    private final JButton forwardButton_;
    private final JButton reloadButton_;
    private final JTextField address_field_;
    private final JLabel zoom_label_;
    private double zoomLevel_ = 0.0;
    private final CefBrowser browser_;

    public ControlPanel(CefBrowser browser) {
        assert (browser != null);
        this.browser_ = browser;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        this.add(Box.createHorizontalStrut(5));
        this.backButton_ = new JButton("Back");
        this.backButton_.setFocusable(false);
        this.backButton_.setAlignmentX(0.0f);
        this.backButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.goBack();
            }
        });
        this.add(this.backButton_);
        this.add(Box.createHorizontalStrut(5));
        this.forwardButton_ = new JButton("Forward");
        this.forwardButton_.setFocusable(false);
        this.forwardButton_.setAlignmentX(0.0f);
        this.forwardButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.goForward();
            }
        });
        this.add(this.forwardButton_);
        this.add(Box.createHorizontalStrut(5));
        this.reloadButton_ = new JButton("Reload");
        this.reloadButton_.setFocusable(false);
        this.reloadButton_.setAlignmentX(0.0f);
        this.reloadButton_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ControlPanel.this.reloadButton_.getText().equalsIgnoreCase("reload")) {
                    int mask;
                    int n = mask = OS.isMacintosh() ? 4 : 2;
                    if ((e.getModifiers() & mask) != 0) {
                        System.out.println("Reloading - ignoring cached values");
                        ControlPanel.this.browser_.reloadIgnoreCache();
                    } else {
                        System.out.println("Reloading - using cached values");
                        ControlPanel.this.browser_.reload();
                    }
                } else {
                    ControlPanel.this.browser_.stopLoad();
                }
            }
        });
        this.add(this.reloadButton_);
        this.add(Box.createHorizontalStrut(5));
        JLabel addressLabel = new JLabel("Address:");
        addressLabel.setAlignmentX(0.0f);
        this.add(addressLabel);
        this.add(Box.createHorizontalStrut(5));
        this.address_field_ = new JTextField(100);
        this.address_field_.setAlignmentX(0.0f);
        this.address_field_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.loadURL(ControlPanel.this.getAddress());
            }
        });
        this.add(this.address_field_);
        this.add(Box.createHorizontalStrut(5));
        JButton goButton = new JButton("Go");
        goButton.setFocusable(false);
        goButton.setAlignmentX(0.0f);
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.loadURL(ControlPanel.this.getAddress());
            }
        });
        this.add(goButton);
        this.add(Box.createHorizontalStrut(5));
        JButton minusButton = new JButton("-");
        minusButton.setFocusable(false);
        minusButton.setAlignmentX(0.5f);
        minusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.setZoomLevel(ControlPanel.this.zoomLevel_ -= 1.0);
                ControlPanel.this.zoom_label_.setText(new Double(ControlPanel.this.zoomLevel_).toString());
            }
        });
        this.add(minusButton);
        this.zoom_label_ = new JLabel("0.0");
        this.add(this.zoom_label_);
        JButton plusButton = new JButton("+");
        plusButton.setFocusable(false);
        plusButton.setAlignmentX(0.5f);
        plusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.browser_.setZoomLevel(ControlPanel.this.zoomLevel_ += 1.0);
                ControlPanel.this.zoom_label_.setText(new Double(ControlPanel.this.zoomLevel_).toString());
            }
        });
        this.add(plusButton);
    }

    public void update(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        if (browser == this.browser_) {
            this.backButton_.setEnabled(canGoBack);
            this.forwardButton_.setEnabled(canGoForward);
            this.reloadButton_.setText(isLoading ? "Abort" : "Reload");
        }
    }

    public String getAddress() {
        String address = this.address_field_.getText();
        try {
            address = address.replaceAll(" ", "%20");
            URI test = new URI(address);
            if (test.getScheme() != null) {
                return address;
            }
            if (test.getHost() != null && test.getPath() != null) {
                return address;
            }
            String specific = test.getSchemeSpecificPart();
            if (specific.indexOf(46) == -1) {
                throw new URISyntaxException(specific, "No dot inside domain");
            }
        }
        catch (URISyntaxException e1) {
            address = "search://" + address;
        }
        return address;
    }

    public void setAddress(CefBrowser browser, String address) {
        if (browser == this.browser_) {
            this.address_field_.setText(address);
        }
    }

    public JTextField getAddressField() {
        return this.address_field_;
    }
}

