/*
 * Decompiled with CFR 0.152.
 */
package testsX.detailed.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import testsX.detailed.BrowserFrame;
import testsX.detailed.MainFrame;
import testsX.detailed.dialog.CookieManagerDialog;
import testsX.detailed.dialog.DevToolsDialog;
import testsX.detailed.dialog.DownloadDialog;
import testsX.detailed.dialog.SearchDialog;
import testsX.detailed.dialog.ShowTextDialog;
import testsX.detailed.dialog.UrlRequestDialog;
import testsX.detailed.dialog.WebPluginManagerDialog;
import testsX.detailed.ui.ControlPanel;

public class MenuBar
extends JMenuBar {
    private final BrowserFrame owner_;
    private final CefBrowser browser_;
    private String last_selected_file_ = "";
    private final JMenu bookmarkMenu_;
    private final ControlPanel control_pane_;
    private final DownloadDialog downloadDialog_;
    private final CefCookieManager cookieManager_;
    private boolean reparentPending_ = false;

    public MenuBar(BrowserFrame owner, CefBrowser browser, ControlPanel control_pane, DownloadDialog downloadDialog, CefCookieManager cookieManager) {
        this.owner_ = owner;
        this.browser_ = browser;
        this.control_pane_ = control_pane;
        this.downloadDialog_ = downloadDialog;
        this.cookieManager_ = cookieManager;
        this.setEnabled(this.browser_ != null);
        JMenu fileMenu = new JMenu("File");
        JMenuItem openFileItem = new JMenuItem("Open file...");
        openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser(new File(MenuBar.this.last_selected_file_));
                fc.showOpenDialog(MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    MenuBar.this.last_selected_file_ = selectedFile.getAbsolutePath();
                    MenuBar.this.browser_.loadURL("file:///" + selectedFile.getAbsolutePath());
                }
            }
        });
        fileMenu.add(openFileItem);
        JMenuItem openFileDialog = new JMenuItem("Save as...");
        openFileDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CefRunFileDialogCallback callback = new CefRunFileDialogCallback(){

                    public void onFileDialogDismissed(int selectedAcceptFilter, Vector<String> filePaths) {
                        if (!filePaths.isEmpty()) {
                            try {
                                SaveAs saveContent = new SaveAs(filePaths.get(0));
                                MenuBar.this.browser_.getSource((CefStringVisitor)saveContent);
                            }
                            catch (UnsupportedEncodingException e) {
                                MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", MenuBar.this.control_pane_.getAddress(), 0);
                            }
                            catch (FileNotFoundException e) {
                                MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", MenuBar.this.control_pane_.getAddress(), 0);
                            }
                        }
                    }
                };
                MenuBar.this.browser_.runFileDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, MenuBar.this.owner_.getTitle(), "index.html", null, 0, callback);
            }
        });
        fileMenu.add(openFileDialog);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.print();
            }
        });
        fileMenu.add(printItem);
        JMenuItem printToPdfItem = new JMenuItem("Print to PDF");
        printToPdfItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.showSaveDialog(MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    CefPdfPrintSettings pdfSettings = new CefPdfPrintSettings();
                    pdfSettings.header_footer_enabled = true;
                    pdfSettings.page_width = 210000;
                    pdfSettings.page_height = 297000;
                }
            }
        });
        fileMenu.add(printToPdfItem);
        JMenuItem searchItem = new JMenuItem("Search...");
        searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog((Frame)MenuBar.this.owner_, MenuBar.this.browser_).setVisible(true);
            }
        });
        fileMenu.add(searchItem);
        fileMenu.addSeparator();
        JMenuItem viewSource = new JMenuItem("View source");
        viewSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.viewSource();
            }
        });
        fileMenu.add(viewSource);
        JMenuItem getSource = new JMenuItem("Get source...");
        getSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Source of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getSource((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getSource);
        JMenuItem getText = new JMenuItem("Get text...");
        getText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Content of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getText((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getText);
        fileMenu.addSeparator();
        JMenuItem showDownloads = new JMenuItem("Show Downloads");
        showDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.downloadDialog_.setVisible(true);
            }
        });
        fileMenu.add(showDownloads);
        JMenuItem showCookies = new JMenuItem("Show Cookies");
        showCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog cookieManager = new CookieManagerDialog((Frame)MenuBar.this.owner_, "Cookie Manager", MenuBar.this.cookieManager_);
                cookieManager.setVisible(true);
            }
        });
        fileMenu.add(showCookies);
        JMenuItem showPlugins = new JMenuItem("Show Plugins");
        showPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPluginManagerDialog pluginManager = new WebPluginManagerDialog((Frame)MenuBar.this.owner_, "Plugin Manager");
                pluginManager.setVisible(true);
            }
        });
        fileMenu.add(showPlugins);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.owner_.dispatchEvent(new WindowEvent(MenuBar.this.owner_, 201));
            }
        });
        fileMenu.add(exitItem);
        this.bookmarkMenu_ = new JMenu("Bookmarks");
        JMenuItem addBookmarkItem = new JMenuItem("Add bookmark");
        addBookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.addBookmark(MenuBar.this.owner_.getTitle(), MenuBar.this.control_pane_.getAddress());
            }
        });
        this.bookmarkMenu_.add(addBookmarkItem);
        this.bookmarkMenu_.addSeparator();
        JMenu testMenu = new JMenu("Tests");
        JMenuItem testJSItem = new JMenuItem("JavaScript alert");
        testJSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Hello World');", MenuBar.this.control_pane_.getAddress(), 1);
            }
        });
        testMenu.add(testJSItem);
        JMenuItem jsAlertItem = new JMenuItem("JavaScript alert (will be suppressed)");
        jsAlertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Never displayed');", "http://dontshow.me", 1);
            }
        });
        testMenu.add(jsAlertItem);
        JMenuItem testShowText = new JMenuItem("Show Text");
        testShowText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadString("<html><body><h1>Hello World</h1></body></html>", MenuBar.this.control_pane_.getAddress());
            }
        });
        testMenu.add(testShowText);
        JMenuItem showForm = new JMenuItem("RequestHandler Test");
        showForm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String form = "<html><head><title>RequestHandler test</title></head>";
                form = form + "<body><h1>RequestHandler test</h1>";
                form = form + "<form action=\"http://www.google.com/\" method=\"post\">";
                form = form + "<input type=\"text\" name=\"searchFor\"/>";
                form = form + "<input type=\"submit\"/><br/>";
                form = form + "<input type=\"checkbox\" name=\"sendAsGet\"> Use GET instead of POST";
                form = form + "<p>This form tries to send the content of the text field as HTTP-POST request to http://www.google.com.</p>";
                form = form + "<h2>Testcase 1</h2>";
                form = form + "Try to enter the word <b>\"ignore\"</b> into the text field and press \"submit\".<br />";
                form = form + "The request will be rejected by the application.";
                form = form + "<p>See implementation of <u>tests.RequestHandler.onBeforeBrowse(CefBrowser, CefRequest, boolean)</u> for details</p>";
                form = form + "<h2>Testcase 2</h2>";
                form = form + "Due Google doesn't allow the POST method, the server replies with a 405 error.</br>";
                form = form + "If you activate the checkbox \"Use GET instead of POST\", the application will change the POST request into a GET request.";
                form = form + "<p>See implementation of <u>tests.RequestHandler.onBeforeResourceLoad(CefBrowser, CefRequest)</u> for details</p>";
                form = form + "</form>";
                form = form + "</body></html>";
                MenuBar.this.browser_.loadString(form, MenuBar.this.control_pane_.getAddress());
            }
        });
        testMenu.add(showForm);
        JMenuItem httpRequest = new JMenuItem("Manual HTTP request");
        httpRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchFor = JOptionPane.showInputDialog(MenuBar.this.owner_, (Object)"Search on google:");
                if (searchFor != null && !searchFor.isEmpty()) {
                    CefRequest myRequest = CefRequest.create();
                    myRequest.setMethod("GET");
                    myRequest.setURL("http://www.google.com/#q=" + searchFor);
                    myRequest.setFirstPartyForCookies("http://www.google.com/#q=" + searchFor);
                    MenuBar.this.browser_.loadRequest(myRequest);
                }
            }
        });
        testMenu.add(httpRequest);
        JMenuItem showInfo = new JMenuItem("Show Info");
        showInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String info = "<html><head><title>Browser status</title></head>";
                info = info + "<body><h1>Browser status</h1><table border=\"0\">";
                info = info + "<tr><td>CanGoBack</td><td>" + MenuBar.this.browser_.canGoBack() + "</td></tr>";
                info = info + "<tr><td>CanGoForward</td><td>" + MenuBar.this.browser_.canGoForward() + "</td></tr>";
                info = info + "<tr><td>IsLoading</td><td>" + MenuBar.this.browser_.isLoading() + "</td></tr>";
                info = info + "<tr><td>isPopup</td><td>" + MenuBar.this.browser_.isPopup() + "</td></tr>";
                info = info + "<tr><td>hasDocument</td><td>" + MenuBar.this.browser_.hasDocument() + "</td></tr>";
                info = info + "<tr><td>Url</td><td>" + MenuBar.this.browser_.getURL() + "</td></tr>";
                info = info + "<tr><td>Zoom-Level</td><td>" + MenuBar.this.browser_.getZoomLevel() + "</td></tr>";
                info = info + "</table></body></html>";
                String js = "var x=window.open(); x.document.open(); x.document.write('" + info + "'); x.document.close();";
                MenuBar.this.browser_.executeJavaScript(js, "", 0);
            }
        });
        testMenu.add(showInfo);
        final JMenuItem showDevTools = new JMenuItem("Show DevTools");
        showDevTools.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevToolsDialog devToolsDlg = new DevToolsDialog((Frame)MenuBar.this.owner_, "DEV Tools", MenuBar.this.browser_);
                devToolsDlg.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        showDevTools.setEnabled(true);
                    }
                });
                devToolsDlg.setVisible(true);
                showDevTools.setEnabled(false);
            }
        });
        testMenu.add(showDevTools);
        JMenuItem testURLRequest = new JMenuItem("URL Request");
        testURLRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialog dlg = new UrlRequestDialog((Frame)MenuBar.this.owner_, "URL Request Test");
                dlg.setVisible(true);
            }
        });
        testMenu.add(testURLRequest);
        JMenuItem reparent = new JMenuItem("Reparent");
        reparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final BrowserFrame newFrame = new BrowserFrame("New Window");
                newFrame.setLayout(new BorderLayout());
                final JButton reparentButton = new JButton("Reparent <");
                reparentButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MenuBar.this.reparentPending_) {
                            return;
                        }
                        MenuBar.this.reparentPending_ = true;
                        if (reparentButton.getText().equals("Reparent <")) {
                            MenuBar.this.owner_.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    newFrame.add(MenuBar.this.browser_.getUIComponent(), "Center");
                                    newFrame.setBrowser(MenuBar.this.browser_);
                                    reparentButton.setText("Reparent >");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        } else {
                            newFrame.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    JRootPane rootPane = (JRootPane)MenuBar.this.owner_.getComponent(0);
                                    Container container = rootPane.getContentPane();
                                    JPanel panel = (JPanel)container.getComponent(0);
                                    panel.add(MenuBar.this.browser_.getUIComponent());
                                    MenuBar.this.owner_.setBrowser(MenuBar.this.browser_);
                                    reparentButton.setText("Reparent <");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        }
                    }
                });
                newFrame.add((Component)reparentButton, "North");
                newFrame.setSize(400, 400);
                newFrame.setVisible(true);
            }
        });
        testMenu.add(reparent);
        JMenuItem newwindow = new JMenuItem("New window");
        newwindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame frame = new MainFrame(OS.isLinux(), false, false, null);
                frame.setSize(800, 600);
                frame.setVisible(true);
            }
        });
        testMenu.add(newwindow);
        this.add(fileMenu);
        this.add(this.bookmarkMenu_);
        this.add(testMenu);
    }

    public void addBookmark(String name, String URL2) {
        Component[] entries;
        if (this.bookmarkMenu_ == null) {
            return;
        }
        for (Component itemEntry : entries = this.bookmarkMenu_.getMenuComponents()) {
            JMenuItem item;
            if (!(itemEntry instanceof JMenuItem) || !(item = (JMenuItem)itemEntry).getText().equals(name)) continue;
            item.setActionCommand(URL2);
            return;
        }
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setActionCommand(URL2);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadURL(e.getActionCommand());
            }
        });
        this.bookmarkMenu_.add(menuItem);
        this.validate();
    }

    public void addBookmarkSeparator() {
        this.bookmarkMenu_.addSeparator();
    }

    class SaveAs
    implements CefStringVisitor {
        private PrintWriter fileWriter_;

        public SaveAs(String fName) throws FileNotFoundException, UnsupportedEncodingException {
            this.fileWriter_ = new PrintWriter(fName, "UTF-8");
        }

        public void visit(String string) {
            this.fileWriter_.write(string);
            this.fileWriter_.close();
        }
    }
}

