/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletionEditable
extends PlainDocument {
    JComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletionEditable(final JComboBox comboBox) {
        this.comboBox = comboBox;
        this.model = comboBox.getModel();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoCompletionEditable.this.selecting) {
                    AutoCompletionEditable.this.highlightCompletedText(0);
                }
            }
        });
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoCompletionEditable.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoCompletionEditable.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
                AutoCompletionEditable.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoCompletionEditable.this.hitBackspace = true;
                        AutoCompletionEditable.this.hitBackspaceOnSelection = AutoCompletionEditable.this.editor.getSelectionStart() != AutoCompletionEditable.this.editor.getSelectionEnd();
                        break;
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletionEditable.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AutoCompletionEditable.this.hidePopupOnFocusLoss) {
                    comboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(comboBox.getEditor());
        Object selected = comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    public static void enable(JComboBox comboBox) {
        comboBox.setEditable(true);
        new AutoCompletionEditable(comboBox);
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextComponent)newEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
            this.setText(item.toString());
            this.highlightCompletedText(offs + str.length());
        } else {
            item = null;
        }
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        this.selecting = false;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().startsWith(str2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> comboBox = new JComboBox<Object>(new Object[]{"Ester", "Ester1", "Ester2", "Ester3", "Ester4", "Ester5", "Jordi", "Jordina", "Jorge", "Sergi"});
        AutoCompletionEditable.enable(comboBox);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(comboBox);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompletionEditable.createAndShowGUI();
            }
        });
    }
}

