/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import tnxbeans.SortButtonRenderer;
import tnxbeans.SortableTableModel;

public class HeaderListener
extends MouseAdapter {
    public JTableHeader header;
    public SortButtonRenderer renderer;
    public int oldSortedColumn = -1;
    public boolean oldIsAscent = false;

    HeaderListener(JTableHeader header, SortButtonRenderer renderer) {
        this.header = header;
        this.renderer = renderer;
    }

    public void resort() {
        if (this.oldSortedColumn >= 0) {
            System.out.println("resort: column:" + this.oldSortedColumn);
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            ((SortableTableModel)this.header.getTable().getModel()).sortByColumn(this.oldSortedColumn, this.oldIsAscent);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int sortCol;
            int col = this.header.columnAtPoint(e.getPoint());
            this.oldSortedColumn = sortCol = this.header.getTable().convertColumnIndexToModel(col);
            this.renderer.setPressedColumn(col);
            this.renderer.setSelectedColumn(col);
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            boolean isAscent = 1 == this.renderer.getState(col);
            this.oldIsAscent = isAscent;
            System.out.println("resort: column:" + sortCol);
            ((SortableTableModel)this.header.getTable().getModel()).sortByColumn(sortCol, isAscent);
            this.header.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

