/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.awt.Color;
import java.awt.Component;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import tnxbeans.BevelArrowIcon;
import tnxbeans.BlankIcon;

public class SortButtonRenderer
extends JLabel
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int DOWN = 1;
    public static final int UP = 2;
    int pushedColumn = -1;
    Hashtable state = new Hashtable();
    JLabel downButton;
    JLabel upButton;

    public SortButtonRenderer() {
        this.setHorizontalTextPosition(2);
        this.setIcon(new BlankIcon());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.downButton = new JLabel();
        this.downButton.setBackground(new Color(200, 250, 200));
        this.downButton.setOpaque(true);
        this.downButton.setIcon(new BevelArrowIcon(1, false, false));
        this.downButton.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.upButton = new JLabel();
        this.upButton.setBackground(new Color(250, 200, 200));
        this.upButton.setOpaque(true);
        this.upButton.setIcon(new BevelArrowIcon(0, false, false));
        this.upButton.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel button = this;
        Object obj = this.state.get(new Integer(column));
        if (obj != null) {
            button = (Integer)obj == 1 ? this.downButton : this.upButton;
        }
        button.setText(value == null ? "" : value.toString());
        boolean isPressed = column == this.pushedColumn;
        return button;
    }

    public void setPressedColumn(int col) {
        this.pushedColumn = col;
    }

    public void setSelectedColumn(int col) {
        if (col < 0) {
            return;
        }
        Integer value = null;
        Object obj = this.state.get(new Integer(col));
        value = obj == null ? new Integer(1) : ((Integer)obj == 1 ? new Integer(2) : new Integer(1));
        this.state.clear();
        this.state.put(new Integer(col), value);
    }

    public int getState(int col) {
        Object obj = this.state.get(new Integer(col));
        int retValue = obj == null ? 0 : ((Integer)obj == 1 ? 1 : 2);
        return retValue;
    }
}

