/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import java.sql.Date;
import java.sql.ResultSetMetaData;
import javax.swing.table.DefaultTableModel;
import tnxbeans.TableSorter;

public class SortableTableModel
extends DefaultTableModel {
    int[] indexes;
    TableSorter sorter;
    ResultSetMetaData meta;
    int[] colonneEditabili = null;
    String[] colonneEditabiliByName = null;
    boolean ignoreNulls = false;
    public boolean dirty;
    Integer column;
    Boolean ascent;

    public SortableTableModel() {
    }

    public SortableTableModel(String[] colonne, int righe) {
        super.setColumnIdentifiers(colonne);
    }

    public SortableTableModel(String[] colonne, int righe, ResultSetMetaData meta) {
        super.setColumnIdentifiers(colonne);
        this.meta = meta;
    }

    public SortableTableModel(String[] colonne, int righe, ResultSetMetaData meta, int[] colonneEditabili) {
        this(colonne, righe, meta, colonneEditabili, null);
    }

    public SortableTableModel(String[] colonne, int righe, ResultSetMetaData meta, int[] colonneEditabili, String[] colonneEditabiliByName) {
        this(colonne, righe, meta, colonneEditabili, colonneEditabiliByName, false);
    }

    public SortableTableModel(String[] colonne, int righe, ResultSetMetaData meta, int[] colonneEditabili, String[] colonneEditabiliByName, boolean ignoreNulls) {
        super.setColumnIdentifiers(colonne);
        this.meta = meta;
        this.colonneEditabili = colonneEditabili;
        this.colonneEditabiliByName = colonneEditabiliByName;
        this.ignoreNulls = ignoreNulls;
    }

    public Class getColumnClassSql(int col) {
        try {
            switch (this.meta.getColumnType(col + 1)) {
                case 1: 
                case 12: 
                case 2004: {
                    return String.class;
                }
                case 4: 
                case 5: {
                    return Integer.class;
                }
                case -5: {
                    return Long.class;
                }
                case 8: {
                    return Double.class;
                }
                case 3: {
                    return Double.class;
                }
                case 91: {
                    return Date.class;
                }
            }
            return Object.class;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        int rowIndex = row;
        if (row == -1) {
            row = 0;
        }
        try {
            if (this.indexes != null) {
                rowIndex = this.indexes[row];
            }
            return super.getValueAt(rowIndex, col);
        }
        catch (Exception err) {
            System.err.println("sortable:err:row=" + row + ":col=" + col);
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.dirty = true;
        int rowIndex = row;
        if (this.indexes != null) {
            rowIndex = this.indexes[row];
        }
        super.setValueAt(value, rowIndex, col);
    }

    public void sortByColumn(int column, boolean isAscent) {
        this.column = column;
        this.ascent = isAscent;
        if (this.sorter == null) {
            this.sorter = new TableSorter(this, this.ignoreNulls);
        }
        this.sorter.sort(column, isAscent);
        this.fireTableDataChanged();
    }

    public int[] getIndexes() {
        int n = this.getRowCount();
        if (this.indexes != null && this.indexes.length == n) {
            return this.indexes;
        }
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
        return this.indexes;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.colonneEditabili != null || this.colonneEditabiliByName != null) {
            int i;
            boolean found;
            if (this.colonneEditabili != null) {
                found = false;
                for (i = 0; i < this.colonneEditabili.length; ++i) {
                    if (this.colonneEditabili[i] != col) continue;
                    return true;
                }
            }
            if (this.colonneEditabiliByName != null) {
                found = false;
                for (i = 0; i < this.colonneEditabiliByName.length; ++i) {
                    if (!this.colonneEditabiliByName[i].equalsIgnoreCase(this.getColumnName(col))) continue;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void removeRow(int arg0) {
        super.removeRow(arg0);
        this.resort();
    }

    public void resort() {
        if (this.sorter != null) {
            this.sorter.sort(this.column, this.ascent);
        }
    }
}

