/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import it.tnx.DbI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.TableColumnModel;
import tnxbeans.CurrencyEditor;
import tnxbeans.SortableTableModel;
import tnxbeans.tnxDbGrid;
import tnxbeans.tnxDbGrid_eventi;

class TRiempiGriglia
extends Thread {
    Connection connection;
    Statement stat;
    ResultSet resu;
    ResultSetMetaData meta;
    String sql;
    int numeColo;
    SortableTableModel tm;
    tnxDbGrid tabella;
    int[] colonneEditabili;
    private DbI db;

    public TRiempiGriglia(String sql, Connection connection, tnxDbGrid tabella, SortableTableModel tm, int[] colonneEditabili, DbI db) {
        this.sql = sql;
        this.connection = connection;
        this.tabella = tabella;
        this.tm = tm;
        this.colonneEditabili = colonneEditabili;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        this.setPriority(10);
        try {
            this.stat = this.db != null ? this.db.getDbConn().createStatement() : this.connection.createStatement();
            this.resu = this.stat.executeQuery(this.sql);
            this.tabella.meta = this.meta = this.resu.getMetaData();
            this.numeColo = this.meta.getColumnCount() + 1;
            String[] Colo = new String[this.numeColo];
            Colo[0] = "";
            for (int i2 = 1; i2 <= this.numeColo - 1; ++i2) {
                Colo[i2] = this.meta.getColumnLabel(i2);
                this.tabella.columnsName.put(this.meta.getColumnLabel(i2), new Integer(i2));
            }
            this.tm = new SortableTableModel(Colo, 0, null, this.colonneEditabili);
            while (this.resu.next()) {
                Object[] reco = new String[this.numeColo];
                reco[0] = ">";
                for (i = 1; i <= this.numeColo - 1; ++i) {
                    reco[i] = this.resu.getString(i);
                }
                this.tm.addRow(reco);
                this.yield();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        finally {
            try {
                this.stat.close();
            }
            catch (Exception err) {}
            try {
                this.resu.close();
            }
            catch (Exception err) {}
            this.meta = null;
        }
        if (this.tabella.dbEditabile && this.tabella.dbConsentiAggiunte) {
            Vector<String> tempRigaVuota = new Vector<String>();
            tempRigaVuota.add("*");
            this.tm.addRow(tempRigaVuota);
        }
        this.tabella.setModel(this.tm);
        this.tabella.calcolaColSizePerc();
        if (this.tabella.dbEditabile) {
            tnxDbGrid_eventi lisEventi = new tnxDbGrid_eventi(this.tabella);
            this.tabella.getModel().addTableModelListener(lisEventi);
        }
        TableColumnModel defColu = this.tabella.getColumnModel();
        if (!this.tabella.dbEditabile) {
            this.tabella.setDefaultEditor(this.tabella.getColumnClass(0), null);
        }
        boolean ret = this.tabella.setTm(this.tm);
        this.tabella.resizeColumnsPerc(true);
        this.tabella.getSelectionModel().setSelectionInterval(0, 0);
        this.tabella.getColumn(this.tabella.getColumnName(0)).setCellRenderer(this.tabella.infoRender);
        this.tabella.getColumnModel().getColumn(0).setWidth(20);
        this.tabella.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.tabella.getColumnModel().getColumn(0).setMaxWidth(20);
        this.tabella.getColumnModel().getColumn(0).setMinWidth(20);
        this.tabella.getColumnModel().getColumn(0).setResizable(false);
        this.tabella.refreshRecords();
        try {
            for (i = 1; i <= this.tabella.meta.getColumnCount(); ++i) {
                if (this.tabella.meta.getColumnType(i) != 3 && this.tabella.meta.getColumnType(i) != 8) continue;
                this.tabella.getColumn(this.meta.getColumnLabel(i)).setCellRenderer(this.tabella.currencyRender);
                this.tabella.getColumn(this.meta.getColumnLabel(i)).setCellEditor(new CurrencyEditor(this.tabella));
            }
        }
        catch (SQLException sqlErr) {
            sqlErr.printStackTrace();
        }
        this.stop();
    }

    public void setColumnsSize(double[] percent) {
    }
}

