/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import it.tnx.DbI;
import it.tnx.commons.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import tnxbeans.SortableTableModel;
import tnxbeans.TRiempiGriglia2;
import tnxbeans.tnxDbGridColumnTitle;
import tnxbeans.tnxDbPanel;

public class tnxDbGrid2
extends JXTable
implements Serializable {
    public Vector dbChiave;
    public tnxDbPanel dbPanel;
    public JLabel labRecords;
    public JScrollPane scrollPane;
    public String dbNomeTabella;
    public boolean dbEditabile = false;
    private boolean chiediDiSalvareModifiche = true;
    public static int SU_SPOSTAMENTO_SALVA = 1;
    public static int SU_SPOSTAMENTO_ANNULLA = 2;
    public static int SU_SPOSTAMENTO_CHIEDI = 3;
    private int cosaFareSuSpostamento = 3;
    public boolean dbConsentiAggiunte = true;
    public int[] colonneEditabili;
    public DefaultTableCellRenderer currencyRender = null;
    private Connection connection;
    private Statement stat;
    private SortableTableModel tm;
    private String oldSql;
    private Connection oldConnection;
    public ResultSetMetaData meta;
    public boolean isFinding = false;
    public boolean flagUsaThread = false;
    public boolean flagUsaOrdinamento = true;
    public Hashtable columnsSizePerc;
    public Hashtable columnsSizePercOrig;
    public Hashtable columnsAlign;
    public Hashtable columnsProps;
    public Hashtable columnsName = new Hashtable();
    private boolean isAlreadyAlign = false;
    private boolean isAlreadyProps = false;
    private int oldWidth;
    private int oldSelectedRow;
    private Hashtable columnsTitle;
    private Hashtable columnsTitleLang;
    private boolean isResizing = false;
    private int countOpens = 0;
    private int countResize = 0;
    public DefaultTableCellRenderer infoRender;
    private int prevRow = 0;
    private int prevCol = 0;
    private boolean dirty = false;
    private boolean giaAgganciato = false;
    private DbI db;
    private int rollOverRowIndex = -1;
    boolean refreshSuSpostamento = true;

    public tnxDbGrid2() {
        RollOverListener lst = new RollOverListener();
        this.addMouseMotionListener(lst);
        this.addMouseListener(lst);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (this.isRowSelected(row)) {
            c.setForeground(this.getSelectionForeground());
            c.setBackground(this.getSelectionBackground());
        } else if (row == this.rollOverRowIndex) {
            c.setForeground(this.getSelectionForeground().brighter());
            c.setBackground(this.getSelectionBackground().brighter());
        } else {
            c.setForeground(this.getForeground());
            c.setBackground(this.getBackground());
        }
        return c;
    }

    public void calcolaColSizePerc() {
        if (this.columnsSizePerc != null) {
            String col;
            if (this.columnsSizePercOrig == null) {
                this.columnsSizePercOrig = (Hashtable)this.columnsSizePerc.clone();
            }
            Set s = this.columnsSizePercOrig.keySet();
            Iterator iter = s.iterator();
            Double totale = 0.0;
            while (iter.hasNext()) {
                col = (String)iter.next();
                try {
                    this.getColumn(col);
                    totale = totale + (Double)this.columnsSizePercOrig.get(col);
                }
                catch (Exception exception) {}
            }
            iter = s.iterator();
            this.columnsSizePerc.clear();
            while (iter.hasNext()) {
                col = (String)iter.next();
                try {
                    this.getColumn(col);
                    Double current = (Double)this.columnsSizePercOrig.get(col);
                    this.columnsSizePerc.put(col, current * 100.0 / totale);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getTempDir(boolean withFinalSlash) {
        System.out.println("TempDir:" + System.getProperty("java.io.tmpdir") + tnxDbGrid2.getDirSeparator());
        if (withFinalSlash) {
            return System.getProperty("java.io.tmpdir") + tnxDbGrid2.getDirSeparator();
        }
        return System.getProperty("java.io.tmpdir");
    }

    public static String getDirSeparator() {
        return System.getProperty("file.separator");
    }

    public static double getDoubleEng(String numero) {
        if (numero.equals("")) {
            return 0.0;
        }
        try {
            return Double.valueOf(numero);
        }
        catch (Exception err) {
            return 0.0;
        }
    }

    public void setCosaFareSuSpostamento(int value) {
        this.cosaFareSuSpostamento = value;
    }

    public int getCosaFareSuSpostamento() {
        return this.cosaFareSuSpostamento;
    }

    public void setRefreshSuSpostamento(boolean value) {
        this.refreshSuSpostamento = value;
    }

    public boolean getRefreshSuSpostamento() {
        return this.refreshSuSpostamento;
    }

    public String stampaTabella(String titolo, int[] headerWidth) {
        return this.stampaTabella(titolo, headerWidth, null);
    }

    public String stampaTabella(String titolo, int[] headerWidth, String piede) {
        String nomeFilePdf = tnxDbGrid2.getTempDir(true) + "tempStampa.pdf";
        String nomeFileHtml = tnxDbGrid2.getTempDir(true) + "tempStampa.html";
        try {
            Cell tempPdfCell;
            Document document = new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(nomeFilePdf));
            document.addTitle("stampa tabella");
            document.addSubject("stampa tabella");
            document.addKeywords("stampa tabella");
            document.addAuthor("TNX s.a.s");
            document.addHeader("Expires", "0");
            document.open();
            Font bf = new Font(1, 7.0f, 0);
            BaseFont bfCour = BaseFont.createFont((String)"Courier", (String)"winansi", (boolean)false);
            BaseFont bf_italic = BaseFont.createFont((String)"Helvetica-Oblique", (String)"winansi", (boolean)false);
            BaseFont bf_bold = BaseFont.createFont((String)"Helvetica-Bold", (String)"winansi", (boolean)false);
            BaseFont bf_times = BaseFont.createFont((String)"Times-Roman", (String)"winansi", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            boolean riga = false;
            double iy = 1.25;
            double y = 4.0;
            Table datatable = new Table(this.meta.getColumnCount());
            datatable.setBorder(0);
            datatable.setPadding(2.0f);
            if (headerWidth != null) {
                datatable.setWidths(headerWidth);
            }
            datatable.setWidth(100.0f);
            datatable.setCellsFitPage(true);
            Phrase intestazione = new Phrase();
            intestazione.add((Object)new Chunk(titolo, new Font(2, 10.0f, 1)));
            document.add((Element)intestazione);
            for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
                tempPdfCell = new Cell((Element)new Phrase(this.meta.getColumnLabel(i), bf));
                this.set1(tempPdfCell);
                datatable.addCell(tempPdfCell);
            }
            for (int j = 0; j < this.tm.getRowCount(); ++j) {
                for (int i = 0; i < this.meta.getColumnCount(); ++i) {
                    tempPdfCell = new Cell((Element)new Phrase(this.nz(String.valueOf(this.getValueAt(j, i)), ""), bf));
                    this.set2(tempPdfCell);
                    datatable.addCell(tempPdfCell);
                }
            }
            document.add((Element)datatable);
            if (piede != null) {
                Phrase pPiede = new Phrase();
                pPiede.add((Object)new Chunk(piede, new Font(2, 10.0f, 1)));
                document.add((Element)pPiede);
            }
            document.close();
            return nomeFilePdf;
        }
        catch (Exception err) {
            JOptionPane.showMessageDialog(null, err.toString());
            err.printStackTrace();
            return null;
        }
    }

    void set1(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 240));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(1);
    }

    void set2(Cell tempPdfCell) {
        tempPdfCell.setBackgroundColor(new Color(255, 255, 255));
        tempPdfCell.setBorderColor(new Color(200, 200, 200));
        tempPdfCell.setHorizontalAlignment(0);
    }

    public boolean setTm(SortableTableModel tm) {
        this.tm = tm;
        return true;
    }

    public TableModel getTm() {
        return this.tm;
    }

    public boolean dbOpen(Connection connection, String sql, DbI db) {
        this.db = db;
        return this.dbOpen(connection, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dbOpen(Connection connection, String sql) {
        DefaultTableCellRenderer dateRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
                if (value != null) {
                    super.setValue(dateFormat.format((Date)value));
                } else {
                    super.setValue("");
                }
            }
        };
        DefaultTableCellRenderer dateTimeRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy hh:mm");
                if (value != null) {
                    super.setValue(dateFormat.format(value));
                } else {
                    super.setValue("");
                }
            }
        };
        this.currencyRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    double d = tnxDbGrid2.getDoubleEng(String.valueOf(value));
                    NumberFormat form = DecimalFormat.getInstance(Locale.ITALIAN);
                    form.setGroupingUsed(true);
                    form.setMaximumFractionDigits(5);
                    form.setMinimumFractionDigits(2);
                    super.setValue(form.format(d));
                    if (d < 0.0) {
                        this.setForeground(new Color(200, 0, 0));
                    }
                    this.setHorizontalAlignment(4);
                } else {
                    super.setValue(null);
                }
            }
        };
        this.infoRender = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                if (value.toString().equals("*")) {
                    this.setBackground(new Color(220, 200, 200));
                } else {
                    this.setBackground(new Color(200, 200, 200));
                }
                this.setHorizontalAlignment(0);
            }
        };
        this.setAutoResizeMode(0);
        ++this.countOpens;
        this.getParent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                tnxDbGrid2.this.this_componentResized(e);
            }
        });
        this.getParent().addMouseListener(new MouseAdapter(){

            public void mouseEvent(MouseEvent e) {
                tnxDbGrid2.this.this_mouseEvent(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEvent(MouseEvent e) {
                tnxDbGrid2.this.this_mouseEvent(e);
            }
        });
        this.oldSql = sql;
        this.oldConnection = connection;
        if (!this.flagUsaThread) {
            ResultSetMetaData meta;
            ResultSet resu = null;
            try {
                this.stat = this.db != null ? this.db.getDbConn().createStatement() : connection.createStatement();
                resu = this.stat.executeQuery(sql);
                meta = resu.getMetaData();
                int numeColo = meta.getColumnCount();
                String[] Colo = new String[numeColo];
                for (int i = 1; i <= numeColo; ++i) {
                    Colo[i - 1] = meta.getColumnLabel(i);
                }
                this.tm = new SortableTableModel(Colo, 0, meta, this.colonneEditabili);
                int numRec = 0;
                while (resu.next()) {
                    ++numRec;
                    Object[] reco = new Object[numeColo];
                    for (int i = 1; i <= numeColo; ++i) {
                        if (meta.getColumnType(i) == 12 || meta.getColumnType(i) == 1) {
                            reco[i - 1] = resu.getString(i);
                            continue;
                        }
                        if (meta.getColumnType(i) == 4 || meta.getColumnType(i) == 5) {
                            if (resu.getString(i) == null) {
                                reco[i - 1] = "";
                                continue;
                            }
                            reco[i - 1] = new Integer(resu.getInt(i));
                            continue;
                        }
                        reco[i - 1] = meta.getColumnType(i) == -5 ? resu.getObject(i) : (meta.getColumnType(i) == 3 || meta.getColumnType(i) == 8 ? new Double(resu.getDouble(i)) : (meta.getColumnType(i) == 91 ? resu.getDate(i) : resu.getObject(i)));
                    }
                    this.tm.addRow(reco);
                }
                if (this == null) {
                    boolean reco = true;
                    return reco;
                }
                this.setModel(this.tm);
                this.calcolaColSizePerc();
                for (int i = 1; i <= numeColo; ++i) {
                    if (meta.getColumnType(i) == 12 || meta.getColumnType(i) == 1 || meta.getColumnType(i) == 4 || meta.getColumnType(i) == 5 || meta.getColumnType(i) == -5 || meta.getColumnType(i) == 3 || meta.getColumnType(i) == 8) continue;
                    if (meta.getColumnType(i) == 91) {
                        this.getColumn(meta.getColumnLabel(i)).setCellRenderer(dateRender);
                        continue;
                    }
                    if (meta.getColumnType(i) != 93) continue;
                    this.getColumn(meta.getColumnLabel(i)).setCellRenderer(dateTimeRender);
                }
                this.meta = meta;
                TableColumnModel defColu = this.getColumnModel();
                if (!this.dbEditabile) {
                    this.setDefaultEditor(this.getColumnClass(1), null);
                }
                while (this.tm.getRowCount() != this.getRowCount()) {
                    Thread.yield();
                }
                this.resizeColumnsPerc(true);
                this.getSelectionModel().setSelectionInterval(0, 0);
                this.refreshRecords();
                if (this.flagUsaOrdinamento) {
                    this.openSort();
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception err) {
                err.printStackTrace();
                System.out.println("sql errore:" + sql);
            }
            finally {
                try {
                    this.stat.close();
                }
                catch (Exception exception) {}
                try {
                    resu.close();
                }
                catch (Exception exception) {}
                meta = null;
            }
        }
        TRiempiGriglia2 ciclo = new TRiempiGriglia2(sql, connection, this, this.tm, this.colonneEditabili, this.db);
        ciclo.start();
        return true;
    }

    void openSort() {
    }

    public void dbRefresh() {
        this.oldSelectedRow = this.getSelectedRow();
        this.dbOpen(this.oldConnection, this.oldSql);
        if (this.dbPanel == null) {
            try {
                if (this.getRowCount() > this.oldSelectedRow && this.oldSelectedRow >= 0 && this.getRowCount() > 0) {
                    System.out.println("grid refresh:rowcount:" + this.getRowCount() + " oldrow:" + this.oldSelectedRow);
                    this.setRowSelectionInterval(this.oldSelectedRow, this.oldSelectedRow);
                    if (!this.getVisibleRect().contains(this.getCellRect(this.getSelectedRow(), 1, true))) {
                        this.scrollToRow(this.getSelectedRow());
                    }
                } else if (this.getRowCount() > 0) {
                    this.setRowSelectionInterval(1, 1);
                    if (!this.getVisibleRect().contains(this.getCellRect(this.getSelectedRow(), 1, true))) {
                        this.scrollToRow(this.getSelectedRow());
                    }
                }
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        this.refreshRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dbDelete() {
        String sql = "";
        Vector<String> valoriChiave = new Vector<String>();
        try {
            for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
                String tipoCampo = this.meta.getColumnTypeName(i);
                if (!this.dbChiave.contains(this.getColumnName(i - 1))) continue;
                valoriChiave.add(this.pc(this.getValueAt(this.getSelectedRow(), i - 1).toString(), tipoCampo));
            }
            if (valoriChiave.size() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "griglia:valorichiave vuoto!!!");
            }
            if (this.dbNomeTabella == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "griglia:nometabella nullo!!!");
            }
            if (this.dbNomeTabella.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "griglia:nometabella vuoto!!!");
            }
            sql = "delete from " + this.dbNomeTabella + " where ";
            for (int l = 0; l < this.dbChiave.size(); ++l) {
                sql = l == 0 ? sql + (String)this.dbChiave.get(l) + " = " + (String)valoriChiave.get(l) : sql + " and " + (String)this.dbChiave.get(l) + " = " + (String)valoriChiave.get(l);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(null, err.toString());
        }
        try {
            this.stat = this.db != null ? this.db.getDbConn().createStatement() : this.oldConnection.createStatement();
            this.stat.execute(sql);
            this.tm.removeRow(this.getSelectedRow());
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(null, err.toString());
        }
        finally {
            try {
                this.stat.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void dbGoNext() {
        if (this.getSelectedRow() < this.getRowCount() - 1) {
            this.getSelectionModel().setSelectionInterval(this.getSelectedRow() + 1, this.getSelectedRow() + 1);
            if (this.getSelectedRow() == 0) {
                this.dbGoNext();
            } else {
                this.dbSelezionaRiga();
            }
        }
    }

    public void dbGoPrevious() {
        if (this.getSelectedRow() > 0) {
            this.getSelectionModel().setSelectionInterval(this.getSelectedRow() - 1, this.getSelectedRow() - 1);
            this.dbSelezionaRiga();
        }
    }

    public void dbGoFirst() {
        this.getSelectionModel().setSelectionInterval(0, 0);
        this.dbSelezionaRiga();
    }

    public void dbGoLast() {
        this.getSelectionModel().setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        this.dbSelezionaRiga();
    }

    public void dbSelezionaRiga() {
        if (this.dbPanel != null && this.getSelectedRowCount() > 0) {
            if (this.getValueAt(this.getSelectedRow(), 0).toString().equals("*")) {
                return;
            }
            this.refreshRecords();
            if (!this.dbPanel.dbStato.equals(tnxDbPanel.DB_LETTURA) && !this.isFinding) {
                int ret;
                if (this.cosaFareSuSpostamento == SU_SPOSTAMENTO_ANNULLA) {
                    if (this.refreshSuSpostamento) {
                        this.dbRefresh();
                    }
                } else if (this.cosaFareSuSpostamento == SU_SPOSTAMENTO_SALVA) {
                    this.dbPanel.dbSave();
                    if (this.refreshSuSpostamento) {
                        this.dbRefresh();
                    }
                } else if (this.cosaFareSuSpostamento == SU_SPOSTAMENTO_CHIEDI && (ret = JOptionPane.showConfirmDialog(this.getRootPane(), "Salvare le modifiche apportate ?", "Attenzione", 0, 3)) == 0) {
                    this.dbPanel.dbSave();
                    if (this.refreshSuSpostamento) {
                        this.dbRefresh();
                    }
                }
            }
            Vector<String> temp = new Vector<String>();
            for (int i = 0; i < this.dbChiave.size(); ++i) {
                boolean trovato = false;
                int idCampo = 0;
                if (this.dbChiave.get(i) instanceof String) {
                    for (int j = 0; j < this.tm.getColumnCount(); ++j) {
                        if (!this.tm.getColumnName(j).equalsIgnoreCase((String)this.dbChiave.get(i))) continue;
                        trovato = true;
                        idCampo = j;
                        j = this.tm.getColumnCount();
                    }
                } else {
                    trovato = true;
                    Integer tempI = (Integer)this.dbChiave.get(i);
                    idCampo = tempI;
                }
                if (!trovato) continue;
                String valore = "";
                valore = this.nz(this.tm.getValueAt(this.getSelectedRow(), idCampo).toString(), "");
                temp.add(valore);
            }
            this.dbPanel.dbSelectSingle(temp);
            this.dbPanel.dbRefresh();
        }
    }

    public void dbSelezionaRiga(int colIndex, Object value) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, colIndex).toString().equals(value.toString())) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    public void refreshRecords() {
        if (this.labRecords != null) {
            this.labRecords.setText("R " + (this.getSelectedRow() + 1) + "/" + this.getRowCount());
        }
    }

    public boolean dbFindFirst() {
        this.isFinding = true;
        this.setRowSelectionInterval(0, 0);
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int j;
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            if ((griglia = this.nz(this.getValueAt(j = this.getSelectedRow(), numeColo), "")).length() < campo.length() || !griglia.substring(0, campo.length()).equalsIgnoreCase(campo)) continue;
            this.setRowSelectionInterval(j, j);
            this.scrollToRow(this.getSelectedRow());
            this.dbSelezionaRiga();
            if (this.dbPanel.butSave != null) {
                this.dbPanel.butSave.setEnabled(false);
            }
            if (this.dbPanel.butUndo == null) continue;
            this.dbPanel.butUndo.setEnabled(false);
        }
        if (!this.dbFindNext()) {
            JOptionPane.showMessageDialog(null, "Posizione inesistente");
            this.isFinding = false;
            return false;
        }
        this.isFinding = false;
        return true;
    }

    public boolean dbFindNext() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        this.isFinding = true;
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            for (int j = this.getSelectedRow() + 1; j < this.getRowCount(); ++j) {
                griglia = this.nz(this.getValueAt(j, numeColo), "");
                try {
                    if (this.getValueAt(j, numeColo) != null && this.meta.getColumnType(numeColo + 1) == 91) {
                        griglia = dateFormat.format((Date)this.getValueAt(j, numeColo));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (griglia.length() < campo.length() || !griglia.substring(0, campo.length()).equalsIgnoreCase(campo)) continue;
                this.setRowSelectionInterval(j, j);
                this.scrollToRow(this.getSelectedRow());
                this.dbSelezionaRiga();
                if (this.dbPanel.butSave != null) {
                    this.dbPanel.butSave.setEnabled(false);
                }
                if (this.dbPanel.butUndo != null) {
                    this.dbPanel.butUndo.setEnabled(false);
                }
                this.isFinding = false;
                return true;
            }
        }
        this.isFinding = false;
        return false;
    }

    public boolean dbFindFirstSub() {
        this.isFinding = true;
        this.setRowSelectionInterval(0, 0);
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int j;
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            if ((griglia = this.nz(this.getValueAt(j = this.getSelectedRow(), numeColo), "")).length() < campo.length()) continue;
            try {
                if (griglia.toUpperCase().indexOf(campo.toUpperCase()) < 0) continue;
                this.setRowSelectionInterval(j, j);
                this.scrollToRow(this.getSelectedRow());
                this.dbSelezionaRiga();
                if (this.dbPanel.butSave != null) {
                    this.dbPanel.butSave.setEnabled(false);
                }
                if (this.dbPanel.butUndo == null) continue;
                this.dbPanel.butUndo.setEnabled(false);
                continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        if (!this.dbFindNext()) {
            JOptionPane.showMessageDialog(null, "Posizione inesistente");
            this.isFinding = false;
            return false;
        }
        this.isFinding = false;
        return true;
    }

    public boolean dbFindNextSub() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        this.isFinding = true;
        boolean trovato = false;
        int numeColo = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnName(i).equalsIgnoreCase(this.dbPanel.ultimoCampo)) {
                trovato = true;
                numeColo = i;
                i = this.getColumnCount();
            }
            if (!trovato) continue;
            String griglia = "";
            String campo = "";
            campo = this.dbPanel.ultimoValore;
            if (this.getSelectedRow() == -1) {
                this.setRowSelectionInterval(0, 0);
            }
            for (int j = this.getSelectedRow() + 1; j < this.getRowCount(); ++j) {
                griglia = this.nz(this.getValueAt(j, numeColo), "");
                try {
                    if (this.getValueAt(j, numeColo) != null && this.meta.getColumnType(numeColo + 1) == 91) {
                        griglia = dateFormat.format((Date)this.getValueAt(j, numeColo));
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (griglia.length() < campo.length()) continue;
                try {
                    if (griglia.toUpperCase().indexOf(campo.toUpperCase()) < 0) continue;
                    this.setRowSelectionInterval(j, j);
                    this.scrollToRow(this.getSelectedRow());
                    this.dbSelezionaRiga();
                    if (this.dbPanel.butSave != null) {
                        this.dbPanel.butSave.setEnabled(false);
                    }
                    if (this.dbPanel.butUndo != null) {
                        this.dbPanel.butUndo.setEnabled(false);
                    }
                    this.isFinding = false;
                    return true;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        }
        this.isFinding = false;
        return false;
    }

    private void jbInit() throws Exception {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                tnxDbGrid2.this.this_keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                tnxDbGrid2.this.this_keyReleased(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                tnxDbGrid2.this.this_mousePressed(e);
            }
        });
    }

    void this_mouseClicked(MouseEvent e) {
    }

    void this_mousePressed(MouseEvent e) {
        this.dbSelezionaRiga();
        if (e.getClickCount() == 2 && e.getComponent().getClass().getName().equals("tnxbeans.tnxDbGrid") && this.dbPanel != null) {
            Container tempParent = this.dbPanel.getParent();
            if (!tempParent.getClass().getName().equalsIgnoreCase("JTabbedPane")) {
                for (int i = 0; i < 5; ++i) {
                    if (!(tempParent = tempParent.getParent()).getClass().getName().equalsIgnoreCase("javax.swing.JTabbedPane")) continue;
                    i = 10;
                }
            }
            if (tempParent.getClass().getName().equalsIgnoreCase("javax.swing.JTabbedPane")) {
                JTabbedPane tempTab = (JTabbedPane)tempParent;
                tempTab.setSelectedIndex(0);
            }
        }
    }

    void this_keyPressed(KeyEvent e) {
    }

    void this_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            this.dbSelezionaRiga();
        }
    }

    private String nz(String valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore;
    }

    private String nz(Object valore, String seNullo) {
        if (valore == null) {
            return seNullo;
        }
        return valore.toString();
    }

    public void scrollToRow(int row) {
        this.scrollPane = (JScrollPane)this.getParent().getParent();
        Rectangle rect = this.getCellRect(row, 1, true);
        this.scrollPane.getViewport().setViewPosition(new Point(1, (int)rect.getY()));
    }

    void this_componentResized(ComponentEvent e) {
        if (!this.isResizing) {
            this.resizeColumnsPerc(false);
        }
    }

    void this_mouseEvent(MouseEvent e) {
        if (e.getModifiers() == 501) {
            this.isResizing = true;
        }
        if (e.getModifiers() == 502) {
            this.isResizing = false;
        }
    }

    public void resizeColumnsPerc(boolean forceResize) {
        if (this.columnsSizePerc == null) {
            return;
        }
        String columnNameLingua = "";
        int colonnetotali = this.getColumnCount();
        int colonnesizeperc = 0;
        if (this.columnsSizePerc != null) {
            JInternalFrame parent;
            colonnesizeperc = this.columnsSizePerc.size();
            double colsWidth = this.getParent().getWidth();
            if (colsWidth == 0.0 && (parent = SwingUtils.getParentJInternalFrame((Component)((Object)this))) != null) {
                parent.validate();
                colsWidth = this.getParent().getWidth();
            }
            if (colsWidth == 0.0) {
                return;
            }
            if (this.getColumnCount() != this.columnsSizePerc.size()) {
                System.out.println("debug:griglia, numero colonne diverso:" + this.getColumnCount() + ":v=" + this.columnsSizePerc.size());
            }
            if (this.getColumnCount() > 0 && !this.isResizing && colsWidth > 0.0 && (this.oldWidth != this.getParent().getWidth() || forceResize)) {
                Object columnName;
                this.isResizing = true;
                ++this.countResize;
                this.oldWidth = this.getParent().getWidth();
                int contaColonne = 0;
                double test100 = 0.0;
                Enumeration e = this.columnsSizePerc.keys();
                while (e.hasMoreElements()) {
                    columnName = e.nextElement();
                    test100 += ((Double)this.columnsSizePerc.get(columnName)).doubleValue();
                }
                System.out.println("test100 = " + test100);
                double testwidth100 = 0.0;
                Enumeration e2 = this.columnsSizePerc.keys();
                while (e2.hasMoreElements()) {
                    columnName = e2.nextElement();
                    try {
                        columnNameLingua = this.columnsTitleLang.get(columnName).toString();
                    }
                    catch (Exception err) {
                        columnNameLingua = "";
                    }
                    if (columnName.equals("persona_riferimento")) {
                        System.out.println("stop");
                    }
                    if (contaColonne >= 0) {
                        try {
                            TableColumn col;
                            try {
                                col = this.getColumn(String.valueOf(columnName));
                            }
                            catch (Exception err) {
                                col = this.getColumn(String.valueOf(columnNameLingua));
                            }
                            Double colWidthPerc = (Double)this.columnsSizePerc.get(columnName);
                            if (colWidthPerc != 0.0) {
                                int newsize = (int)(colsWidth / 100.0 * colWidthPerc);
                                testwidth100 += (double)newsize;
                                col.setPreferredWidth(newsize);
                            } else {
                                col.setMinWidth(0);
                                col.setWidth(0);
                                col.setPreferredWidth(0);
                                col.setMaxWidth(0);
                                col.setResizable(false);
                            }
                        }
                        catch (Exception err) {
                            System.err.println("non trovata colonna:" + columnName + " err:" + err.getMessage());
                        }
                    }
                    ++contaColonne;
                }
                System.out.println("testwidth100 = " + testwidth100 + " contro width:" + colsWidth);
                TableColumnModel tcm = this.getColumnModel();
                for (int i = 0; i < tcm.getColumnCount(); ++i) {
                    TableColumn tc = tcm.getColumn(i);
                    if (this.columnsSizePerc.containsKey(tc.getIdentifier())) continue;
                    System.err.println("!!! colonna " + tc.getIdentifier() + ": dimension in columnsSizePerc non specificata");
                }
                if (this.columnsTitle != null) {
                    Enumeration e3 = this.columnsTitle.keys();
                    while (e3.hasMoreElements()) {
                        Integer columnIndex = (Integer)e3.nextElement();
                        String caption = (String)this.columnsTitle.get(columnIndex);
                        this.setColumnTitle((int)columnIndex, caption);
                    }
                }
                TableColumn lastcol = null;
                int rimanente = ((JViewport)this.getParent()).getWidth();
                int totcol = 0;
                int dimlastcol = 0;
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    TableColumn colc = this.getColumnModel().getColumn(i);
                    if (colc.getPreferredWidth() <= 0) continue;
                    totcol += colc.getPreferredWidth();
                    dimlastcol = colc.getPreferredWidth();
                    rimanente -= dimlastcol;
                    lastcol = colc;
                }
                lastcol.setPreferredWidth(rimanente + dimlastcol);
                this.isResizing = false;
            }
        }
    }

    String replaceChars(String stri, char daTrov, String daMett) {
        int leng = stri.length();
        String prim = "";
        String dopo = "";
        String risu = "";
        int oldI = 0;
        for (int i = 0; i < leng; ++i) {
            if (stri.charAt(i) != daTrov) continue;
            prim = stri.substring(oldI, i);
            risu = risu + prim + daMett;
            oldI = i + 1;
        }
        risu = risu + stri.substring(oldI, leng);
        return risu;
    }

    public String aa(String stringa) {
        return this.replaceChars(stringa, '\'', "''");
    }

    public String pc(String campo, String tipoCampo) {
        if (tipoCampo == "LONG") {
            return campo;
        }
        if (tipoCampo == "DECIMAL") {
            return "(" + campo + ")";
        }
        if (tipoCampo == "VARCHAR") {
            return "'" + this.aa(campo) + "'";
        }
        return "'" + this.aa(campo) + "'";
    }

    String spezza(String stringa, int ogni) {
        String temp = "";
        for (int i = 0; i < stringa.length(); i += ogni) {
            temp = i + ogni > stringa.length() ? temp + stringa.substring(i, stringa.length()) + "\n" : temp + stringa.substring(i, i + ogni) + "\n";
        }
        return temp;
    }

    public void test1() {
        this.getModel().setValueAt("test", 1, 1);
        SortableTableModel temp1 = (SortableTableModel)this.getModel();
        temp1.setNumRows(1);
        Object[] dati = new Object[]{"aaa", "bbb", "ccc"};
        temp1.addRow(dati);
    }

    public int getColumnByName(String colName) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equalsIgnoreCase(colName)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataEntry(int row) {
        block22: {
            try {
                int i;
                Vector<String> valoriChiave = new Vector<String>();
                for (int i2 = 0; i2 < this.dbChiave.size(); ++i2) {
                    String valore = this.getValueAt(row, new Integer(this.columnsName.get(this.dbChiave.get(i2)).toString())).toString();
                    String tipo = this.meta.getColumnTypeName(new Integer(this.columnsName.get(this.dbChiave.get(i2)).toString()));
                    valoriChiave.add(this.dbChiave.get(i2) + " = " + this.pc(valore, tipo));
                }
                String sql = "";
                Vector<String> nomiCampo = new Vector<String>();
                Vector<Object> valoriCampo = new Vector<Object>();
                Vector<String> tipiCampo = new Vector<String>();
                for (i = 0; i < this.meta.getColumnCount(); ++i) {
                    nomiCampo.add(this.meta.getColumnLabel(i + 1));
                    valoriCampo.add(this.getValueAt(row, i + 1));
                    tipiCampo.add(this.meta.getColumnTypeName(i + 1));
                }
                if (row + 1 == this.getRowCount() - 1 && this.dbConsentiAggiunte) {
                    sql = sql + "insert into " + this.meta.getTableName(1) + " (";
                    for (i = 0; i < nomiCampo.size(); ++i) {
                        sql = i == nomiCampo.size() - 1 ? sql + nomiCampo.get(i) : sql + nomiCampo.get(i) + ", ";
                    }
                    sql = sql + ") values (";
                    for (i = 0; i < valoriCampo.size(); ++i) {
                        sql = i == valoriCampo.size() - 1 ? sql + this.pc(valoriCampo.get(i).toString(), tipiCampo.get(i).toString()) : sql + this.pc(valoriCampo.get(i).toString(), tipiCampo.get(i).toString()) + ", ";
                    }
                    sql = sql + ")";
                    System.out.println("grid_insert_sql:" + sql);
                    Statement stat = null;
                    stat = this.db != null ? this.db.getDbConn().createStatement() : this.oldConnection.createStatement();
                    int n = stat.executeUpdate(sql);
                    break block22;
                }
                sql = "update " + this.meta.getTableName(1) + " set ";
                for (i = 0; i < nomiCampo.size(); ++i) {
                    boolean ok = false;
                    if (this.colonneEditabili != null) {
                        for (int j = 0; j < this.colonneEditabili.length; ++j) {
                            if (this.colonneEditabili[j] != i + 1) continue;
                            ok = true;
                            break;
                        }
                    } else {
                        ok = true;
                    }
                    if (!ok) continue;
                    if (i == nomiCampo.size() - 1) {
                        sql = sql + nomiCampo.get(i);
                        sql = sql + " = " + this.pc(valoriCampo.get(i).toString(), tipiCampo.get(i).toString());
                        continue;
                    }
                    sql = sql + nomiCampo.get(i);
                    sql = sql + " = " + this.pc(valoriCampo.get(i).toString(), tipiCampo.get(i).toString()) + ", ";
                }
                sql = sql + " where ";
                for (i = 0; i < valoriChiave.size(); ++i) {
                    sql = sql + valoriChiave.get(i).toString();
                }
                System.out.println("grid_update_sql:" + sql);
                Statement stat = null;
                stat = this.db != null ? this.db.getDbConn().createStatement() : this.oldConnection.createStatement();
                int n = stat.executeUpdate(sql);
            }
            catch (Exception err) {
                err.printStackTrace();
            }
            finally {
                try {
                    this.stat.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public int getColumnSumInt(int numero_colonna) {
        int cSum = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            cSum += Integer.parseInt(this.getValueAt(i, numero_colonna).toString().replaceAll(",", ""));
        }
        return cSum;
    }

    public int getColumnSumInt(String nome_colonna) {
        int numero_colonna = this.getColumnByName(nome_colonna);
        return this.getColumnSumInt(numero_colonna);
    }

    public double getColumnSumDouble(int numero_colonna) {
        double cSum = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            cSum += Double.parseDouble(this.getValueAt(i, numero_colonna).toString());
        }
        return cSum;
    }

    public double getColumnSumDouble(String nome_colonna) {
        int numero_colonna = this.getColumnByName(nome_colonna);
        return this.getColumnSumDouble(numero_colonna);
    }

    public void setColumnTitle(int iCol, String title) {
        try {
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(iCol);
            tc.setHeaderValue(title);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColumnTitle(int iCol, tnxDbGridColumnTitle dbTitle) {
        String title = dbTitle.langTitle;
        if (this.columnsTitle == null) {
            this.columnsTitle = new Hashtable();
        }
        this.columnsTitle.put(new Integer(iCol), title);
        if (this.columnsTitleLang == null) {
            this.columnsTitleLang = new Hashtable();
        }
        this.columnsTitleLang.put(dbTitle.defaultTitle, title);
        try {
            TableColumnModel tcm = this.getColumnModel();
            TableColumn tc = tcm.getColumn(iCol);
            tc.setHeaderValue(title);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RollOverListener
    extends MouseInputAdapter {
        private RollOverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            tnxDbGrid2.this.rollOverRowIndex = -1;
            tnxDbGrid2.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = tnxDbGrid2.this.rowAtPoint(e.getPoint());
            if (row != tnxDbGrid2.this.rollOverRowIndex) {
                tnxDbGrid2.this.rollOverRowIndex = row;
                tnxDbGrid2.this.repaint();
            }
        }
    }
}

