/*
 * Decompiled with CFR 0.152.
 */
package tnxbeans;

import it.tnx.commons.ImgUtils;
import it.tnx.invoicex.InvoicexUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import tnxbeans.BasicField;
import tnxbeans.tnxDbPanel;
import tnxbeans.util;

public class tnxTextFieldLang
extends JPanel
implements BasicField {
    private List<String> lang = null;
    private List<JTextField> textfield;
    private Map<String, JTextField> lang_text = null;
    private List<JButton> buttons;
    public String dbNomeCampo;
    public String dbTipoCampo;
    public boolean dbRiempire = true;
    public boolean dbSalvare = true;
    private boolean dbModificato = false;
    int margin = 1;
    private tnxDbPanel parentPanel = null;

    public tnxTextFieldLang() {
        this.initComponents();
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(50, 20);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(50, 20);
            }

            @Override
            public void layoutContainer(Container parent) {
                tnxTextFieldLang.this.layoutComps();
            }
        });
    }

    public List<String> getLang() {
        return this.lang;
    }

    public void setLang(List<String> lang) {
        this.lang = lang;
        this.removeAll();
        this.setTextfield(new ArrayList<JTextField>());
        this.setLang_text(new HashMap<String, JTextField>());
        for (String l : lang) {
            LangJTextField a = new LangJTextField();
            a.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.change();
                }

                public void change() {
                    tnxTextFieldLang.this.setDbModificato(true);
                    util.checkModificati(tnxTextFieldLang.this);
                }
            });
            a.lang = l;
            this.getTextfield().add(a);
            this.getLang_text().put(l, a);
            this.add(a);
        }
        this.layoutComps();
    }

    private void layoutComps() {
        if (this.getLang() != null) {
            int langs = this.getLang().size();
            int w = this.getWidth();
            int h = this.getHeight();
            int ws = w / langs;
            int i = 0;
            for (String l : this.getLang()) {
                JTextField t = this.getTextfield().get(i);
                if (i == this.getLang().size() - 1) {
                    t.setBounds(ws * i + this.margin, this.margin, ws - this.margin * 2, h - this.margin * 2);
                } else {
                    t.setBounds(ws * i + this.margin, this.margin, ws - this.margin, h - this.margin * 2);
                }
                ++i;
            }
        }
    }

    public Map<String, JTextField> getLang_text() {
        return this.lang_text;
    }

    public void setLang_text(Map<String, JTextField> lang_text) {
        this.lang_text = lang_text;
    }

    @Override
    public tnxDbPanel getParentPanel() {
        return this.parentPanel;
    }

    @Override
    public void setParentPanel(tnxDbPanel parent) {
        this.parentPanel = parent;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test");
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout(2, 2));
        tnxTextFieldLang t = new tnxTextFieldLang();
        t.setBorder(new LineBorder(Color.red));
        f.getContentPane().add((Component)t, "Center");
        t.setLang(Arrays.asList("it", "en", "fr"));
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public List<JTextField> getTextfield() {
        return this.textfield;
    }

    public void setTextfield(List<JTextField> textfield) {
        this.textfield = textfield;
    }

    public List<JButton> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<JButton> buttons) {
        this.buttons = buttons;
    }

    @Override
    public String getDbNomeCampo() {
        return this.dbNomeCampo;
    }

    @Override
    public void setDbNomeCampo(String dbNomeCampo) {
        this.dbNomeCampo = dbNomeCampo;
    }

    @Override
    public String getDbTipoCampo() {
        return this.dbTipoCampo;
    }

    @Override
    public void setDbTipoCampo(String dbTipoCampo) {
        this.dbTipoCampo = dbTipoCampo;
    }

    @Override
    public boolean isDbRiempire() {
        return this.dbRiempire;
    }

    @Override
    public void setDbRiempire(boolean dbRiempire) {
        this.dbRiempire = dbRiempire;
    }

    @Override
    public boolean isDbSalvare() {
        return this.dbSalvare;
    }

    @Override
    public void setDbSalvare(boolean dbSalvare) {
        this.dbSalvare = dbSalvare;
    }

    @Override
    public boolean isDbModificato() {
        return this.dbModificato;
    }

    @Override
    public void setDbModificato(boolean dbModificato) {
        if (!InvoicexUtil.isDbPanelRefreshing(this)) {
            this.dbModificato = dbModificato;
        }
    }

    public String getText(String lang) {
        return this.getLang_text().get(lang).getText();
    }

    public void setText(String text) {
        for (String l : this.getLang()) {
            JTextField a = this.getLang_text().get(l);
            a.setText(text);
        }
    }

    public void setText(String lang, String text) {
        JTextField a = this.getLang_text().get(lang);
        a.setText(text);
    }

    public HashMap<String, String> getTextLang() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String l : this.getLang()) {
            JTextField a = this.getLang_text().get(l);
            ret.put(l, a.getText());
        }
        return ret;
    }

    public static class LangJTextField
    extends JTextField {
        public String lang = null;
        Locale locsel = null;
        String locsel_country = null;

        public LangJTextField() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Color old_color = g2.getColor();
            Font old_font = g2.getFont();
            Composite old_comp = g2.getComposite();
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int xrif = this.getWidth();
            int yrif = this.getHeight();
            if (this.locsel == null) {
                String lang2 = this.lang;
                if (lang2.equalsIgnoreCase("en")) {
                    this.locsel_country = "Great Britain";
                } else {
                    this.locsel = new Locale(this.lang.toLowerCase(), lang2.toUpperCase());
                    System.out.println(this.locsel);
                    this.locsel_country = this.locsel.getDisplayCountry(Locale.ENGLISH);
                    System.out.println(this.locsel_country);
                }
            }
            g2.setColor(new Color(old_color.getRed(), old_color.getGreen(), old_color.getBlue(), 50));
            g2.setFont(old_font.deriveFont(10.0f));
            g2.drawString(this.lang.toUpperCase(), xrif - 34, yrif - 5);
            try {
                BufferedImage flag = ImageIO.read(this.getClass().getResource("/flags/24/" + this.locsel_country + ".png"));
                g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                BufferedImage flagr = ImgUtils.resizeMedium((BufferedImage)flag, (int)((int)((double)flag.getWidth() * 0.75)), (int)((int)((double)flag.getHeight() * 0.75)));
                g2.drawImage((Image)flagr, xrif - 20, yrif - 18, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            g2.setColor(old_color);
            g2.setFont(old_font);
            g2.setComposite(old_comp);
            super.paintComponent(g2);
        }
    }
}

