/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex;

import gestioneFatture.main;
import java.io.IOException;
import java.net.Socket;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TestProviders {
    public static Integer idreg = null;

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            Server s = new Server();
            s.host = args[0];
            try {
                s.port = Integer.parseInt(args[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.mysql_user = args[2];
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.mysql_pass = args[3];
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s.mysql_db = args[4];
            }
            catch (Exception exception) {
                // empty catch block
            }
            Result result = TestProviders.avvia(s);
        } else {
            ArrayList<Server> servers = new ArrayList<Server>();
            Server s = new Server("due.tnx.it");
            servers.add(s);
            s = new Server("tre.tnx.it");
            servers.add(s);
            s = new Server("www.google.it", false);
            servers.add(s);
            for (Server sn : servers) {
                try {
                    Result r = TestProviders.avvia(sn);
                    System.out.println("testing " + sn.host + " res: " + r.ping_media + "/" + r.ping_min + "/" + r.ping_max + " sqlnet: " + r.bench_sql_net + " sqlcpu: " + r.bench_sql_cpu);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Result avvia(Server s) throws IOException, InterruptedException, ClassNotFoundException, SQLException, Exception {
        if (s.port == null) {
            s.port = 80;
        }
        if (s.mysql_user != null && s.mysql_db == null) {
            s.mysql_db = "bench";
        }
        Result r = new Result();
        r.server = s;
        long tot = 0L;
        long retry = 10L;
        long retrysql = 5L;
        long retrysqlrec = 10L;
        int i = 0;
        while ((long)i < retry) {
            long time1 = System.currentTimeMillis();
            Socket t = new Socket(s.host, (int)s.port);
            t.close();
            long time2 = System.currentTimeMillis();
            long diff = time2 - time1;
            if ((double)diff < r.ping_min || r.ping_min == 0.0) {
                r.ping_min = diff;
            }
            if ((double)diff > r.ping_max || r.ping_max == 0.0) {
                r.ping_max = diff;
            }
            System.out.println(diff + "ms");
            tot += time2 - time1;
            Thread.sleep(1000L);
            ++i;
        }
        r.ping_media = (double)tot / (double)retry;
        System.out.println("media ping porta " + s.port + " : " + (double)tot / (double)retry + "ms");
        if (s.mysql_user != null) {
            try {
                System.out.println("testing mysql");
                long time1 = System.currentTimeMillis();
                Class.forName("com.mysql.jdbc.Driver");
                Connection conn = null;
                conn = DriverManager.getConnection("jdbc:mysql://" + s.host + "/" + s.mysql_db, s.mysql_user, s.mysql_pass);
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery("SELECT CONNECTION_ID()");
                rs.next();
                Integer idconn = rs.getInt(1);
                int i2 = 0;
                while ((long)i2 < retrysql) {
                    String sql = "drop table if exists test_" + idconn;
                    st.execute(sql);
                    sql = "CREATE TABLE `test_" + idconn + "` (\n\t`id` INT NOT NULL AUTO_INCREMENT,\n\t`descrizione` VARCHAR(50) NULL,\n\tPRIMARY KEY (`id`)\n)\nCOLLATE='latin1_swedish_ci'\nENGINE=MyISAM;";
                    st.execute(sql);
                    int i3 = 0;
                    while ((long)i3 < retrysqlrec) {
                        sql = "insert into test_" + idconn + " set descrizione = 'test " + i2 + "-" + i3 + " ciao ciao'";
                        st.execute(sql);
                        ++i3;
                    }
                    i3 = 0;
                    while ((long)i3 < retrysqlrec) {
                        sql = "select SQL_NO_CACHE * from test_" + idconn;
                        rs = st.executeQuery(sql);
                        while (rs.next()) {
                            rs.getString("id");
                            rs.getString("descrizione");
                        }
                        rs.close();
                        ++i3;
                    }
                    ++i2;
                }
                long time2 = System.currentTimeMillis();
                long diff = time2 - time1;
                System.out.println("mysql: " + diff + "ms");
                r.bench_sql_net = diff;
                String sql = "drop procedure if exists testproc_" + idconn;
                st.execute(sql);
                System.out.println("inizio proc");
                sql = "CREATE PROCEDURE testproc_" + idconn + "()\n   BEGIN\n      DECLARE a INT Default 1;\n      simple_loop: LOOP\n         insert into test_" + idconn + " set descrizione = MD5(RAND());\n         SET a=a+1;\n         IF a=100000 THEN\n            LEAVE simple_loop;\n         END IF;\n   END LOOP simple_loop;\nEND";
                System.out.println("sql = " + sql);
                st.execute(sql);
                sql = "CALL testproc_" + idconn + "()";
                System.out.println("sql = " + sql);
                st.execute(sql);
                System.out.println("fine proc");
                int i3 = 0;
                while ((long)i3 < retrysqlrec) {
                    sql = "select SQL_NO_CACHE * from test_" + idconn + " order by descrizione limit 1";
                    System.out.println("sql = " + sql);
                    rs = st.executeQuery(sql);
                    while (rs.next()) {
                        rs.getString("id");
                        rs.getString("descrizione");
                    }
                    ++i3;
                }
                long time3 = System.currentTimeMillis();
                long diff2 = time3 - time2;
                System.out.println("mysql2: " + diff2 + "ms");
                r.bench_sql_cpu = diff2;
                sql = "drop table if exists test_" + idconn;
                st.execute(sql);
                sql = "drop procedure if exists testproc_" + idconn;
                st.execute(sql);
                conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String url = "http://server.invoicex.it/b.php?p=" + URLEncoder.encode(String.valueOf(r.ping_media), "ISO-8859-1") + "&sr=" + URLEncoder.encode(r.server.host, "ISO-8859-1") + (r.bench_sql_net != 0.0 ? "&s1=" + URLEncoder.encode(String.valueOf(r.bench_sql_net), "ISO-8859-1") : "") + (r.bench_sql_cpu != 0.0 ? "&s2=" + URLEncoder.encode(String.valueOf(r.bench_sql_cpu), "ISO-8859-1") : "") + (idreg != null ? "&i=" + idreg : "");
        System.out.println("url = " + url);
        String v = main.getURL((String)url);
        System.out.println("v = " + v);
        return r;
    }

    public static class Result {
        public double ping_media;
        public double ping_min;
        public double ping_max;
        public double bench_sql_net;
        public double bench_sql_cpu;
        public Server server;
    }

    public static class Server {
        public String host;
        public Integer port;
        public String mysql_user;
        public String mysql_pass;
        public String mysql_db;

        public Server() {
        }

        public Server(String host, boolean mysql) {
            this.host = host;
            if (mysql) {
                this.mysql_user = "bench";
                this.mysql_pass = "smcksh490t7";
            }
        }

        public Server(String host) {
            this(host, true);
        }
    }
}

