/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.allegati;

import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.users.FullAccount;
import invoicexplugininvoicex.dropbox.DropboxUtil;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXBusyLabel;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JPanelDropboxAllegati
extends JPanel {
    DropboxUtil du = new DropboxUtil();
    private JButton attiva;
    private ButtonGroup buttonGroup1;
    private JTextField codice;
    private JButton conferma_codice;
    private JLabel jLabel1;
    private JLabel jLabel2;
    public JXBusyLabel loading;
    private JLabel msg1;
    private JPanel pan_attivazione;
    private JLabel stato;

    public JPanelDropboxAllegati() {
        this.initComponents();
        this.pan_attivazione.setVisible(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.stato = new JLabel();
        this.jLabel2 = new JLabel();
        this.loading = new JXBusyLabel();
        this.pan_attivazione = new JPanel();
        this.attiva = new JButton();
        this.msg1 = new JLabel();
        this.jLabel1 = new JLabel();
        this.codice = new JTextField();
        this.conferma_codice = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.stato.setFont(this.stato.getFont().deriveFont(this.stato.getFont().getStyle() | 1));
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/invoicexplugininvoicex/dropbox/dropbox_logo.png")));
        this.loading.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.loading.setHorizontalAlignment(4);
        this.loading.setText("...caricamento in corso");
        this.loading.setBusy(true);
        this.loading.setHorizontalTextPosition(2);
        this.pan_attivazione.setBackground(new Color(255, 255, 255));
        this.attiva.setFont(this.attiva.getFont().deriveFont(this.attiva.getFont().getStyle() | 1, this.attiva.getFont().getSize() + 3));
        this.attiva.setText("Attiva collegamento con Dropbox");
        this.attiva.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelDropboxAllegati.this.attivaActionPerformed(evt);
            }
        });
        this.msg1.setText("<html><b>Importante: Copia la chiave assegnata da Dropbox qui sotto</b></html>");
        this.jLabel1.setText("Codice Dropbox");
        this.codice.setEditable(false);
        this.codice.setColumns(20);
        this.conferma_codice.setText("Conferma Codice");
        this.conferma_codice.setEnabled(false);
        this.conferma_codice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelDropboxAllegati.this.conferma_codiceActionPerformed(evt);
            }
        });
        GroupLayout pan_attivazioneLayout = new GroupLayout((Container)this.pan_attivazione);
        this.pan_attivazione.setLayout((LayoutManager)pan_attivazioneLayout);
        pan_attivazioneLayout.setHorizontalGroup((GroupLayout.Group)pan_attivazioneLayout.createParallelGroup(1).add((GroupLayout.Group)pan_attivazioneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pan_attivazioneLayout.createParallelGroup(1).add((Component)this.attiva, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)pan_attivazioneLayout.createSequentialGroup().add((Component)this.msg1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)pan_attivazioneLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.codice, -1, 164, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.conferma_codice))).addContainerGap()));
        pan_attivazioneLayout.setVerticalGroup((GroupLayout.Group)pan_attivazioneLayout.createParallelGroup(1).add((GroupLayout.Group)pan_attivazioneLayout.createSequentialGroup().add(1, 1, 1).add((Component)this.attiva).addPreferredGap(0).add((Component)this.msg1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)pan_attivazioneLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.codice, -2, -1, -2).add((Component)this.conferma_codice)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.pan_attivazione, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.stato).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.loading, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0, 10, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add(2, (GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.loading, -2, -1, -2).add((Component)this.stato))).addPreferredGap(0).add((Component)this.pan_attivazione, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jLabel2, this.loading, this.stato}, 2);
    }

    private void attivaActionPerformed(ActionEvent evt) {
        try {
            String authorizeUrl = this.du.attiva();
            String msg = "Adesso si aprir\u00e0 il browser sulla pagina di Dropbox per consentire ad Invoicex di accedere al tuo spazio Dropbox.\n";
            msg = msg + "Una volta eseguito il login su Dropbox e consentito l'accesso ti verr\u00e0 assegnata una chiave alfanumerica da riportare in Invoicex.\n";
            if (SwingUtils.showYesNoMessage((Component)this, (String)msg)) {
                SwingUtils.openUrl((URL)new URL(authorizeUrl));
                this.codice.setEditable(true);
                this.conferma_codice.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void conferma_codiceActionPerformed(ActionEvent evt) {
        if (this.codice.getText().trim().equals("")) {
            SwingUtils.showErrorMessage((Component)this, (String)"Inserisci il codice !");
            return;
        }
        String code = this.codice.getText().trim();
        try {
            if (this.du.conferma(code)) {
                this.pan_attivazione.setVisible(false);
                this.init();
            } else {
                SwingUtils.showErrorMessage((Component)this, (String)"Errore nell'attivazione", (String)"Impossibile attivare");
            }
        }
        catch (DbxException dbe) {
            dbe.printStackTrace();
            JSONParser p = new JSONParser();
            try {
                JSONObject jsono = (JSONObject)p.parse(dbe.getMessage());
                System.out.println("jsono = " + jsono);
                SwingUtils.showErrorMessage((Component)this, (String)((String)jsono.get((Object)"error_description")), (boolean)true);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                SwingUtils.showErrorMessage((Component)this, (String)dbe.getMessage(), (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage((Component)this, (Exception)e);
        }
    }

    public void init() {
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                System.out.println("init panel dropbox allegati");
                if (!JPanelDropboxAllegati.this.du.isValidToken()) {
                    this.publish(new Object[]{"da_attivare"});
                } else {
                    String token = JPanelDropboxAllegati.this.du.getAuthToken(false);
                    String userLocale = Locale.getDefault().toString();
                    DbxRequestConfig requestConfig = new DbxRequestConfig("Invoicex");
                    DbxClientV2 dbxClient = new DbxClientV2(requestConfig, token);
                    try {
                        boolean fileFounded = false;
                        FullAccount dbxAccountInfo = dbxClient.users().getCurrentAccount();
                        this.publish(new Object[]{"attivo"});
                        ListFolderResult list = null;
                        try {
                            list = dbxClient.files().listFolder("/Allegati");
                        }
                        catch (ListFolderErrorException ex) {
                            ex.printStackTrace();
                            System.err.println("Error in getAccountInfo(): " + ex.getMessage());
                            this.publish(new Object[]{"errore"});
                        }
                        if (list == null) {
                            dbxClient.files().createFolder("/Allegati");
                            list = dbxClient.files().listFolder("/Allegati");
                        }
                    }
                    catch (DbxException ex) {
                        ex.printStackTrace();
                        System.err.println("Error in getAccountInfo(): " + ex.getMessage());
                        this.publish(new Object[]{"errore"});
                    }
                    catch (Throwable tr) {
                        tr.printStackTrace();
                        System.err.println("Error in getAccountInfo(): " + tr.getMessage());
                        this.publish(new Object[]{"errore"});
                    }
                }
                return null;
            }

            protected void done() {
                JPanelDropboxAllegati.this.loading.setVisible(false);
            }

            protected void process(List chunks) {
                for (Object o2 : chunks) {
                    if (o2 instanceof String) {
                        String s = (String)o2;
                        if (s.equals("da_attivare")) {
                            JPanelDropboxAllegati.this.stato.setText("Il collegamento con Dropbox deve essere attivato");
                            JPanelDropboxAllegati.this.stato.setForeground(new Color(150, 100, 50));
                            JPanelDropboxAllegati.this.pan_attivazione.setVisible(true);
                            continue;
                        }
                        if (s.equals("attivo")) {
                            JPanelDropboxAllegati.this.stato.setText("Collegamento Dropbox attivo");
                            JPanelDropboxAllegati.this.stato.setForeground(new Color(50, 150, 50));
                            continue;
                        }
                        if (!s.equals("errore")) continue;
                        JPanelDropboxAllegati.this.stato.setText("Errore nel collegamento con Dropbox, ripetere l'attivazione");
                        JPanelDropboxAllegati.this.stato.setForeground(new Color(200, 50, 50));
                        JPanelDropboxAllegati.this.pan_attivazione.setVisible(true);
                        continue;
                    }
                    if (!(o2 instanceof Integer)) continue;
                    Integer fileFounded = cu.i(o2);
                    JPanelDropboxAllegati.this.stato.setText("Salvataggio allegati attivo, file caricati: " + fileFounded);
                    JPanelDropboxAllegati.this.stato.setForeground(new Color(50, 150, 50));
                }
            }
        };
        w.execute();
    }
}

