/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.allegati;

import gestioneFatture.iniFileProp;
import it.tnx.Db;
import it.tnx.commons.DbUtils;
import it.tnx.commons.cu;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class SmbUtil {
    private static NtlmPasswordAuthentication authenticate(String username, String password) throws Exception {
        NtlmPasswordAuthentication auth = null;
        auth = username.equals("") && password.equals("") ? NtlmPasswordAuthentication.ANONYMOUS : new NtlmPasswordAuthentication(";" + username + ":" + password);
        return auth;
    }

    public static boolean isWritable(String path, String username, String password) {
        try {
            String fileName = "test-" + RandomStringUtils.randomAlphanumeric((int)10) + ".txt";
            String fileCont = "--TEST TEST TEST TEST--";
            String filePath = path + fileName;
            SmbFile f2 = new SmbFile(filePath, SmbUtil.authenticate(username, password));
            SmbFileOutputStream out = new SmbFileOutputStream(f2);
            out.write(fileCont.getBytes());
            out.close();
            ArrayList<SmbFile> listaFiles = SmbUtil.listFiles(path, username, password);
            for (SmbFile file : listaFiles) {
                if (!file.getName().equals(fileName)) continue;
                SmbFileInputStream in = new SmbFileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                in.read(data);
                in.close();
                String smbFileCont = new String(data, "UTF-8");
                SmbUtil.deleteFile(fileName, path, username, password);
                return smbFileCont.equals(fileCont);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static SmbFile uploadFile(File f, String path, String username, String password) {
        try {
            String fileName = f.getName();
            String filePath = path + fileName;
            SmbFile smbFile = new SmbFile(filePath, SmbUtil.authenticate(username, password));
            if (smbFile.exists()) {
                int n = 0;
                while (smbFile.exists()) {
                    String extension = StringUtils.substringAfterLast((String)fileName, (String)".");
                    String name = StringUtils.substringBeforeLast((String)fileName, (String)".");
                    filePath = path + name + "-" + ++n + (extension.length() > 0 ? "." : "") + extension;
                    smbFile = new SmbFile(filePath, SmbUtil.authenticate(username, password));
                }
            }
            SmbFileOutputStream out = new SmbFileOutputStream(smbFile);
            FileInputStream in = new FileInputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            if (smbFile.exists()) {
                return smbFile;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFile(String filename, String path, String username, String password) throws Exception {
        path = path + filename;
        SmbFile fileToDel = new SmbFile(path, SmbUtil.authenticate(username, password));
        fileToDel.delete();
    }

    public static ArrayList<SmbFile> listSubdir(String path, String username, String password) throws Exception {
        ArrayList<SmbFile> retList = new ArrayList<SmbFile>();
        SmbFile rootDir = new SmbFile(path, SmbUtil.authenticate(username, password));
        if (rootDir.exists()) {
            SmbFile[] listaCompleta;
            for (SmbFile smbf : listaCompleta = rootDir.listFiles()) {
                if (!smbf.isDirectory()) continue;
                retList.add(smbf);
            }
        }
        return retList;
    }

    public static ArrayList<SmbFile> listFiles(String path, String username, String password) throws Exception {
        ArrayList<SmbFile> retList = new ArrayList<SmbFile>();
        SmbFile rootDir = new SmbFile(path, SmbUtil.authenticate(username, password));
        if (rootDir.exists()) {
            SmbFile[] listaCompleta;
            for (SmbFile smbf : listaCompleta = rootDir.listFiles()) {
                if (!smbf.isFile()) continue;
                retList.add(smbf);
            }
        }
        return retList;
    }

    public static void anteprimaFile(String fileName, String tmpfile, String path, String username, String password) throws Exception {
        SmbUtil.downloadFile(fileName, tmpfile, path, username, password);
    }

    public static void downloadFile(String fileName, String tmpfile, String path, String username, String password) throws Exception {
        String filePath = path + fileName;
        SmbFile smbFile = new SmbFile(filePath, SmbUtil.authenticate(username, password));
        if (!smbFile.exists()) {
            throw new Exception("file " + smbFile.toString() + " inesistente");
        }
        SmbFileInputStream smbIn = new SmbFileInputStream(smbFile);
        FileOutputStream out = new FileOutputStream(tmpfile);
        IOUtils.copy((InputStream)smbIn, (OutputStream)out);
        smbIn.close();
        out.close();
    }

    public static void downloadFile(String fileName, OutputStream out, String path, String username, String password) throws Exception {
        String filePath = path + fileName;
        System.out.println("filePath = " + filePath);
        SmbFile smbFile = new SmbFile(filePath, SmbUtil.authenticate(username, password));
        System.out.println("smbFile = " + smbFile);
        if (!smbFile.exists()) {
            throw new Exception("file " + smbFile.toString() + " inesistente");
        }
        SmbFileInputStream smbIn = new SmbFileInputStream(smbFile);
        IOUtils.copy((InputStream)smbIn, (OutputStream)out);
        smbIn.close();
        out.close();
        System.out.println("smbIn close");
    }

    public static String getDefaultValue(String chiave) throws Exception {
        String field = "";
        field = chiave.equals("tipo_salvataggio") ? "tipo_salvataggio_allegati" : (chiave.equals("server") ? "allegati_smb_server" : (chiave.equals("cartella") ? "allegati_smb_cartella" : (chiave.equals("username") ? "allegati_smb_username" : (chiave.equals("password") ? "allegati_smb_password" : chiave))));
        String ret = cu.toString((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("SELECT " + field + " FROM dati_azienda WHERE id = 1")));
        if (chiave.equals("password") || chiave.equals("allegati_smb_password")) {
            return iniFileProp.decrypt((String)ret);
        }
        return ret;
    }

    private static String getDefaultPath() throws Exception {
        return "smb://" + SmbUtil.getDefaultValue("server") + SmbUtil.getDefaultValue("cartella");
    }

    public static NtlmPasswordAuthentication authenticate() throws Exception {
        return SmbUtil.authenticate(SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static boolean isWritable(String path) throws Exception {
        return SmbUtil.isWritable(path, SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static ArrayList<SmbFile> listSubdir(String path) throws Exception {
        return SmbUtil.listSubdir(path, SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static ArrayList<SmbFile> listFiles(String path) throws Exception {
        return SmbUtil.listFiles(path, SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static SmbFile uploadFile(File f) throws Exception {
        return SmbUtil.uploadFile(f, SmbUtil.getDefaultPath(), SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static void deleteFile(String filename) throws Exception {
        SmbUtil.deleteFile(filename, SmbUtil.getDefaultPath(), SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static void downloadFile(String fileName, OutputStream out) throws Exception {
        SmbUtil.downloadFile(fileName, out, SmbUtil.getDefaultPath(), SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static void anteprimaFile(String fileName, String tmpfile) throws Exception {
        SmbUtil.anteprimaFile(fileName, tmpfile, SmbUtil.getDefaultPath(), SmbUtil.getDefaultValue("username"), SmbUtil.getDefaultValue("password"));
    }

    public static void main(String[] args) throws Exception {
        ArrayList<SmbFile> listFiles = SmbUtil.listSubdir("smb://localhost", "", "");
        System.out.println(listFiles.size());
        for (SmbFile smbf : listFiles) {
            System.out.println(smbf.toString());
        }
    }
}

