/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.dropbox;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.DbxAuthFinish;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxWebAuth;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.ThumbnailFormat;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.dropbox.core.v2.files.UploadSessionAppendV2Uploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartResult;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.users.FullAccount;
import it.tnx.Db;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;

public class DropboxUtil {
    static Cipher c1 = null;
    static Cipher d1 = null;
    static byte[] desKeyData = new byte[]{16, 50, 3, -120, 33, -120, 51, 115};
    static SecretKeySpec secretKey = new SecretKeySpec(desKeyData, "DES");
    static String oldauthfile = System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "dropbox.auth";
    static File oldfauthfile = new File(oldauthfile);
    DbxWebAuth webAuth = null;
    FileMetadata fultimo_backup = null;
    List elenco_files = new ArrayList();

    public DropboxUtil() {
        if (c1 != null) {
            return;
        }
        try {
            c1 = Cipher.getInstance("DES");
            d1 = Cipher.getInstance("DES");
            secretKey = new SecretKeySpec(desKeyData, "DES");
            c1.init(1, secretKey);
            d1.init(2, secretKey);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public String attiva() throws Exception {
        DbxRequestConfig requestConfig = new DbxRequestConfig("Invoicex");
        DbxAppInfo appInfo = new DbxAppInfo(this.getDropboxKey(), this.getDropboxSecret());
        this.webAuth = new DbxWebAuth(requestConfig, appInfo);
        DbxWebAuth.Request authRequest = DbxWebAuth.newRequestBuilder().withNoRedirect().build();
        String authorizeUrl = this.webAuth.authorize(authRequest);
        System.out.println("authorizeUrl = " + authorizeUrl);
        return authorizeUrl;
    }

    public boolean conferma(String code) throws Exception {
        DbxAuthFinish authFinish = this.webAuth.finishFromCode(code);
        System.out.println("Authorization complete.");
        System.out.println("- User ID: " + authFinish.getUserId());
        this.setAuthToken(authFinish.getAccessToken());
        return true;
    }

    public String getDropboxKey() throws Exception {
        String k = "nXJV1HszbnVwURJB4RO9FQ==";
        return this.decifra(k);
    }

    public String getDropboxSecret() throws Exception {
        String k = "3ZEJzTCJUl2YiqGjszB3BQ==";
        return this.decifra(k);
    }

    public String getAuthToken(boolean verifica) throws Exception {
        String dauth = cu.s((Object)dbu.getObject((Connection)Db.getConn(), (String)"select dropbox_auth from dati_azienda"));
        if (StringUtils.isNotBlank((String)dauth)) {
            String token = this.decifra(dauth);
            if (verifica) {
                DbxRequestConfig requestConfig = new DbxRequestConfig("Invoicex");
                DbxClientV2 dbxClient = new DbxClientV2(requestConfig, token);
                try {
                    FullAccount dbxAccountInfo = dbxClient.users().getCurrentAccount();
                    return token;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                return token;
            }
        }
        return null;
    }

    public String decifra(String value) throws Exception {
        byte[] temp1 = Base64.decodeBase64((byte[])value.getBytes());
        byte[] temp2 = d1.doFinal(temp1);
        String temp3 = new String(temp2);
        return temp3;
    }

    public String cifra(String value) throws Exception {
        byte[] temp1 = c1.doFinal(value.getBytes());
        byte[] temp2 = Base64.encodeBase64((byte[])temp1);
        String temp3 = new String(temp2);
        return temp3;
    }

    public static File getOldAuthFile() {
        return oldfauthfile;
    }

    public boolean isValidToken() throws Exception {
        return StringUtils.isNotBlank((String)this.getAuthToken(true));
    }

    public DbxClientV2 getClient() throws Exception {
        String token = this.getAuthToken(false);
        String userLocale = Locale.getDefault().toString();
        DbxRequestConfig requestConfig = new DbxRequestConfig("Invoicex");
        DbxClientV2 client = new DbxClientV2(requestConfig, token);
        return client;
    }

    public FileMetadata getFilePreview(String fileName, OutputStream out) throws Exception {
        System.out.println("fileName:" + fileName);
        Metadata entry = this.getClient().files().getMetadata(fileName);
        if (entry == null) {
            throw new Exception("File non trovato su dropbox: " + fileName);
        }
        System.out.println("entry:" + entry);
        return (FileMetadata)this.getClient().files().getThumbnailBuilder(fileName).withFormat(ThumbnailFormat.JPEG).withSize(ThumbnailSize.W640H480).download(out);
    }

    public FileMetadata downloadFile(String fileName, OutputStream out) throws Exception {
        Metadata entry = this.getClient().files().getMetadata(fileName);
        System.out.println("entry = " + entry);
        if (entry == null) {
            throw new Exception("Il file '" + fileName + "' non esiste su Dropbox (account:" + this.getClient().users().getCurrentAccount().getEmail() + ")");
        }
        return (FileMetadata)this.getClient().files().download(fileName).download(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMetadata uploadFileWithProgress(File file, SwingWorker worker, String prefix) throws Exception {
        String userLocale = Locale.getDefault().toString();
        String fileNameOrig = file.getName();
        String fileName = "/Allegati/" + fileNameOrig;
        Metadata entry = null;
        try {
            entry = this.getClient().files().getMetadata(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entry != null) {
            String primaParte = StringUtils.substringBeforeLast((String)fileNameOrig, (String)".");
            String est = StringUtils.substringAfterLast((String)fileNameOrig, (String)".");
            fileName = StringUtils.isNotBlank((String)primaParte) && StringUtils.isNotBlank((String)est) ? "/Allegati/" + primaParte + "_" + (int)(Math.random() * 100000.0) + "." + est : (StringUtils.isNotBlank((String)primaParte) && StringUtils.isBlank((String)est) ? "/Allegati/" + primaParte + "_" + (int)(Math.random() * 100000.0) : "/Allegati/." + est + "_" + (int)(Math.random() * 100000.0));
        }
        DbxClientV2 dbxClient = this.getClient();
        long total = file.length();
        UploadSessionStartUploader uploader = null;
        FileMetadata metadata = null;
        try {
            UploadSessionCursor uploadCursor;
            uploader = dbxClient.files().uploadSessionStart();
            FileInputStream in = new FileInputStream(file);
            OutputStream out = uploader.getOutputStream();
            byte[] buffer = new byte[256000];
            int read = ((InputStream)in).read(buffer);
            out.write(buffer, 0, read);
            UploadSessionStartResult res = (UploadSessionStartResult)uploader.finish();
            String sesid = res.getSessionId();
            uploader.close();
            int conta = 1;
            long inviato = read;
            while ((read = ((InputStream)in).read(buffer)) > 0) {
                System.out.print(".");
                uploadCursor = new UploadSessionCursor(sesid, inviato);
                UploadSessionAppendV2Uploader append = dbxClient.files().uploadSessionAppendV2(uploadCursor);
                out = append.getOutputStream();
                out.write(buffer, 0, read);
                append.finish();
                append.close();
                ++conta;
                double perc = (double)(inviato += (long)read) * 100.0 / (double)total;
                System.out.println("caricamento su dropbox " + (int)perc + "%");
                if (worker == null) continue;
                if (prefix == null) {
                    worker.publish(new Object[]{"salvataggio " + file.getName() + " " + (int)perc + "%"});
                    continue;
                }
                worker.publish(new Object[]{StringUtils.replace((String)prefix, (String)"</div></html>", (String)"") + " (" + file.getName() + " " + (int)perc + "%)</div></html>"});
            }
            uploadCursor = new UploadSessionCursor(sesid, inviato);
            CommitInfo info = new CommitInfo(fileName);
            UploadSessionFinishUploader finish = dbxClient.files().uploadSessionFinish(uploadCursor, info);
            metadata = (FileMetadata)finish.finish();
            finish.close();
            FileMetadata fileMetadata = metadata;
            return fileMetadata;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            uploader.close();
        }
        return null;
    }

    public void deleteFile(String fileName) throws Exception {
        this.getClient().files().delete(fileName);
    }

    void setAuthToken(String token) throws Exception {
        token = this.cifra(token);
        dbu.tryExecQuery((Connection)Db.getConn(), (String)("update dati_azienda set dropbox_auth = " + dbu.sql((Object)token)), (boolean)false, (boolean)true);
    }

    public void aggiungiCampoDropboxAuth() throws Exception {
        if (!dbu.existColumn((Connection)Db.getConn(), (String)"dati_azienda", (String)"dropbox_auth")) {
            dbu.tryExecQuery((Connection)Db.getConn(), (String)"alter table dati_azienda add dropbox_auth varchar(500) null", (boolean)false, (boolean)true);
        }
    }
}

