/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.impexp.export;

import invoicexplugininvoicex.impexp.export.ExportBase;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.commons.DateUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;

public class Filconad
extends ExportBase {
    static final String rowDivider = "\r\n";

    public Filconad(Component frm_lancio, JTextArea testo, Map param, SwingWorker w) throws Exception {
        super(frm_lancio, testo, param, w);
    }

    public boolean esporta() throws Exception {
        String sql = "SELECT t.id as fattura, r.da_ddt as ddt  FROM righ_fatt r  LEFT JOIN test_fatt t ON r.id_padre = t.id  LEFT JOIN test_ddt tddt ON r.da_ddt = tddt.id  LEFT JOIN clie_forn c ON t.cliente = c.codice  LEFT JOIN clie_forn_dest d ON tddt.id_cliente_destinazione = d.id ";
        String sqlw = " WHERE !isNull(d.cod_filconad) AND !isNull(r.da_ddt) AND !isNull(r.da_ddt_riga)";
        if (this.dal != null) {
            sqlw = sqlw + " AND t.data >= " + Db.pc((Object)this.dal, (int)91);
        }
        if (this.al != null) {
            sqlw = sqlw + " AND t.data <= " + Db.pc((Object)this.al, (int)91);
        }
        if (this.clifor != null) {
            sqlw = sqlw + " and t.cliente = '" + this.clifor + "'";
        }
        String sqlg = " GROUP BY r.da_ddt, t.id ORDER BY t.data ASC";
        sql = sql + "\n" + sqlw + "\n" + sqlg;
        System.out.println("sql filconad = " + sql);
        ResultSet rs = Db.openResultSet((Connection)Db.getConn(), (String)sql);
        ArrayList<String> fatture = new ArrayList<String>();
        int progressivo = 1;
        if (rs.isBeforeFirst()) {
            String sqlsconto = "SELECT t.sconto, t.numero, t.serie, t.id, t.data FROM righ_fatt r  LEFT JOIN test_fatt t ON r.id_padre = t.id  LEFT JOIN test_ddt tddt ON r.da_ddt = tddt.id  LEFT JOIN clie_forn c ON t.cliente = c.codice  LEFT JOIN clie_forn_dest d ON tddt.id_cliente_destinazione = d.id ";
            sqlsconto = sqlsconto + "\n" + sqlw + " and ifnull(t.sconto,0) != 0 \n" + sqlg;
            System.out.println("sqlsconto = " + sqlsconto);
            ArrayList listsconto = dbu.getListMap((Connection)Db.getConn(), (String)sqlsconto);
            if (listsconto != null && listsconto.size() > 0) {
                String msg = "Le seguenti fatture hanno uno sconto a importo che non viene considerato nell'export:";
                for (Map m : listsconto) {
                    msg = msg + "\n Fattura num. " + m.get("serie") + m.get("numero") + " del " + DateUtils.formatDateIta((Date)cu.toDate(m.get("data"))) + " sconto: -\u20ac " + FormatUtils.formatEuroIta((double)cu.d0(m.get("sconto")));
                }
                if (!SwingUtils.showYesNoMessage((Component)this.frm_lancio, (String)(msg = msg + "\n\nContinuare ?"))) {
                    dbu.close((ResultSet)rs);
                    return false;
                }
            }
            while (rs.next()) {
                fatture.add(Filconad.exportFattura(rs.getInt("fattura"), rs.getInt("ddt"), progressivo));
                ++progressivo;
            }
        } else {
            this.w.publish(new Object[]{"Nessuna fattura trovata"});
            dbu.close((ResultSet)rs);
            return false;
        }
        dbu.close((ResultSet)rs);
        String dir = this.current_dir_export;
        File startDir = new File(dir);
        if (!startDir.exists()) {
            startDir.mkdir();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MM yyyy");
        String nomeFile = dir + "FILCONAD " + sdf.format(new Date()) + ".dat";
        FileOutputStream fos = new FileOutputStream(nomeFile);
        for (String fattura : fatture) {
            fos.write(fattura.getBytes("ISO-8859-1"));
        }
        return true;
    }

    private static String exportFattura(Integer fattura, Integer ddt, Integer progressivo) throws Exception {
        ArrayList<String> righe = new ArrayList<String>();
        System.out.println("Fattura: " + fattura);
        System.out.println("DDT: " + ddt);
        String sql = "SELECT t.numero as num_fattura,t.data as data_fattura,d.numero as num_ddt,d.data as data_ddt,c.codice as cliente_filconad,s.cod_filconad as destinazione_filconad,t.tipo_fattura,r.codice_articolo,r.descrizione,r.um,r.quantita,r.prezzo,r.prezzo_netto_unitario,r.prezzo_netto_totale,i.codice_natura_xmlpa iva_pa,i.percentuale  , t.id , c.cod_for_filconad FROM test_fatt t  LEFT JOIN righ_fatt r ON r.id_padre = t.id  LEFT JOIN test_ddt d ON r.da_ddt = d.id  LEFT JOIN clie_forn c ON t.cliente = c.codice  LEFT JOIN clie_forn_dest s ON d.id_cliente_destinazione = s.id  LEFT JOIN codici_iva i ON r.iva = i.codice  WHERE r.id_padre = " + Db.pc((Object)fattura, (int)4) + " AND r.da_ddt = " + Db.pc((Object)ddt, (int)4) + " AND !isNull(r.da_ddt) AND !isNull(r.da_ddt_riga) order by r.riga";
        ResultSet rs = Db.openResultSet((String)sql);
        boolean continua = rs.next();
        boolean first = true;
        String rigaExport = "";
        ArrayList fatture_ricalcolate = new ArrayList();
        while (continua) {
            Integer id = cu.i((Object)rs.getObject("id"));
            ArrayList<String> campi = new ArrayList<String>();
            if (first) {
                rigaExport = "";
                ArrayList<String> campiTesta = new ArrayList<String>();
                SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
                String data_fat = df.format(rs.getDate("data_fattura"));
                String data_ddt = df.format(rs.getDate("data_ddt"));
                String tipo_fat = rs.getInt("tipo_fattura") == 1 ? "F" : "N";
                campiTesta.add("01");
                campiTesta.add(Filconad.formatCampo(progressivo, 5, '0'));
                campiTesta.add(Filconad.formatCampo(rs.getInt("num_fattura"), 6, '0'));
                campiTesta.add(Filconad.formatCampo(data_fat, 6));
                campiTesta.add(Filconad.formatCampo(rs.getInt("num_ddt"), 6, '0'));
                campiTesta.add(Filconad.formatCampo(data_ddt, 6));
                campiTesta.add(Filconad.formatCampo(rs.getString("cod_for_filconad"), 15));
                campiTesta.add(Filconad.formatCampo("", 1));
                campiTesta.add(Filconad.formatCampo(rs.getString("cliente_filconad"), 15));
                campiTesta.add(Filconad.formatCampo("", 15));
                campiTesta.add(Filconad.formatCampo(rs.getString("destinazione_filconad"), 15));
                campiTesta.add(Filconad.formatCampo("", 1));
                campiTesta.add(Filconad.formatCampo(tipo_fat, 1));
                campiTesta.add(Filconad.formatCampo("EUR", 3));
                for (String value : campiTesta) {
                    rigaExport = rigaExport + value;
                }
                righe.add(rigaExport);
                first = false;
            }
            rigaExport = "";
            String descArticolo = rs.getString("descrizione");
            descArticolo = StringUtils.replace((String)descArticolo, (String)"\n\r", (String)" ");
            descArticolo = StringUtils.replace((String)descArticolo, (String)rowDivider, (String)" ");
            descArticolo = StringUtils.replace((String)descArticolo, (String)"\r", (String)" ");
            descArticolo = StringUtils.replace((String)descArticolo, (String)"\n", (String)" ");
            Double quantita = Util.round((double)rs.getDouble("quantita"), (int)2);
            Double prezzo = Util.round((double)rs.getDouble("prezzo_netto_unitario"), (int)3);
            Double totale = Util.round((double)rs.getDouble("prezzo_netto_totale"), (int)3);
            String campoIva = cu.s((Object)rs.getString("iva_pa"));
            String iva = "1";
            if (campoIva.equals("N5") || campoIva.equals("N6") || campoIva.equals("")) {
                iva = "";
            } else if (campoIva.equals("N1") || campoIva.equals("N2")) {
                iva = "2";
            }
            campi.add("02");
            campi.add(Filconad.formatCampo(progressivo, 5, '0'));
            campi.add(Filconad.formatCampo(rs.getString("codice_articolo"), 15));
            campi.add(Filconad.formatCampo(descArticolo, 30, ' ', "sin"));
            campi.add(Filconad.formatCampo(rs.getString("um"), 2));
            campi.add(Filconad.formatDecimalValue(quantita.toString(), 2, 7));
            campi.add(Filconad.formatDecimalValue(prezzo.toString(), 3, 9));
            campi.add(Filconad.formatDecimalValue(totale.toString(), 3, 9));
            campi.add(Filconad.formatCampo("", 4, '0'));
            campi.add(Filconad.formatCampo(iva, 1));
            campi.add(Filconad.formatDecimalValue(cu.d0((Object)rs.getBigDecimal("percentuale")).toString(), 0, 2));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatCampo("1", 1));
            campi.add(Filconad.formatCampo("", 6, '0'));
            campi.add(Filconad.formatCampo("", 2));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatDecimalValue("0.0", 3, 5));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatCampo("", 1));
            campi.add(Filconad.formatCampo("", 7));
            campi.add(Filconad.formatCampo("", 3));
            campi.add(Filconad.formatCampo("", 6, '0'));
            for (String value : campi) {
                rigaExport = rigaExport + value;
            }
            righe.add(rigaExport);
            continua = rs.next();
        }
        if (righe.size() > 0) {
            String export = "";
            for (String riga : righe) {
                export = export + riga + rowDivider;
            }
            return export;
        }
        return "";
    }

    private static String formatDecimalValue(String valore, Integer decimali, Integer length) {
        String formattato = "";
        String decimalVal = valore.substring(valore.indexOf(".") + 1);
        String integerVal = valore.substring(0, valore.indexOf("."));
        if (decimalVal.length() > decimali) {
            decimalVal = decimalVal.substring(0, decimali);
        }
        while (decimalVal.length() < decimali) {
            decimalVal = decimalVal + "0";
        }
        Integer integerLength = length - decimali;
        if (integerVal.length() > integerLength) {
            integerVal = integerVal.substring(0, integerLength);
        }
        while (integerVal.length() < integerLength) {
            integerVal = "0" + integerVal;
        }
        formattato = integerVal + decimalVal;
        return formattato;
    }

    private static String formatCampo(Object value, Integer length) {
        return Filconad.formatCampo(value, length, ' ', "des");
    }

    private static String formatCampo(Object value, Integer length, char riempimento) {
        return Filconad.formatCampo(value, length, riempimento, "des");
    }

    private static String formatCampo(Object value, Integer length, char riempimento, String allineamento) {
        String formattato = "";
        formattato = value instanceof String ? (String)value : cu.s((Object)value);
        if (length > 0 && formattato.length() != length.intValue()) {
            if (formattato.length() > length) {
                formattato = formattato.substring(0, length);
            } else {
                while (formattato.length() < length) {
                    if (allineamento.equals("des")) {
                        formattato = riempimento + formattato;
                        continue;
                    }
                    formattato = formattato + riempimento;
                }
            }
        }
        return formattato;
    }
}

