/*
 * Decompiled with CFR 0.152.
 */
package invoicexplugininvoicex.xmlpa;

import gestioneFatture.main;
import invoicexplugininvoicex.allegati.AllegatiUtil;
import invoicexplugininvoicex.allegati.SmbUtil;
import invoicexplugininvoicex.dropbox.DropboxInit;
import invoicexplugininvoicex.dropbox.DropboxUtil;
import invoicexplugininvoicex.xmlpa.ExportXmlEsito;
import invoicexplugininvoicex.xu;
import it.tnx.Db;
import it.tnx.Util;
import it.tnx.Zip;
import it.tnx.commons.DateUtils;
import it.tnx.commons.DbUtils;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.fu;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXParseException;

public class ExportXmlPa2 {
    String vIdTrasmittenteIdPaese = "";
    String vIdTrasmittenteIdCodice = "";
    String vProgressivoInvio = "";
    String vFormatoTrasmissione = "SDI10";
    String vCodiceDestinatario = "";
    String vPec;
    String vContattiTrasmittenteTelefono = "";
    String vContattiTrasmittenteEmail = "";
    String vCedenteIdPaese = "";
    String vCedenteIdCodice = "";
    String vCedenteCodiceFiscale = "";
    String vDenominazione = "";
    String vTitolo = "";
    String vCognome = "";
    String vNome = "";
    String vRegimeFiscale = "";
    String vIndirizzo = "";
    String vCAP = "";
    String vComune = "";
    String vProvincia = "";
    String vNazione = "";
    String vRiferimento = "";
    String vCedenteReaUfficio = "";
    String vCedenteReaNumero = "";
    String vCedenteReaCapitaleSociale = "";
    String vCedenteReaSocioUnico = "";
    String vCedenteReaStatoLiquidazione = "";
    boolean pubblico = false;
    Document document = DocumentHelper.createDocument();
    Element root = null;
    List<Map> fatture = null;
    Map destinatario = null;
    String ver = "1.0";
    String lastFileGen;

    public ExportXmlPa2(List<Map> fatture, Map destinatario, boolean pubblico) {
        this.fatture = fatture;
        this.destinatario = destinatario;
        this.pubblico = pubblico;
        if (new Date().after(DateUtils.getDate((int)2015, (int)1, (int)31))) {
            this.ver = "1.1";
        }
        if (new Date().after(DateUtils.getDate((int)2016, (int)12, (int)31)) || main.getPersonalContain((String)"xmlpa12")) {
            this.ver = "1.2";
        }
        this.root = this.document.addElement("p:FatturaElettronica");
        if (this.ver.equals("1.2")) {
            this.vFormatoTrasmissione = pubblico ? "FPA12" : "FPR12";
            this.root.addAttribute("versione", this.vFormatoTrasmissione);
            this.root.addAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            this.root.addAttribute("xmlns:p", "http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v1.2");
            this.root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        } else if (this.ver.equals("1.1")) {
            this.root.addAttribute("versione", "1.1");
            this.root.addAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            this.root.addAttribute("xmlns:p", "http://www.fatturapa.gov.it/sdi/fatturapa/v1.1");
            this.root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        } else {
            this.root.addAttribute("versione", "1.0");
            this.root.addAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            this.root.addAttribute("xmlns:p", "http://www.fatturapa.gov.it/sdi/fatturapa/v1.0");
            this.root.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public Object export(JDialog parent) {
        ExportXmlEsito esito = new ExportXmlEsito();
        esito.fatture_generate = 0;
        String msg = "";
        try {
            for (Map fattura : this.fatture) {
                List ive;
                if (cu.d0(fattura.get("sconto")) != 0.0) {
                    msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 contiene lo sconto a importo\n";
                }
                if ((ive = (List)fattura.get("totali_iva")).size() > 1 && (cu.d0(fattura.get("spese_trasporto")) != 0.0 || cu.d0(fattura.get("spese_incasso")) != 0.0)) {
                    msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 contiene le spese di trasporto o di incasso ed ha pi\u00f9 aliquote iva\n";
                }
                if (ive.size() > 1 && cu.d0(fattura.get("totale_rivalsa")) != 0.0) {
                    msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 contiene la rivalsa ed ha pi\u00f9 aliquote iva\n";
                }
                if (cu.d0(fattura.get("totale_ritenuta")) != 0.0 && StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dr_tipo_ritenuta")))) {
                    msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la ritenuta ma non \u00e8 specificato il tipo nei dati 'Fattura Elettronica'\n";
                }
                if (cu.d0(fattura.get("totale_rivalsa")) == 0.0 || !StringUtils.isBlank((String)cu.s(((Map)fattura.get("datipa")).get("dg_dcp_tipo_cassa")))) continue;
                msg = msg + "La fattura " + fattura.get("serie") + fattura.get("numero") + " non pu\u00f2 essere esportata perch\u00e8 ha la rivalsa ma non \u00e8 specificato il tipo nei dati 'Fattura Elettronica'\n";
            }
            if (StringUtils.isNotBlank((String)msg)) {
                return msg;
            }
            Element FatturaElettronicaHeader = this.root.addElement("FatturaElettronicaHeader");
            Element DatiTrasmissione = FatturaElettronicaHeader.addElement("DatiTrasmissione");
            Element IdTrasmittente = DatiTrasmissione.addElement("IdTrasmittente");
            xu.add(IdTrasmittente, "IdPaese", this.vIdTrasmittenteIdPaese);
            xu.add(IdTrasmittente, "IdCodice", this.vIdTrasmittenteIdCodice);
            xu.add(DatiTrasmissione, "ProgressivoInvio", this.vProgressivoInvio);
            this.vFormatoTrasmissione = "SDI10";
            if (this.ver.equals("1.2")) {
                this.vFormatoTrasmissione = this.pubblico ? "FPA12" : "FPR12";
            } else if (this.ver.equals("1.1")) {
                this.vFormatoTrasmissione = "SDI11";
            }
            xu.add(DatiTrasmissione, "FormatoTrasmissione", this.vFormatoTrasmissione);
            xu.add(DatiTrasmissione, "CodiceDestinatario", this.vCodiceDestinatario);
            Element ContattiTrasmittente = DatiTrasmissione.addElement("ContattiTrasmittente");
            xu.add(ContattiTrasmittente, "Telefono", this.vContattiTrasmittenteTelefono);
            xu.add(ContattiTrasmittente, "Email", this.vContattiTrasmittenteEmail);
            if (this.vCodiceDestinatario.equals("0000000") && StringUtils.isNotBlank((String)this.vPec)) {
                xu.add(DatiTrasmissione, "PECDestinatario", this.vPec);
            }
            Element CedentePrestatore = FatturaElettronicaHeader.addElement("CedentePrestatore");
            Element DatiAnagrafici = CedentePrestatore.addElement("DatiAnagrafici");
            Element IdFiscaleIVA = DatiAnagrafici.addElement("IdFiscaleIVA");
            xu.add(IdFiscaleIVA, "IdPaese", this.vCedenteIdPaese);
            xu.add(IdFiscaleIVA, "IdCodice", this.vCedenteIdCodice);
            if (StringUtils.isNotBlank((String)this.vCedenteCodiceFiscale)) {
                Element CodiceFiscale = DatiAnagrafici.addElement("CodiceFiscale");
                CodiceFiscale.setText(this.vCedenteCodiceFiscale);
            }
            Element Anagrafica = DatiAnagrafici.addElement("Anagrafica");
            xu.addssr(Anagrafica, "Denominazione", this.vDenominazione);
            xu.addssr(Anagrafica, "Nome", this.vNome);
            xu.addssr(Anagrafica, "Cognome", this.vCognome);
            xu.addssr(Anagrafica, "Titolo", this.vTitolo);
            xu.add(DatiAnagrafici, "RegimeFiscale", this.vRegimeFiscale);
            Element Sede = CedentePrestatore.addElement("Sede");
            xu.add(Sede, "Indirizzo", this.vIndirizzo);
            xu.add(Sede, "CAP", this.vCAP);
            xu.add(Sede, "Comune", this.vComune);
            xu.add(Sede, "Provincia", this.vProvincia.toUpperCase());
            xu.add(Sede, "Nazione", this.vNazione.toUpperCase());
            try {
                String testrea = "";
                testrea = testrea + this.vCedenteReaUfficio;
                testrea = testrea + this.vCedenteReaNumero;
                testrea = testrea + this.vCedenteReaCapitaleSociale;
                if (StringUtils.isNotBlank((String)testrea)) {
                    Element IscrizioneREA = CedentePrestatore.addElement("IscrizioneREA");
                    xu.addssr(IscrizioneREA, "Ufficio", this.vCedenteReaUfficio.toUpperCase());
                    xu.addssr(IscrizioneREA, "NumeroREA", this.vCedenteReaNumero);
                    xu.addssr(IscrizioneREA, "CapitaleSociale", this.vCedenteReaCapitaleSociale);
                    xu.addssr(IscrizioneREA, "SocioUnico", this.vCedenteReaSocioUnico);
                    xu.addssr(IscrizioneREA, "StatoLiquidazione", this.vCedenteReaStatoLiquidazione);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            xu.addssr(CedentePrestatore, "RiferimentoAmministrazione", this.vRiferimento);
            Element CessionarioCommittente = FatturaElettronicaHeader.addElement("CessionarioCommittente");
            Element CessionarioDatiAnagrafici = CessionarioCommittente.addElement("DatiAnagrafici");
            if (StringUtils.isNotBlank((String)cu.s(this.destinatario.get("piva_cfiscale")))) {
                Element CessionarioIdFiscaleIVA = CessionarioDatiAnagrafici.addElement("IdFiscaleIVA");
                xu.add(CessionarioIdFiscaleIVA, "IdPaese", this.getIdPaeseDestinatario());
                xu.add(CessionarioIdFiscaleIVA, "IdCodice", cu.s(this.destinatario.get("piva_cfiscale")));
            }
            if (StringUtils.isNotBlank((String)cu.s(this.destinatario.get("cfiscale")))) {
                xu.add(CessionarioDatiAnagrafici, "CodiceFiscale", cu.s(this.destinatario.get("cfiscale")));
            }
            Element CessionarioAnagrafica = CessionarioDatiAnagrafici.addElement("Anagrafica");
            xu.add(CessionarioAnagrafica, "Denominazione", cu.s(this.destinatario.get("ragione_sociale")));
            Element CessionarioSede = CessionarioCommittente.addElement("Sede");
            xu.add(CessionarioSede, "Indirizzo", cu.s(this.destinatario.get("indirizzo")));
            xu.add(CessionarioSede, "CAP", cu.s(this.destinatario.get("cap")));
            xu.add(CessionarioSede, "Comune", cu.s(this.destinatario.get("localita")));
            xu.add(CessionarioSede, "Provincia", cu.s(this.destinatario.get("provincia")).toUpperCase());
            xu.add(CessionarioSede, "Nazione", this.getIdPaeseDestinatario().toUpperCase());
            for (Map fattura : this.fatture) {
                List scadenze;
                Map datipa;
                boolean includi_rivalsa_in_iva = false;
                boolean includi_rivalsa_in_ritenuta = false;
                Element FatturaElettronicaBody = this.root.addElement("FatturaElettronicaBody");
                Element DatiGenerali = FatturaElettronicaBody.addElement("DatiGenerali");
                Element DatiGeneraliDocumento = DatiGenerali.addElement("DatiGeneraliDocumento");
                xu.add(DatiGeneraliDocumento, "TipoDocumento", this.getTipoDocumento(fattura));
                xu.add(DatiGeneraliDocumento, "Divisa", "EUR");
                xu.add(DatiGeneraliDocumento, "Data", FormatUtils.formatMysqlDate(fattura.get("data")));
                xu.add(DatiGeneraliDocumento, "Numero", (StringUtils.isBlank((String)cu.s(fattura.get("serie"))) ? "" : cu.s(fattura.get("serie")) + "/") + cu.s(fattura.get("numero")));
                if (cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        datipa = (Map)fattura.get("datipa");
                        Element DatiRitenuta = DatiGeneraliDocumento.addElement("DatiRitenuta");
                        xu.addssr(DatiRitenuta, "TipoRitenuta", datipa.get("dg_dr_tipo_ritenuta"));
                        xu.addssr(DatiRitenuta, "ImportoRitenuta", fu.ne22((Object)Util.round((double)cu.d0(fattura.get("totale_ritenuta")), (int)2)));
                        xu.addssr(DatiRitenuta, "AliquotaRitenuta", fu.ne25(fattura.get("aliquota_ritenuta")));
                        xu.addssr(DatiRitenuta, "CausalePagamento", datipa.get("dg_dr_causale_pagamento"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (cu.toBoolean(fattura.get("bollo_presente"))) {
                    try {
                        datipa = (Map)fattura.get("datipa");
                        Element DatiBollo = DatiGeneraliDocumento.addElement("DatiBollo");
                        xu.addssr(DatiBollo, "BolloVirtuale", "SI");
                        xu.addssr(DatiBollo, "ImportoBollo", fu.ne25((Object)Util.round((double)2.0, (int)2)));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        datipa = (Map)fattura.get("datipa");
                        Element DatiCassaPrevidenziale = DatiGeneraliDocumento.addElement("DatiCassaPrevidenziale");
                        xu.addssr(DatiCassaPrevidenziale, "TipoCassa", datipa.get("dg_dcp_tipo_cassa"));
                        xu.addssr(DatiCassaPrevidenziale, "AlCassa", fu.ne25(fattura.get("rivalsaInpsPerc")));
                        xu.addssr(DatiCassaPrevidenziale, "ImportoContributoCassa", fu.ne22((Object)Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2)));
                        double imponibile_rivalsa = 0.0;
                        if (fattura.containsKey("imponibile_rivalsa")) {
                            // empty if block
                        }
                        double rivalsa = Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        if (cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0) {
                            imponibile_rivalsa = rivalsa * 100.0 / cu.d0(fattura.get("rivalsaInpsPerc"));
                        }
                        xu.addssr(DatiCassaPrevidenziale, "ImponibileCassa", fu.ne22((Object)Util.round((double)imponibile_rivalsa, (int)2)));
                        includi_rivalsa_in_ritenuta = cu.toBoolean((Object)main.getGlobDatiAzienda((String)"includi_rivalsa_in_imp_ritenuta", (Object)true));
                        includi_rivalsa_in_iva = cu.toBoolean((Object)main.getGlobDatiAzienda((String)"includi_rivalsa_in_iva", (Object)true));
                        if (includi_rivalsa_in_iva) {
                            Map riga = (Map)((List)fattura.get("righe")).get(0);
                            xu.add(DatiCassaPrevidenziale, "AliquotaIVA", fu.ne22(riga.get("perc_iva")));
                        } else {
                            xu.add(DatiCassaPrevidenziale, "AliquotaIVA", fu.ne22((Object)0.0));
                        }
                        if (includi_rivalsa_in_ritenuta) {
                            xu.addssr(DatiCassaPrevidenziale, "Ritenuta", "SI");
                        }
                        if (includi_rivalsa_in_iva) {
                            Map riga = (Map)((List)fattura.get("righe")).get(0);
                            if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_natura_xmlpa")))) {
                                xu.add(DatiCassaPrevidenziale, "Natura", cu.s(riga.get("codice_natura_xmlpa")));
                            }
                        } else {
                            xu.add(DatiCassaPrevidenziale, "Natura", "N2");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                System.out.println("aliquota:" + cu.d0(fattura.get("aliquota_ritenuta")));
                System.out.println("contains dati pa:" + fattura.containsKey("datipa"));
                System.out.println("fattura.get(\"datipa\"):" + fattura.get("datipa"));
                System.out.println("cu.d0(fattura.get(\"totale_da_pagare\")):" + cu.d0(fattura.get("totale_da_pagare")));
                if (cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null && cu.d0(fattura.get("totale_da_pagare")) != 0.0) {
                    datipa = (Map)fattura.get("datipa");
                    String dg_dr_totale_da_esportare = cu.s(datipa.get("dg_dr_totale_da_esportare"));
                    if (dg_dr_totale_da_esportare.trim().length() == 0) {
                        dg_dr_totale_da_esportare = "lordo";
                    }
                    if (dg_dr_totale_da_esportare.equalsIgnoreCase("netto")) {
                        xu.add(DatiGeneraliDocumento, "ImportoTotaleDocumento", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("totale_da_pagare")), (int)2)));
                    } else {
                        xu.add(DatiGeneraliDocumento, "ImportoTotaleDocumento", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("totale")), (int)2)));
                    }
                } else {
                    xu.add(DatiGeneraliDocumento, "ImportoTotaleDocumento", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("totale")), (int)2)));
                }
                if (fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        Object k2;
                        datipa = (Map)fattura.get("datipa");
                        xu.addssr(DatiGeneraliDocumento, "Causale", datipa.get("dg_causale"));
                        String testdoa = "";
                        for (Object k2 : datipa.keySet()) {
                            if (!cu.s(k2).startsWith("dg_doa_")) continue;
                            testdoa = testdoa + cu.s(datipa.get(k2));
                        }
                        if (StringUtils.isNotBlank((String)testdoa)) {
                            Element DatiOrdineAcquisto = DatiGenerali.addElement("DatiOrdineAcquisto");
                            xu.addssr(DatiOrdineAcquisto, "RiferimentoNumeroLinea", datipa.get("dg_doa_riferimentonumerolinea"));
                            xu.addssr(DatiOrdineAcquisto, "IdDocumento", datipa.get("dg_doa_iddocumento"));
                            xu.addssr(DatiOrdineAcquisto, "Data", datipa.get("dg_doa_data"));
                            xu.addssr(DatiOrdineAcquisto, "NumItem", datipa.get("dg_doa_numitem"));
                            xu.addssr(DatiOrdineAcquisto, "CodiceCommessaConvenzione", datipa.get("dg_doa_codicecommessaconvenzione"));
                            xu.addssr(DatiOrdineAcquisto, "CodiceCUP", datipa.get("dg_doa_codicecup"));
                            xu.addssr(DatiOrdineAcquisto, "CodiceCIG", datipa.get("dg_doa_codicecig"));
                        }
                        String testdc = "";
                        k2 = datipa.keySet().iterator();
                        while (k2.hasNext()) {
                            Object k3 = k2.next();
                            if (!cu.s(k3).startsWith("dg_dc_")) continue;
                            testdc = testdc + cu.s(datipa.get(k3));
                        }
                        if (StringUtils.isNotBlank((String)testdc)) {
                            Element DatiContratto = DatiGenerali.addElement("DatiContratto");
                            xu.addssr(DatiContratto, "RiferimentoNumeroLinea", datipa.get("dg_dc_riferimentonumerolinea"));
                            xu.addssr(DatiContratto, "IdDocumento", datipa.get("dg_dc_iddocumento"));
                            xu.addssr(DatiContratto, "Data", datipa.get("dg_dc_data"));
                            xu.addssr(DatiContratto, "NumItem", datipa.get("dg_dc_numitem"));
                            xu.addssr(DatiContratto, "CodiceCommessaConvenzione", datipa.get("dg_dc_codicecommessaconvenzione"));
                            xu.addssr(DatiContratto, "CodiceCUP", datipa.get("dg_dc_codicecup"));
                            xu.addssr(DatiContratto, "CodiceCIG", datipa.get("dg_dc_codicecig"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int contarighe = 0;
                HashMap datiddt = new HashMap();
                for (Map riga : (List)fattura.get("righe")) {
                    ++contarighe;
                    Integer daddt = cu.i(riga.get("da_ddt"));
                    if (daddt == null) continue;
                    if (!datiddt.containsKey(daddt)) {
                        datiddt.put(daddt, new ArrayList());
                    }
                    ((List)datiddt.get(daddt)).add(contarighe);
                }
                if (datiddt.size() > 0) {
                    for (Integer ddtn : datiddt.keySet()) {
                        Element DatiDDT = DatiGenerali.addElement("DatiDDT");
                        try {
                            ArrayList listddt = DbUtils.getListMap((Connection)Db.getConn(), (String)("select serie,numero from test_ddt where id = " + ddtn), (boolean)false);
                            String serieddt = cu.s(((Map)listddt.get(0)).get("serie"));
                            String numeroddt = cu.s(((Map)listddt.get(0)).get("numero"));
                            xu.addssr(DatiDDT, "NumeroDDT", (StringUtils.isBlank((String)serieddt) ? "" : serieddt + "/") + numeroddt);
                        }
                        catch (Exception listddt) {
                            // empty catch block
                        }
                        Object sdataddt = null;
                        try {
                            Date dataddt = cu.toDate((Object)DbUtils.getObject((Connection)Db.getConn(), (String)("select data from test_ddt where id = " + ddtn), (boolean)false));
                            sdataddt = FormatUtils.formatMysqlDate((Object)dataddt);
                        }
                        catch (Exception dataddt) {
                            // empty catch block
                        }
                        xu.addssr(DatiDDT, "DataDDT", sdataddt);
                        if (datiddt.size() <= 1) continue;
                        for (Integer rifl : (List)datiddt.get(ddtn)) {
                            xu.addssr(DatiDDT, "RiferimentoNumeroLinea", rifl);
                        }
                    }
                }
                Element DatiBeniServizi = FatturaElettronicaBody.addElement("DatiBeniServizi");
                contarighe = 0;
                Double aliquota = null;
                String natura = null;
                for (Map riga : (List)fattura.get("righe")) {
                    Element CodiceArticolo;
                    Element DettaglioLinee = DatiBeniServizi.addElement("DettaglioLinee");
                    xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_articolo")))) {
                        CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo, "CodiceTipo", "FORN");
                        xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("codice_articolo")));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_cod_tipo")))) {
                        CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo, "CodiceTipo", cu.s(riga.get("xmlpa_cod_tipo")));
                        xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("xmlpa_cod_valore")));
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("xmlpa_disp_med_tipo")))) {
                        CodiceArticolo = DettaglioLinee.addElement("CodiceArticolo");
                        xu.add(CodiceArticolo, "CodiceTipo", cu.s(riga.get("xmlpa_disp_med_tipo")));
                        xu.add(CodiceArticolo, "CodiceValore", cu.s(riga.get("xmlpa_disp_med_valore")));
                    }
                    xu.add(DettaglioLinee, "Descrizione", cu.s(riga.get("descrizione")));
                    xu.add(DettaglioLinee, "Quantita", fu.ne25(riga.get("quantita")));
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("um")))) {
                        xu.add(DettaglioLinee, "UnitaMisura", cu.s(riga.get("um")));
                    }
                    xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25(riga.get("prezzo")));
                    ArrayList sconti = new ArrayList();
                    if (cu.d0(fattura.get("sconto1")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto1")));
                    }
                    if (cu.d0(fattura.get("sconto2")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto2")));
                    }
                    if (cu.d0(fattura.get("sconto3")) != 0.0) {
                        sconti.add(cu.d0(fattura.get("sconto3")));
                    }
                    if (cu.d0(riga.get("sconto1")) != 0.0) {
                        sconti.add(cu.d0(riga.get("sconto1")));
                    }
                    if (cu.d0(riga.get("sconto2")) != 0.0) {
                        sconti.add(cu.d0(riga.get("sconto2")));
                    }
                    if (sconti.size() > 0) {
                        Iterator iterator = sconti.iterator();
                        while (iterator.hasNext()) {
                            Double sc = (Double)iterator.next();
                            Element ScontoMaggiorazione = DettaglioLinee.addElement("ScontoMaggiorazione");
                            xu.add(ScontoMaggiorazione, "Tipo", sc >= 0.0 ? "SC" : "MG");
                            xu.add(ScontoMaggiorazione, "Percentuale", fu.ne25((Object)sc));
                        }
                    }
                    xu.add(DettaglioLinee, "PrezzoTotale", fu.ne25((Object)Util.round((double)cu.d0(riga.get("prezzo_netto_totale")), (int)2)));
                    xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22(riga.get("perc_iva")));
                    if (cu.d0(fattura.get("aliquota_ritenuta")) != 0.0 && cu.toBoolean(riga.get("flag_ritenuta"))) {
                        xu.add(DettaglioLinee, "Ritenuta", "SI");
                    }
                    if (StringUtils.isNotBlank((String)cu.s(riga.get("codice_natura_xmlpa")))) {
                        xu.add(DettaglioLinee, "Natura", cu.s(riga.get("codice_natura_xmlpa")));
                    }
                    aliquota = cu.d(riga.get("perc_iva"));
                    natura = cu.s(riga.get("codice_natura_xmlpa"));
                }
                if (cu.d0(fattura.get("spese_trasporto")) != 0.0 || cu.d0(fattura.get("spese_incasso")) != 0.0) {
                    Element DettaglioLinee;
                    if (cu.d0(fattura.get("spese_trasporto")) != 0.0) {
                        DettaglioLinee = DatiBeniServizi.addElement("DettaglioLinee");
                        xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                        xu.add(DettaglioLinee, "Descrizione", "Spese di trasporto");
                        xu.add(DettaglioLinee, "Quantita", fu.ne25((Object)1));
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25(fattura.get("spese_trasporto")));
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("spese_trasporto")), (int)2)));
                        xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22(aliquota));
                        if (StringUtils.isNotBlank(natura)) {
                            xu.add(DettaglioLinee, "Natura", natura);
                        }
                    }
                    if (cu.d0(fattura.get("spese_incasso")) != 0.0) {
                        DettaglioLinee = DatiBeniServizi.addElement("DettaglioLinee");
                        xu.add(DettaglioLinee, "NumeroLinea", cu.s((Object)(++contarighe)));
                        xu.add(DettaglioLinee, "Descrizione", "Spese di incasso");
                        xu.add(DettaglioLinee, "Quantita", fu.ne25((Object)1));
                        xu.add(DettaglioLinee, "PrezzoUnitario", fu.ne25(fattura.get("spese_incasso")));
                        xu.add(DettaglioLinee, "PrezzoTotale", fu.ne25((Object)Util.round((double)cu.d0(fattura.get("spese_incasso")), (int)2)));
                        xu.add(DettaglioLinee, "AliquotaIVA", fu.ne22(aliquota));
                        if (StringUtils.isNotBlank(natura)) {
                            xu.add(DettaglioLinee, "Natura", natura);
                        }
                    }
                }
                boolean split_payment = false;
                if (fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        Map datipa2 = (Map)fattura.get("datipa");
                        split_payment = cu.toBoolean(datipa2.get("split_payment"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                boolean aggiungereBloccoRivalsa = false;
                boolean rivalsaGiaAggiunta = false;
                if (cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null && !includi_rivalsa_in_iva) {
                    aggiungereBloccoRivalsa = true;
                }
                for (Object totiva : (List)fattura.get("totali_iva")) {
                    boolean bloccoPerRivalsa = false;
                    if (aggiungereBloccoRivalsa && cu.d0(totiva.get("perc_iva")) == 0.0 && cu.s(totiva.get("codice_natura_xmlpa")).equalsIgnoreCase("N2")) {
                        bloccoPerRivalsa = true;
                    }
                    Element DatiRiepilogo = DatiBeniServizi.addElement("DatiRiepilogo");
                    xu.add(DatiRiepilogo, "AliquotaIVA", fu.ne22(totiva.get("perc_iva")));
                    if (StringUtils.isNotBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) {
                        xu.add(DatiRiepilogo, "Natura", cu.s(totiva.get("codice_natura_xmlpa")));
                    }
                    double imponibile = 0.0;
                    if (bloccoPerRivalsa) {
                        imponibile = cu.d0(totiva.get("imponibile")) + Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2);
                        rivalsaGiaAggiunta = true;
                    } else {
                        imponibile = cu.d0(totiva.get("imponibile"));
                    }
                    xu.add(DatiRiepilogo, "ImponibileImporto", fu.ne22((Object)imponibile));
                    xu.add(DatiRiepilogo, "Imposta", fu.ne22(totiva.get("iva")));
                    if (StringUtils.isBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) {
                        if (split_payment) {
                            xu.add(DatiRiepilogo, "EsigibilitaIVA", "S");
                        } else {
                            xu.add(DatiRiepilogo, "EsigibilitaIVA", "I");
                        }
                    }
                    if (!StringUtils.isNotBlank((String)cu.s(totiva.get("codice_natura_xmlpa")))) continue;
                    String rifnor = cu.s(totiva.get("descrizione_iva"));
                    rifnor = StringUtils.left((String)rifnor, (int)100);
                    if (aggiungereBloccoRivalsa && bloccoPerRivalsa && StringUtils.isBlank((String)rifnor)) {
                        rifnor = "NON SOGGETTE";
                    }
                    xu.addssr(DatiRiepilogo, "RiferimentoNormativo", rifnor);
                }
                if (!rivalsaGiaAggiunta && cu.d0(fattura.get("rivalsaInpsPerc")) != 0.0 && fattura.containsKey("datipa") && fattura.get("datipa") != null) {
                    try {
                        if (!includi_rivalsa_in_iva) {
                            Element DatiRiepilogo = DatiBeniServizi.addElement("DatiRiepilogo");
                            xu.add(DatiRiepilogo, "AliquotaIVA", "0.00");
                            xu.add(DatiRiepilogo, "Natura", "N2");
                            xu.add(DatiRiepilogo, "ImponibileImporto", fu.ne22((Object)Util.round((double)cu.d0(fattura.get("totaleRivalsa")), (int)2)));
                            xu.add(DatiRiepilogo, "Imposta", "0.00");
                            xu.addssr(DatiRiepilogo, "RiferimentoNormativo", "NON SOGGETTE");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if ((scadenze = (List)fattura.get("scadenze")) != null && scadenze.size() > 0) {
                    Object totiva;
                    totiva = scadenze.iterator();
                    while (totiva.hasNext()) {
                        Map scadenza = (Map)totiva.next();
                        Element DatiPagamento = FatturaElettronicaBody.addElement("DatiPagamento");
                        xu.add(DatiPagamento, "CondizioniPagamento", scadenze.size() > 1 ? "TP01" : "TP02");
                        Element DettaglioPagamento = DatiPagamento.addElement("DettaglioPagamento");
                        xu.add(DettaglioPagamento, "ModalitaPagamento", cu.s(fattura.get("codice_xmlpa")));
                        xu.add(DettaglioPagamento, "DataScadenzaPagamento", FormatUtils.formatMysqlDate(scadenza.get("data_scadenza")));
                        xu.add(DettaglioPagamento, "ImportoPagamento", fu.ne22(scadenza.get("importo")));
                        if (!fattura.containsKey("datipa") || fattura.get("datipa") == null) continue;
                        try {
                            Map datipa3 = (Map)fattura.get("datipa");
                            xu.addssr(DettaglioPagamento, "IstitutoFinanziario", cu.s(datipa3.get("dp_istituto_finanziario")));
                            xu.addssr(DettaglioPagamento, "IBAN", cu.s(datipa3.get("dp_iban")).toUpperCase());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                System.out.println("aggiungo allegati per xmlpa");
                List allegati = (List)fattura.get("allegati");
                if (allegati != null && allegati.size() > 0) {
                    for (Map allegato : allegati) {
                        System.out.println("allegato = " + allegato);
                        Element Allegati = FatturaElettronicaBody.addElement("Allegati");
                        String nomefile = cu.s(allegato.get("filename"));
                        nomefile = nomefile.indexOf("/") >= 0 ? StringUtils.substringAfterLast((String)nomefile, (String)"/") : StringUtils.substringAfterLast((String)nomefile, (String)"\\");
                        String formato = cu.s(allegato.get("type")).toUpperCase();
                        xu.add(Allegati, "NomeAttachment", nomefile + ".zip");
                        xu.add(Allegati, "AlgoritmoCompressione", "ZIP");
                        xu.add(Allegati, "FormatoAttachment", "zip");
                        Integer id_file = cu.i(allegato.get("id_file"));
                        System.out.println("leggo il file id_file = " + id_file);
                        String sql = "select * from files where id = " + id_file;
                        System.out.println("sql = " + sql);
                        try {
                            String filename;
                            File dirtmp;
                            String dir = System.getProperty("user.home") + File.separator + ".invoicex" + File.separator + "tmp" + File.separator;
                            try {
                                dirtmp = new File(dir);
                                if (!dirtmp.exists()) {
                                    dirtmp.mkdir();
                                    dirtmp.mkdirs();
                                }
                            }
                            catch (Exception etmp) {
                                etmp.printStackTrace();
                            }
                            System.out.println("elimino vecchi temporanei xmlpa_att_");
                            dirtmp = new File(dir);
                            for (File ftmp : dirtmp.listFiles()) {
                                if (!ftmp.getName().startsWith("xmlpa_att_") || ftmp.lastModified() >= System.currentTimeMillis() - 86400000L) continue;
                                System.out.println("elimino ftmp = " + ftmp);
                                ftmp.delete();
                            }
                            ResultSet r = DbUtils.tryOpenResultSet((Connection)Db.getConn(), (String)sql);
                            r.next();
                            String tipoSalvataggio = SmbUtil.getDefaultValue("tipo_salvataggio");
                            File tempallegato = new File(dir + "xmlpan_att_" + id_file + "." + cu.s(allegato.get("type")));
                            System.out.println("scarico da [" + tipoSalvataggio + "] file e lo metto in " + tempallegato);
                            System.out.println("tempallegato = " + tempallegato);
                            if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_DATABASE)) {
                                filename = r.getString("filename");
                                File ffilename = new File(filename);
                                String md5 = r.getString("md5");
                                String type = r.getString("type");
                                InputStream is = r.getBinaryStream("bytes");
                                IOUtils.copyLarge((InputStream)is, (OutputStream)new FileOutputStream(tempallegato));
                            } else {
                                filename = r.getString("filename_drp_smb");
                                System.out.println("filename = " + filename);
                                if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_DROPBOX)) {
                                    if (DropboxInit.init()) {
                                        System.out.println("DropboxInit.init() ok");
                                        DropboxUtil du = new DropboxUtil();
                                        FileOutputStream out = new FileOutputStream(tempallegato);
                                        du.downloadFile("/Allegati/" + filename, out);
                                    } else {
                                        System.out.println("DropboxInit.init() KO");
                                    }
                                } else if (tipoSalvataggio.equals(AllegatiUtil.GEST_ALLEGATI_SMB)) {
                                    SmbUtil.anteprimaFile(filename, tempallegato.getAbsolutePath());
                                }
                            }
                            if (tempallegato.length() <= 0L) {
                                return new Exception("L'allego '" + r.getString("filename") + "' ha dimensione 0");
                            }
                            File tempallegatozip = null;
                            if (!formato.equalsIgnoreCase("zip")) {
                                tempallegatozip = new File(dir + "xmlpan_att_" + id_file + "." + cu.s(allegato.get("type")) + ".zip");
                                System.out.println("comprimo in " + tempallegatozip);
                                Zip.createZip((String)tempallegato.getAbsolutePath(), (String)nomefile, (String)tempallegatozip.getAbsolutePath());
                                System.out.println("compresso");
                            } else {
                                tempallegatozip = tempallegato;
                            }
                            xu.add(Allegati, "Attachment", new String(Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(tempallegatozip)))));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            SwingUtils.showExceptionMessage((Component)parent, (Exception)e);
                            esito.ret = false;
                            return esito;
                        }
                    }
                }
                ExportXmlEsito exportXmlEsito = esito;
                Integer n = exportXmlEsito.fatture_generate;
                Integer n2 = exportXmlEsito.fatture_generate = Integer.valueOf(exportXmlEsito.fatture_generate + 1);
            }
            String path = SystemUtils.getUserDocumentsFolder() + File.separator + "Invoicex" + File.separator + "export" + File.separator + "fatture-pa";
            File exportDir = new File(path);
            exportDir.mkdirs();
            String filename = path + File.separator + this.vIdTrasmittenteIdPaese + this.vIdTrasmittenteIdCodice + "_" + this.vProgressivoInvio + ".xml";
            File test = new File(filename);
            if (test.exists() && !SwingUtils.showYesNoMessage((Component)parent, (String)("Il file " + test.getName() + " \u00e8 gi\u00e0 presente, sovrascriverlo ?"), (String)"Attenzione")) {
                esito.ret = false;
                return esito;
            }
            this.lastFileGen = filename;
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"), format);
            writer.write(this.document);
            writer.close();
            this.document.clearContent();
            this.document = null;
            System.runFinalization();
            Thread.sleep(50L);
            System.gc();
            Thread.sleep(50L);
            Validator validator = null;
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            String pathXsd = "/invoicexplugininvoicex/xmlpa/";
            Source[] schemaFileSources = new Source[]{new StreamSource(this.getClass().getResource(pathXsd + "fatturapa_v1.2.xsd").toString()), new StreamSource(this.getClass().getResource(pathXsd + "xmldsig-core-schema.xsd").toString())};
            Schema schema = factory.newSchema(schemaFileSources);
            validator = schema.newValidator();
            validator.validate(new StreamSource(new File(filename)));
            esito.ret = true;
            esito.filename = filename;
            return esito;
        }
        catch (SAXParseException saxpe) {
            return saxpe;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e;
        }
    }

    private String getTipoDocumento(Map fattura) {
        if (cu.i0(fattura.get("tipo_fattura")) == 3) {
            return "TD04";
        }
        return "TD01";
    }

    private String getIdPaeseDestinatario() {
        if (StringUtils.isNotBlank((String)cu.s(this.destinatario.get("paese")))) {
            return cu.s(this.destinatario.get("paese"));
        }
        return "IT";
    }
}

