/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.demo;

import com.jhlabs.image.BlurFilter;
import com.jhlabs.image.EmbossFilter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImageOp;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.demo.util.LafMenu;
import org.jdesktop.jxlayer.plaf.effect.BufferedImageOpEffect;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jdesktop.swingx.painter.BusyPainter;

public class LockableDemo
extends JFrame {
    private JXLayer<JComponent> layer;
    private LockableUI blurUI = new LockableUI(new BufferedImageOpEffect(new BufferedImageOp[]{new BlurFilter()}));
    private EnhancedLockableUI embossUI = new EnhancedLockableUI(new BufferedImageOpEffect(new BufferedImageOp[]{new EmbossFilter()}));
    private LockableUI busyPainterUI = new BusyPainterUI();
    private JCheckBoxMenuItem disablingItem = new JCheckBoxMenuItem(new AbstractAction("Lock the layer"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LockableDemo.this.blurItem.setEnabled(!LockableDemo.this.disablingItem.isSelected());
            LockableDemo.this.embossItem.setEnabled(!LockableDemo.this.disablingItem.isSelected());
            LockableDemo.this.busyPainterItem.setEnabled(!LockableDemo.this.disablingItem.isSelected());
            LockableDemo.this.blurUI.setLocked(LockableDemo.this.disablingItem.isSelected());
            LockableDemo.this.embossUI.setLocked(LockableDemo.this.disablingItem.isSelected());
            LockableDemo.this.busyPainterUI.setLocked(LockableDemo.this.disablingItem.isSelected());
        }
    });
    private JRadioButtonMenuItem blurItem = new JRadioButtonMenuItem("Blur effect");
    private JRadioButtonMenuItem embossItem = new JRadioButtonMenuItem("Unlock button");
    private JRadioButtonMenuItem busyPainterItem = new JRadioButtonMenuItem("BusyPainter");

    public LockableDemo() {
        super("Lockable layer demo");
        this.setDefaultCloseOperation(3);
        JComponent view = this.createLayerPanel();
        this.layer = new JXLayer<JComponent>(view);
        this.layer.setUI(this.blurUI);
        this.add(this.layer);
        this.add((Component)this.createToolPanel(), "East");
        this.setJMenuBar(this.createMenuBar());
        this.setSize(380, 300);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LockableDemo().setVisible(true);
            }
        });
    }

    private JMenuBar createMenuBar() {
        JMenu menu = new JMenu("Menu");
        this.disablingItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        menu.add(this.disablingItem);
        menu.addSeparator();
        this.blurItem.setSelected(true);
        this.blurItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        menu.add(this.blurItem);
        this.embossItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        menu.add(this.embossItem);
        this.busyPainterItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        menu.add(this.busyPainterItem);
        ButtonGroup group = new ButtonGroup();
        group.add(this.blurItem);
        group.add(this.embossItem);
        group.add(this.busyPainterItem);
        ItemListener menuListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LockableDemo.this.blurItem.isSelected()) {
                    LockableDemo.this.layer.setUI(LockableDemo.this.blurUI);
                } else if (LockableDemo.this.embossItem.isSelected()) {
                    LockableDemo.this.layer.setUI(LockableDemo.this.embossUI);
                } else if (LockableDemo.this.busyPainterItem.isSelected()) {
                    LockableDemo.this.layer.setUI(LockableDemo.this.busyPainterUI);
                }
            }
        };
        this.blurItem.addItemListener(menuListener);
        this.embossItem.addItemListener(menuListener);
        this.busyPainterItem.addItemListener(menuListener);
        this.embossUI.getUnlockButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockableDemo.this.disablingItem.doClick();
            }
        });
        JMenuBar bar = new JMenuBar();
        bar.add(menu);
        bar.add(new LafMenu());
        return bar;
    }

    private JComponent createLayerPanel() {
        JPanel panel = new JPanel();
        JDesktopPane desk = new JDesktopPane();
        desk.setSize(100, 100);
        panel.add(desk);
        JInternalFrame frame = new JInternalFrame("aaa");
        frame.setSize(50, 50);
        desk.add(frame);
        frame.setVisible(true);
        panel.add(new JCheckBox("JCheckBox"));
        panel.add(new JRadioButton("JRadioButton"));
        panel.add(new JTextField(15));
        JButton button = new JButton("Have a nice day");
        button.setMnemonic('H');
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(LockableDemo.this, "actionPerformed");
            }
        });
        panel.add(button);
        panel.add(new JTextField(15));
        panel.add(new JCheckBox("JCheckBox"));
        panel.add(new JRadioButton("JRadioButton"));
        panel.add(new JTextField(15));
        panel.add(new JCheckBox("JCheckBox"));
        panel.add(new JRadioButton("JRadioButton"));
        panel.setBorder(BorderFactory.createEtchedBorder());
        return panel;
    }

    private JComponent createToolPanel() {
        Box box = Box.createVerticalBox();
        JCheckBox button = new JCheckBox(this.disablingItem.getText());
        button.setModel(this.disablingItem.getModel());
        box.add(Box.createGlue());
        box.add(button);
        box.add(Box.createGlue());
        JRadioButton blur = new JRadioButton(this.blurItem.getText());
        blur.setModel(this.blurItem.getModel());
        box.add(blur);
        JRadioButton emboss = new JRadioButton(this.embossItem.getText());
        emboss.setModel(this.embossItem.getModel());
        box.add(emboss);
        JRadioButton translucent = new JRadioButton(this.busyPainterItem.getText());
        translucent.setModel(this.busyPainterItem.getModel());
        box.add(translucent);
        box.add(Box.createGlue());
        return box;
    }

    public static class BusyPainterUI
    extends LockableUI
    implements ActionListener {
        private BusyPainter busyPainter = new BusyPainter(){

            protected void doPaint(Graphics2D g, JComponent object, int width, int height) {
                Rectangle r = this.getTrajectory().getBounds();
                int tw = width - r.width - 2 * r.x;
                int th = height - r.height - 2 * r.y;
                g.translate(tw / 2, th / 2);
                super.doPaint(g, (Object)object, width, height);
            }
        };
        private Timer timer;
        private int frameNumber;

        public BusyPainterUI() {
            this.busyPainter.setPointShape((Shape)new Ellipse2D.Double(0.0, 0.0, 20.0, 20.0));
            this.busyPainter.setTrajectory((Shape)new Ellipse2D.Double(0.0, 0.0, 100.0, 100.0));
            this.timer = new Timer(100, this);
        }

        @Override
        protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
            super.paintLayer(g2, l);
            if (this.isLocked()) {
                this.busyPainter.paint(g2, l, l.getWidth(), l.getHeight());
            }
        }

        @Override
        public void setLocked(boolean isLocked) {
            super.setLocked(isLocked);
            if (isLocked) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.frameNumber = (this.frameNumber + 1) % 8;
            this.busyPainter.setFrame(this.frameNumber);
            this.setDirty(true);
        }
    }

    public static class EnhancedLockableUI
    extends LockableUI {
        private JButton unlockButton = new JButton("Unlock");

        public EnhancedLockableUI(LayerEffect ... lockedEffects) {
            super(lockedEffects);
            this.unlockButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnhancedLockableUI.this.setLocked(false);
                }
            });
            this.unlockButton.setVisible(false);
        }

        public AbstractButton getUnlockButton() {
            return this.unlockButton;
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            JXLayer l = (JXLayer)c;
            l.getGlassPane().setLayout(new GridBagLayout());
            l.getGlassPane().add(this.unlockButton);
            this.unlockButton.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            JXLayer l = (JXLayer)c;
            l.getGlassPane().setLayout(new FlowLayout());
            l.getGlassPane().remove(this.unlockButton);
        }

        @Override
        public void setLocked(boolean isLocked) {
            super.setLocked(isLocked);
            this.unlockButton.setVisible(isLocked);
        }
    }
}

