/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;

public class SpotLightUI
extends AbstractBufferedLayerUI<JComponent> {
    private ArrayList<Shape> clipList = new ArrayList();
    private Color overlayColor;
    private int softClipWidth;
    private boolean isEnabled;

    public SpotLightUI() {
        this(0);
    }

    public SpotLightUI(int softClipWidth) {
        this(new Color(0, 0, 0, 128), softClipWidth);
    }

    public SpotLightUI(Color overlayColor, int softClipWidth) {
        this.setOverlayColor(overlayColor);
        this.setSoftClipWidth(softClipWidth);
    }

    @Override
    public long getLayerEventMask() {
        return 0L;
    }

    private void softClipping(Graphics2D g2, Shape shape) {
        g2.setComposite(AlphaComposite.Src);
        for (int i = 0; i < this.softClipWidth; ++i) {
            int alpha = (i + 1) * this.overlayColor.getAlpha() / (this.softClipWidth + 1);
            Color temp = new Color(this.overlayColor.getRed(), this.overlayColor.getGreen(), this.overlayColor.getBlue(), alpha);
            g2.setColor(temp);
            g2.setStroke(new BasicStroke(this.softClipWidth - i));
            g2.draw(shape);
        }
    }

    public boolean isShadowEnabled() {
        return this.isEnabled;
    }

    public void setShadowEnabled(boolean enabled) {
        boolean old = this.isShadowEnabled();
        this.isEnabled = enabled;
        this.firePropertyChange("shadowEnabled", old, this.isEnabled);
    }

    public Color getOverlayColor() {
        return this.overlayColor;
    }

    public void setOverlayColor(Color overlayColor) {
        if (overlayColor == null) {
            throw new IllegalArgumentException("overlayColor is null");
        }
        Color oldColor = this.getOverlayColor();
        this.overlayColor = overlayColor;
        this.firePropertyChange("overlayColor", oldColor, overlayColor);
    }

    public int getSoftClipWidth() {
        return this.softClipWidth;
    }

    public void setSoftClipWidth(int softClipWidth) {
        if (softClipWidth < 0) {
            throw new IllegalArgumentException("softClipWidth can't be less than 0");
        }
        int oldClipWidth = this.getSoftClipWidth();
        this.softClipWidth = softClipWidth;
        this.firePropertyChange("softClipWidth", oldClipWidth, softClipWidth);
    }

    public void reset() {
        this.clipList.clear();
        this.setDirty(true);
    }

    public void addShape(Shape shape) {
        this.clipList.add(shape);
        this.setDirty(true);
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends JComponent> l) {
        return false;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        c.paint(g);
        if (this.isShadowEnabled()) {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(this.overlayColor);
        g2.fillRect(0, 0, l.getWidth(), l.getHeight());
        for (Shape shape : this.clipList) {
            g2.setClip(shape);
            g2.setComposite(AlphaComposite.Clear);
            g2.fill(shape);
            this.softClipping(g2, shape);
        }
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.isShadowEnabled()) {
            for (Shape shape : this.clipList) {
                if (!shape.contains(x, y)) continue;
                return true;
            }
            return false;
        }
        return super.contains(c, x, y);
    }
}

