/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.invoicex;

import it.tnx.commons.DebugFastUtils;
import it.tnx.commons.SwingUtils;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.DropMode;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;

public class InvoicexUtil6 {
    public static void initAllegati(JTable tabAllegati, JTabbedPane panTab, JPanel panAllegati) {
        tabAllegati.setDropMode(DropMode.INSERT_ROWS);
        tabAllegati.setTransferHandler(new AllegatiTransfHandler(tabAllegati, panTab, panAllegati));
    }

    public static void aggiornaTitleAllegati(Integer quanti, JTabbedPane panTab, JPanel panAllegati) {
        for (int i = 0; i < panTab.getComponentCount(); ++i) {
            try {
                System.out.println("panTab.getTabComponentAt(i) = " + panTab.getComponent(i).getName());
                if (panTab.getComponentAt(i) != panAllegati) continue;
                if (quanti > 0) {
                    panTab.setTitleAt(i, "Allegati (" + quanti + ")");
                    continue;
                }
                panTab.setTitleAt(i, "Allegati");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class AllegatiTransfHandler
    extends TransferHandler {
        JTable tab;
        JTabbedPane panTab;
        JPanel panAllegati;
        DefaultTableModel model = null;

        public AllegatiTransfHandler(JTable tab, JTabbedPane panTab, JPanel panAllegati) {
            this.tab = tab;
            this.panTab = panTab;
            this.panAllegati = panAllegati;
            this.model = (DefaultTableModel)tab.getModel();
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDrop();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            Object data;
            if (!this.canImport(support)) {
                return false;
            }
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            int row = dl.getRow();
            try {
                data = support.getTransferable().getTransferData(DataFlavor.imageFlavor);
                System.out.println("datai = " + data);
                DebugFastUtils.dump((Object)data);
                File ftemp = File.createTempFile("immagine_", ".jpg");
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)data), "jpg", ftemp);
                    this.aggiungi(ftemp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                data = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                System.out.println("dataf = " + data);
                DebugFastUtils.dump((Object)data);
                List files = (List)data;
                for (File file : files) {
                    System.out.println("file = " + file);
                    try {
                        this.aggiungi(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                data = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            Object[] rowData = ((String)data).split(",");
            this.model.insertRow(row, rowData);
            Rectangle rect = this.tab.getCellRect(row, 0, false);
            if (rect != null) {
                this.tab.scrollRectToVisible(rect);
            }
            return true;
        }

        public static String humanReadableByteCount(long bytes, boolean si) {
            int unit;
            int n = unit = si ? 1000 : 1024;
            if (bytes < (long)unit) {
                return bytes + " B";
            }
            int exp = (int)(Math.log(bytes) / Math.log(unit));
            String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
            return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        }

        private void aggiungi(File ftemp) {
            int max_file_size = 10000000;
            if (ftemp.exists()) {
                if (ftemp.length() <= (long)max_file_size) {
                    Object file;
                    DefaultTableModel model = (DefaultTableModel)this.tab.getModel();
                    Object[] row = new Object[6];
                    row[1] = ftemp;
                    String nome = ftemp.getName();
                    String ext = StringUtils.substringAfterLast((String)nome, (String)".");
                    row[2] = ext;
                    row[3] = ftemp.lastModified();
                    row[4] = ftemp.length();
                    int rowfree = 0;
                    for (int i = 0; i < this.tab.getRowCount() && (file = this.tab.getValueAt(i, 1)) != null; ++i) {
                        ++rowfree;
                    }
                    model.insertRow(rowfree, row);
                    InvoicexUtil6.aggiornaTitleAllegati(rowfree + 1, this.panTab, this.panAllegati);
                    this.tab.getSelectionModel().setSelectionInterval(rowfree, rowfree);
                } else {
                    SwingUtils.showErrorMessage(null, (String)("Il file \u00e8 troppo grande, massimo " + AllegatiTransfHandler.humanReadableByteCount(max_file_size, true)));
                }
            }
        }
    }
}

