/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.helper;

import com.sdicons.json.helper.Helper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HelperRepository<T extends Helper> {
    private HelperTreeNode<T> root = new HelperTreeNode<RootHelper>(new RootHelper());

    public void addHelper(T aHelper) {
        this.root.insertNode(new HelperTreeNode<T>(aHelper));
    }

    public T findHelper(Class aClass) {
        return this.root.findHelper(aClass);
    }

    public String prettyPrint() {
        return this.root.prettyPrint("");
    }

    private static class RootHelper
    implements Helper {
        private RootHelper() {
        }

        @Override
        public Class getHelpedClass() {
            return Object.class;
        }
    }

    private static class HelperTreeNode<T extends Helper> {
        private T helper;
        private List<HelperTreeNode<T>> children;

        public HelperTreeNode(T aClass) {
            this.helper = aClass;
            this.children = new LinkedList<HelperTreeNode<T>>();
        }

        public T getHelper() {
            return this.helper;
        }

        public boolean insertNode(HelperTreeNode<T> aNode) {
            if (aNode.getHelper().getHelpedClass() == this.helper.getHelpedClass()) {
                this.helper = aNode.getHelper();
                return true;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aNode.getHelper().getHelpedClass())) {
                boolean insertedToSomeChild = false;
                for (HelperTreeNode<T> lChildren : this.children) {
                    boolean lSuccess = lChildren.insertNode(aNode);
                    if (!lSuccess) continue;
                    insertedToSomeChild = true;
                    break;
                }
                if (!insertedToSomeChild) {
                    Iterator<HelperTreeNode<T>> lIter2 = this.children.iterator();
                    while (lIter2.hasNext()) {
                        HelperTreeNode<T> lChild = lIter2.next();
                        if (!aNode.getHelper().getHelpedClass().isAssignableFrom(lChild.getHelper().getHelpedClass())) continue;
                        lIter2.remove();
                        aNode.insertNode(lChild);
                    }
                    this.children.add(aNode);
                }
                return true;
            }
            return false;
        }

        T findHelper(Class aClass) {
            if (this.helper.getHelpedClass() == aClass) {
                return this.helper;
            }
            for (HelperTreeNode<T> lChildNode : this.children) {
                T lHelper = lChildNode.findHelper(aClass);
                if (lHelper == null) continue;
                return lHelper;
            }
            if (this.helper.getHelpedClass().isAssignableFrom(aClass)) {
                return this.helper;
            }
            return null;
        }

        public String prettyPrint(String aIndent) {
            StringBuilder lBld = new StringBuilder(aIndent);
            lBld.append(this.helper.getHelpedClass().getName());
            for (HelperTreeNode<T> lChild : this.children) {
                lBld.append("\n");
                lBld.append(lChild.prettyPrint(aIndent + "   "));
            }
            return lBld.toString();
        }
    }
}

