/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class ArrayMapper
implements SimpleMapperHelper {
    @Override
    public JSONValue toJSON(Object aObj) throws MapperException {
        JSONArray lElements;
        block12: {
            block10: {
                int i;
                Object[] lArr;
                String lComponentName;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        Class<?> lClass = aObj.getClass();
                                        String lObjClassName = lClass.getName();
                                        lComponentName = "unknown";
                                        lComponentName = lObjClassName.startsWith("[L") ? lObjClassName.substring(2, lObjClassName.length() - 1) : lObjClassName.substring(1);
                                        lElements = new JSONArray();
                                        if (!this.isPrimitiveArray(lComponentName)) break block10;
                                        if ("I".equals(lComponentName)) {
                                            lArr = (int[])aObj;
                                            for (i = 0; i < lArr.length; ++i) {
                                                lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                                            }
                                        }
                                        if (!"C".equals(lComponentName)) break block11;
                                        lArr = (char[])aObj;
                                        for (i = 0; i < lArr.length; ++i) {
                                            lElements.getValue().add(JSONMapper.toJSON(Character.valueOf(lArr[i])));
                                        }
                                        break block12;
                                    }
                                    if (!"Z".equals(lComponentName)) break block13;
                                    lArr = (boolean[])aObj;
                                    for (i = 0; i < lArr.length; ++i) {
                                        lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                                    }
                                    break block12;
                                }
                                if (!"S".equals(lComponentName)) break block14;
                                lArr = (short[])aObj;
                                for (i = 0; i < lArr.length; ++i) {
                                    lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                                }
                                break block12;
                            }
                            if (!"B".equals(lComponentName)) break block15;
                            lArr = (byte[])aObj;
                            for (i = 0; i < lArr.length; ++i) {
                                lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                            }
                            break block12;
                        }
                        if (!"J".equals(lComponentName)) break block16;
                        lArr = (long[])aObj;
                        for (i = 0; i < lArr.length; ++i) {
                            lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                        }
                        break block12;
                    }
                    if (!"F".equals(lComponentName)) break block17;
                    lArr = (float[])aObj;
                    for (i = 0; i < lArr.length; ++i) {
                        lElements.getValue().add(JSONMapper.toJSON(Float.valueOf(lArr[i])));
                    }
                    break block12;
                }
                if (!"D".equals(lComponentName)) break block12;
                lArr = (double[])aObj;
                for (i = 0; i < lArr.length; ++i) {
                    lElements.getValue().add(JSONMapper.toJSON(lArr[i]));
                }
                break block12;
            }
            for (Object lArrEl : Arrays.asList((Object[])aObj)) {
                lElements.getValue().add(JSONMapper.toJSON(lArrEl));
            }
        }
        return lElements;
    }

    @Override
    public Class getHelpedClass() {
        return null;
    }

    private boolean isPrimitiveArray(String aClassName) {
        return "I".equals(aClassName) || "Z".equals(aClassName) || "S".equals(aClassName) || "B".equals(aClassName) || "J".equals(aClassName) || "F".equals(aClassName) || "D".equals(aClassName) || "C".equals(aClassName);
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (!aValue.isArray()) {
            throw new MapperException("ArrayMapper cannot map: " + aValue.getClass().getName());
        }
        JSONArray lValues = (JSONArray)aValue;
        String lObjClassName = aRequestedClass.getName();
        String lArrClassName = "unknown";
        lArrClassName = lObjClassName.startsWith("[L") ? lObjClassName.substring(2, lObjClassName.length() - 1) : lObjClassName.substring(1);
        LinkedList<Object> lElements = new LinkedList<Object>();
        for (JSONValue jsonValue : lValues.getValue()) {
            try {
                if (this.isPrimitiveArray(lArrClassName)) {
                    Class primitiveClass = null;
                    if ("I".equals(lArrClassName)) {
                        primitiveClass = Integer.class;
                    } else if ("C".equals(lArrClassName)) {
                        primitiveClass = Character.class;
                    } else if ("Z".equals(lArrClassName)) {
                        primitiveClass = Boolean.class;
                    } else if ("S".equals(lArrClassName)) {
                        primitiveClass = Short.class;
                    } else if ("B".equals(lArrClassName)) {
                        primitiveClass = Byte.class;
                    } else if ("J".equals(lArrClassName)) {
                        primitiveClass = Long.class;
                    } else if ("F".equals(lArrClassName)) {
                        primitiveClass = Float.class;
                    } else if ("D".equals(lArrClassName)) {
                        primitiveClass = Double.class;
                    } else {
                        String lMsg = "Unknown primitive array type: " + lArrClassName;
                        throw new MapperException(lMsg);
                    }
                    lElements.add(JSONMapper.toJava(jsonValue, primitiveClass));
                    continue;
                }
                lElements.add(JSONMapper.toJava(jsonValue, Class.forName(lArrClassName)));
            }
            catch (ClassNotFoundException e) {
                throw new MapperException("No Class Found: " + lArrClassName);
            }
        }
        int lArrSize = lElements.size();
        if (this.isPrimitiveArray(lArrClassName)) {
            Iterator lIter;
            Object[] lArr;
            if ("I".equals(lArrClassName)) {
                lArr = new int[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (Integer)lIter.next();
                    ++i;
                }
                return lArr;
            }
            if ("C".equals(lArrClassName)) {
                lArr = new char[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Character)lIter.next()).charValue();
                    ++i;
                }
                return lArr;
            }
            if ("Z".equals(lArrClassName)) {
                lArr = new boolean[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Boolean)lIter.next()).booleanValue() ? 1 : 0;
                    ++i;
                }
                return lArr;
            }
            if ("S".equals(lArrClassName)) {
                lArr = new short[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Short)lIter.next()).shortValue();
                    ++i;
                }
                return lArr;
            }
            if ("B".equals(lArrClassName)) {
                lArr = new byte[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = ((Byte)lIter.next()).byteValue();
                    ++i;
                }
                return lArr;
            }
            if ("J".equals(lArrClassName)) {
                lArr = new long[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Long)lIter.next()).longValue();
                    ++i;
                }
                return lArr;
            }
            if ("F".equals(lArrClassName)) {
                lArr = new float[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Float)lIter.next()).floatValue();
                    ++i;
                }
                return lArr;
            }
            if ("D".equals(lArrClassName)) {
                lArr = new double[lArrSize];
                lIter = lElements.iterator();
                int i = 0;
                while (lIter.hasNext()) {
                    lArr[i] = (int)((Double)lIter.next()).doubleValue();
                    ++i;
                }
                return lArr;
            }
            String lMsg = "Unknown primitive array type: " + lArrClassName;
            throw new MapperException(lMsg);
        }
        try {
            Class<?> lComponentClass = Class.forName(lArrClassName);
            Object lArr = Array.newInstance(lComponentClass, lArrSize);
            Iterator lIter = lElements.iterator();
            int i = 0;
            while (lIter.hasNext()) {
                Array.set(lArr, i, lIter.next());
                ++i;
            }
            return lArr;
        }
        catch (ClassNotFoundException e) {
            String lMsg = "Exception while trying to unmarshall an array of JavaObjects: " + lArrClassName;
            throw new MapperException(lMsg);
        }
    }
}

