/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.serializer.helper.MarshallHelper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class DateHelper
implements MarshallHelper {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS z");

    public DateHelper() {
        this.dateFormat.setLenient(false);
    }

    @Override
    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        aObjectElement.getValue().put("=", new JSONString(this.dateFormat.format((Date)aObj)));
    }

    @Override
    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONMarshall.requireStringAttribute(aObjectElement, "=");
        try {
            return this.dateFormat.parse(((JSONString)aObjectElement.get("=")).getValue().trim());
        }
        catch (Exception e) {
            throw new MarshallException(e.getMessage());
        }
    }

    @Override
    public Class getHelpedClass() {
        return Date.class;
    }
}

