/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.marshall;

import com.sdicons.json.serializer.marshall.MarshallException;
import com.sdicons.json.serializer.marshall.MarshallValue;

public class MarshallValueImpl
implements MarshallValue {
    private boolean resultBoolean = false;
    private byte resultByte = 0;
    private short resultShort = 0;
    private char resultChar = (char)32;
    private int resultInt = 0;
    private long resultLong = 0L;
    private float resultFloat = 0.0f;
    private double resultDouble = 0.0;
    private Object resultReference = null;
    private int resultType;

    private MarshallValueImpl() {
    }

    public MarshallValueImpl(boolean aBool) {
        this();
        this.resultType = 0;
        this.resultBoolean = aBool;
    }

    public MarshallValueImpl(byte aByte) {
        this();
        this.resultType = 1;
        this.resultByte = aByte;
    }

    public MarshallValueImpl(char aChar) {
        this();
        this.resultType = 3;
        this.resultChar = aChar;
    }

    public MarshallValueImpl(double aDouble) {
        this();
        this.resultType = 7;
        this.resultDouble = aDouble;
    }

    public MarshallValueImpl(float aFloat) {
        this();
        this.resultType = 6;
        this.resultFloat = aFloat;
    }

    public MarshallValueImpl(int aInt) {
        this();
        this.resultType = 4;
        this.resultInt = aInt;
    }

    public MarshallValueImpl(long aLong) {
        this();
        this.resultType = 5;
        this.resultLong = aLong;
    }

    public MarshallValueImpl(short aShort) {
        this();
        this.resultType = 2;
        this.resultShort = aShort;
    }

    public MarshallValueImpl(Object aReference) {
        this();
        this.resultType = 8;
        this.resultReference = aReference;
    }

    @Override
    public int getType() {
        return this.resultType;
    }

    @Override
    public boolean getBoolean() throws MarshallException {
        if (this.resultType == 0) {
            return this.resultBoolean;
        }
        String lMsg = "No boolean result available.";
        throw new MarshallException("No boolean result available.");
    }

    @Override
    public byte getByte() throws MarshallException {
        if (this.resultType == 1) {
            return this.resultByte;
        }
        String lMsg = "No byte result available.";
        throw new MarshallException("No byte result available.");
    }

    @Override
    public short getShort() throws MarshallException {
        if (this.resultType == 2) {
            return this.resultShort;
        }
        String lMsg = "No short result available.";
        throw new MarshallException("No short result available.");
    }

    @Override
    public char getChar() throws MarshallException {
        if (this.resultType == 3) {
            return this.resultChar;
        }
        String lMsg = "No char result available.";
        throw new MarshallException("No char result available.");
    }

    @Override
    public int getInt() throws MarshallException {
        if (this.resultType == 4) {
            return this.resultInt;
        }
        String lMsg = "No int result available.";
        throw new MarshallException(lMsg);
    }

    @Override
    public long getLong() throws MarshallException {
        if (this.resultType == 5) {
            return this.resultLong;
        }
        String lMsg = "No long result available.";
        throw new MarshallException("No long result available.");
    }

    @Override
    public float getFloat() throws MarshallException {
        if (this.resultType == 6) {
            return this.resultFloat;
        }
        String lMsg = "No float result available.";
        throw new MarshallException("No float result available.");
    }

    @Override
    public double getDouble() throws MarshallException {
        if (this.resultType == 7) {
            return this.resultDouble;
        }
        String lMsg = "No double result available.";
        throw new MarshallException("No double result available.");
    }

    @Override
    public Object getReference() throws MarshallException {
        if (this.resultType == 8) {
            return this.resultReference;
        }
        String lMsg = "No reference result available.";
        throw new MarshallException("No reference result available.");
    }
}

