/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import com.sdicons.json.validator.impl.predicates.True;
import java.util.HashMap;
import java.util.Iterator;

public class Content
extends Predicate {
    private Validator rule;

    public Content(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        this.rule = new True(aName, aRule);
        if (aRule.containsKey("rule")) {
            ValidatorUtil.requiresAttribute(aRule, "rule", JSONObject.class);
            this.rule = ValidatorUtil.buildValidator(aRule.get("rule"), aRuleset);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        Iterator<JSONValue> lIter = null;
        if (aValue.isArray()) {
            lIter = ((JSONArray)aValue).getValue().iterator();
        } else if (aValue.isObject()) {
            lIter = ((JSONObject)aValue).getValue().values().iterator();
        } else {
            this.fail("The value is not a JSONComplex, it has no content.", aValue);
        }
        if (lIter != null) {
            while (lIter.hasNext()) {
                JSONValue lVal = lIter.next();
                this.rule.validate(lVal);
            }
        }
    }
}

