/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONBoolean;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import com.sdicons.json.validator.impl.predicates.True;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Properties
extends Predicate {
    private List<PropRule> required = new LinkedList<PropRule>();
    private HashMap<String, PropRule> all = new HashMap();

    public Properties(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "pairs", JSONArray.class);
        List<JSONValue> lPairs = ((JSONArray)aRule.get("pairs")).getValue();
        for (JSONValue lPair : lPairs) {
            if (!lPair.isObject()) {
                String lMsg = "A pair should be described by a JSONObject.";
                throw new ValidationException("A pair should be described by a JSONObject.", lPair, "JSONObject EXPECTED");
            }
            JSONObject lObj = (JSONObject)lPair;
            ValidatorUtil.requiresAttribute(lObj, "key", JSONString.class);
            String lKeyname = ((JSONString)lObj.get("key")).getValue();
            Validator lValrule = new True("[anonymous rule]", aRule);
            if (lObj.containsKey("rule")) {
                ValidatorUtil.requiresAttribute(lObj, "rule", JSONObject.class);
                lValrule = ValidatorUtil.buildValidator(lObj.get("rule"), aRuleset);
            }
            boolean lOptional = false;
            if (lObj.containsKey("optional")) {
                ValidatorUtil.requiresAttribute(lObj, "optional", JSONBoolean.class);
                lOptional = ((JSONBoolean)lObj.get("optional")).getValue();
            }
            PropRule lRule = new PropRule(lKeyname, lValrule, lOptional);
            this.all.put(lKeyname, lRule);
            if (lOptional) continue;
            this.required.add(lRule);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        if (!aValue.isObject()) {
            this.fail("The value is not a JSONObject.", aValue);
        }
        JSONObject lObj = (JSONObject)aValue;
        for (PropRule aRequired : this.required) {
            if (lObj.containsKey(aRequired.getKey())) continue;
            this.fail("The object lacks a required key: \"" + aRequired.getKey() + "\".", aValue);
        }
        for (String lKey : lObj.getValue().keySet()) {
            if (!this.all.containsKey(lKey)) {
                this.fail("The object contains an unspecified key: \"" + lKey + "\".", aValue);
            }
            PropRule lRule = this.all.get(lKey);
            try {
                lRule.getRule().validate(lObj.get(lKey));
            }
            catch (ValidationException e) {
                this.fail("The object property: \"" + lKey + "\" has invalid content. Internal message: " + e.getMessage(), aValue);
            }
        }
    }

    private static class PropRule {
        private String key;
        private Validator rule;
        private boolean optional;

        public PropRule(String key, Validator rule, boolean optional) {
            this.key = key;
            this.rule = rule;
            this.optional = optional;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Validator getRule() {
            return this.rule;
        }

        public void setRule(Validator rule) {
            this.rule = rule;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }
    }
}

