/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONDecimal;
import com.sdicons.json.model.JSONInteger;
import com.sdicons.json.model.JSONNumber;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.math.BigDecimal;

public class Range
extends Predicate {
    private BigDecimal minValue = null;
    private BigDecimal maxValue = null;

    public Range(String aName, JSONObject aRule) throws ValidationException {
        super(aName, aRule);
        if (aRule.containsKey("min")) {
            JSONValue lMin = aRule.get("min");
            if (!lMin.isNumber()) {
                String lMsg = "Minimum length should be specified using a number.";
                throw new ValidationException("Minimum length should be specified using a number.", aRule, "WRONG TYPE");
            }
            this.minValue = this.cvtNumber((JSONNumber)lMin);
        }
        if (aRule.containsKey("max")) {
            JSONValue lMax = aRule.get("max");
            if (!lMax.isInteger()) {
                String lMsg = "Maximum length should be specified using an integer.";
                throw new ValidationException("Maximum length should be specified using an integer.", aRule, "WRONG TYPE");
            }
            this.maxValue = this.cvtNumber((JSONNumber)lMax);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        if (!aValue.isNumber()) {
            this.fail("The value is not a JSONNumber.", aValue);
        }
        BigDecimal lSize = this.cvtNumber((JSONNumber)aValue);
        if (this.minValue != null && lSize.compareTo(this.minValue) < 0) {
            this.fail("The size (" + lSize + ") is smaller then allowed (" + this.minValue + ").", aValue);
        }
        if (this.maxValue != null && lSize.compareTo(this.maxValue) > 0) {
            this.fail("The size (" + lSize + ") is larger then allowed (" + this.maxValue + ").", aValue);
        }
    }

    private BigDecimal cvtNumber(JSONNumber aNum) {
        if (aNum.isInteger()) {
            return new BigDecimal(((JSONInteger)aNum).getValue());
        }
        return ((JSONDecimal)aNum).getValue();
    }
}

