/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.HashMap;

public class Ref
extends Predicate {
    private HashMap<String, Validator> ruleset;
    private String ref;

    public Ref(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        this.ruleset = aRuleset;
        ValidatorUtil.requiresAttribute(aRule, "*", JSONString.class);
        this.ref = ((JSONString)aRule.get("*")).getValue();
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        if (this.ruleset.containsKey(this.ref)) {
            Validator lValidator = this.ruleset.get(this.ref);
            lValidator.validate(aValue);
        } else {
            this.fail("Reference to an unexisting rule: \"" + this.ref + "\".", aValue);
        }
    }
}

