/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Regexp
extends Predicate {
    private Pattern pattern;
    private String representation;

    public Regexp(String aName, JSONObject aRule) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "pattern", JSONString.class);
        String lPattern = ((JSONString)aRule.get("pattern")).getValue();
        try {
            this.pattern = Pattern.compile(lPattern);
            this.representation = lPattern;
        }
        catch (PatternSyntaxException e) {
            this.fail("Error while compiling the pattern: " + e.getMessage(), aRule);
        }
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        String lString;
        Matcher lMatcher;
        if (!aValue.isString()) {
            this.fail("The value is not a JSONString.", aValue);
        }
        if (!(lMatcher = this.pattern.matcher(lString = ((JSONString)aValue).getValue())).matches()) {
            this.fail("The string: \"" + lString + "\" does not match the pattern: \"" + this.representation + "\".", aValue);
        }
    }
}

