/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.validator.impl.predicates;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.validator.ValidationException;
import com.sdicons.json.validator.Validator;
import com.sdicons.json.validator.impl.ValidatorUtil;
import com.sdicons.json.validator.impl.predicates.Predicate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class Switch
extends Predicate {
    private List<Case> rules = new LinkedList<Case>();
    private String key;

    public Switch(String aName, JSONObject aRule, HashMap<String, Validator> aRuleset) throws ValidationException {
        super(aName, aRule);
        ValidatorUtil.requiresAttribute(aRule, "case", JSONArray.class);
        List<JSONValue> lCases = ((JSONArray)aRule.get("case")).getValue();
        for (JSONValue lCase : lCases) {
            if (!lCase.isObject()) {
                this.fail("A case in a swicht should be an object type.", lCase);
            }
            JSONObject lObjCase = (JSONObject)lCase;
            ValidatorUtil.requiresAttribute(lObjCase, "rule", JSONObject.class);
            JSONObject lRule = (JSONObject)lObjCase.get("rule");
            Validator lValidator = ValidatorUtil.buildValidator(lRule, aRuleset);
            ValidatorUtil.requiresAttribute(lObjCase, "values", JSONArray.class);
            JSONArray lVals = (JSONArray)lObjCase.get("values");
            Case lNewCase = new Case(lValidator, lVals.getValue());
            this.rules.add(lNewCase);
        }
        ValidatorUtil.requiresAttribute(aRule, "key", JSONString.class);
        this.key = ((JSONString)aRule.get("key")).getValue();
    }

    @Override
    public void validate(JSONValue aValue) throws ValidationException {
        JSONObject lObj;
        if (!aValue.isObject()) {
            this.fail("The value is not a JSONObject.", aValue);
        }
        if (!(lObj = (JSONObject)aValue).containsKey(this.key)) {
            this.fail("The object does not contain the key: \"" + this.key + "\".", lObj);
        }
        JSONValue lVal = lObj.get(this.key);
        for (Case aCase : this.rules) {
            if (!aCase.isApplicable(lVal)) continue;
            aCase.getValidator().validate(lObj);
            return;
        }
        this.fail("No applicable rule found for key: \"" + this.key + "\", value: " + lVal.toString(), aValue);
    }

    private static class Case {
        private List<JSONValue> values;
        private Validator validator;

        public Case(Validator validator, List<JSONValue> values) {
            this.validator = validator;
            this.values = values;
        }

        public Validator getValidator() {
            return this.validator;
        }

        public boolean isApplicable(JSONValue aVal) {
            return this.values.contains(aVal);
        }
    }
}

