/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.RunnableWithArgs;
import it.tnx.commons.SwingUtils;
import it.tnx.commons.SystemUtils;
import it.tnx.commons.cu;
import it.tnx.commons.dbu;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class DbVersion {
    String modulo = null;
    Integer versione = null;
    Date ts = null;
    RunnableWithArgs showAttesa = null;
    public Map running = null;

    public DbVersion(Connection conn, String modulo) throws Exception {
        this(conn, modulo, null);
    }

    public DbVersion(Connection conn, String modulo, RunnableWithArgs showAttesa) throws Exception {
        this.modulo = modulo;
        this.showAttesa = showAttesa;
        ArrayList<Map> ret = dbu.getListMap(conn, "select * from db_version where modulo = " + dbu.sql(modulo));
        if (ret.isEmpty()) {
            this.versione = 0;
            String sql = "insert into db_version set modulo = " + dbu.sql(modulo) + ", versione = 0";
            dbu.tryExecQuery(conn, sql);
        } else {
            this.versione = cu.i(((Map)ret.get(0)).get("versione"));
            Object o = ((Map)ret.get(0)).get("ts");
            System.out.println("o = " + o);
        }
    }

    public Integer getVersion() {
        return this.versione;
    }

    public void setVersion(Connection conn, Integer versione) throws Exception {
        String sql = "update db_version set modulo = " + dbu.sql(this.modulo) + ", versione = " + dbu.sql(versione) + " where modulo = " + dbu.sql(this.modulo);
        dbu.tryExecQuery(conn, sql);
    }

    public boolean prenotaChanges(Connection conn) {
        return this.prenotaChanges(conn, 180);
    }

    public boolean prenotaChanges(Connection conn, int timeout_sec) {
        try {
            boolean ancora = true;
            boolean timeout = false;
            while (ancora) {
                this.running = dbu.getListMap(conn, "select *, now() as adesso from db_version where modulo = " + dbu.sql(this.modulo)).get(0);
                System.out.println("running = " + this.running);
                boolean ancorarunning = true;
                if (this.running.get("running_quando") != null) {
                    String chi = cu.s(this.running.get("running_chi"));
                    Date adessoserver = cu.toDate(this.running.get("adesso"));
                    Date quando = cu.toDate(this.running.get("running_quando"));
                    long temposecondi = (adessoserver.getTime() - quando.getTime()) / 1000L;
                    if (temposecondi < (long)timeout_sec) {
                        String msg = this.modulo + ": attendo aggiornamento db da altra postazione (" + ((long)timeout_sec - temposecondi) + " sec, " + chi + ")";
                        System.out.println(msg);
                        if (this.showAttesa != null) {
                            this.showAttesa.run(msg);
                        }
                        Thread.sleep(1000L);
                        continue;
                    }
                    System.out.println(this.modulo + ": sovrascrivo running lock per timeout");
                    ancora = false;
                    timeout = true;
                    continue;
                }
                ancora = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage(null, e);
            return false;
        }
        try {
            String hostname = SystemUtils.getHostname();
            System.out.println("prenotaChanges " + this.modulo + ", hostname = " + hostname);
            String sqlrun = "update db_version set running_chi = " + dbu.sql(hostname) + ", running_quando = NOW()" + " where modulo = " + dbu.sql(this.modulo);
            dbu.tryExecQuery(conn, sqlrun);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage(null, e);
            return false;
        }
    }

    public boolean rimuoviPrenotazioneChanges(Connection conn) {
        try {
            String sql = "update db_version set running_chi = null, running_quando = null where modulo = " + dbu.sql(this.modulo);
            dbu.tryExecQuery(conn, sql);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtils.showExceptionMessage(null, e);
            return false;
        }
    }
}

