/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) {
        try {
            this.standardTrustManager.checkClientTrusted(certificates, authType);
        }
        catch (CertificateException ex) {
            Logger.getLogger(EasyX509TrustManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) {
        if (certificates != null && certificates.length == 1) {
            try {
                certificates[0].checkValidity();
            }
            catch (CertificateExpiredException ex) {
                Logger.getLogger(EasyX509TrustManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (CertificateNotYetValidException ex) {
                Logger.getLogger(EasyX509TrustManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

