/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import it.tnx.commons.CastUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class FormatUtils {
    public static NumberFormat nf1;
    public static NumberFormat nf2;
    public static NumberFormat nf3;
    public static NumberFormat nf4;
    public static NumberFormat nf04;
    public static NumberFormat nf5;
    public static NumberFormat nf1d;
    public static NumberFormat nfeng22;
    public static NumberFormat nfeng25;
    public static NumberFormat nfeng02;
    public static NumberFormat nfeng05;
    public static NumberFormat nfnogroupnodec;
    public static SimpleDateFormat mysqlf1;
    public static SimpleDateFormat mysqlf2;
    public static SimpleDateFormat accf1;
    public static SimpleDateFormat accf2;

    public static String formatParametr(double value, int decimali, String virgola) {
        NumberFormat nfp;
        String string = virgola = virgola.equals("") ? "," : virgola;
        if (virgola.equals(",")) {
            nfp = NumberFormat.getNumberInstance(Locale.ITALIAN);
            nfp.setMaximumFractionDigits(decimali);
            nfp.setMinimumFractionDigits(decimali);
        } else {
            nfp = NumberFormat.getNumberInstance();
            nfp.setMaximumFractionDigits(decimali);
            nfp.setMinimumFractionDigits(decimali);
        }
        value = FormatUtils.round(value, decimali);
        String ret = nfp.format(value);
        ret = virgola.equals(",") ? ret.replace(".", "") : ret.replace(",", "");
        return ret;
    }

    public static String formatEuroIta(double value) {
        value = FormatUtils.round(value, 2);
        return nf1.format(value);
    }

    public static String formatEuroItaMax5(double value) {
        value = FormatUtils.round(value, 5);
        return nf3.format(value);
    }

    public static String formatPerc(double value) {
        value = FormatUtils.round(value, 2);
        return nf2.format(value);
    }

    public static String formatPerc(Object value, boolean seNullVuoto) {
        if (seNullVuoto && value == null) {
            return "";
        }
        value = FormatUtils.round(CastUtils.toDouble0(value), 2);
        return nf2.format(value);
    }

    public static String format1Dec(double value) {
        return nf1d.format(value);
    }

    public static String formatNumNoDec(double value) {
        return nf4.format(value);
    }

    public static String formatNum0_4Dec(double value) {
        return nf04.format(value);
    }

    public static String formatNum0_5Dec(double value) {
        return nf5.format(value);
    }

    public static String formatEngNum02Dec(double value) {
        return nfeng02.format(value);
    }

    public static String formatEngNum05Dec(double value) {
        return nfeng05.format(value);
    }

    public static String formatEngNum22Dec(double value) {
        return nfeng22.format(value);
    }

    public static String formatEngNum25Dec(double value) {
        return nfeng25.format(value);
    }

    public static String formatHHMMIta(long millis) {
        int ore = (int)(millis / 1000L / 60L / 60L);
        int min = (int)(millis / 1000L / 60L) - ore * 60;
        return ore + ":" + (String.valueOf(min).length() == 1 ? "0" + min : Integer.valueOf(min));
    }

    public static String formatHHMMSSIta(long millis) {
        String segno = "";
        if (millis < 0L) {
            segno = "-";
            millis = Math.abs(millis);
        }
        int ore = Math.abs((int)(millis / 1000L / 60L / 60L));
        int min = Math.abs((int)(millis / 1000L / 60L) - ore * 60);
        int ss = Math.abs((int)(millis / 1000L) - ore * 60 * 60 - min * 60);
        return segno + ore + ":" + (String.valueOf(min).length() == 1 ? "0" + min : Integer.valueOf(min)) + ":" + (String.valueOf(ss).length() == 1 ? "0" + ss : Integer.valueOf(ss));
    }

    public static String formatHHMMSSmsIta(long millis) {
        String segno = "";
        if (millis < 0L) {
            segno = "-";
            millis = Math.abs(millis);
        }
        int ore = (int)(millis / 1000L / 60L / 60L);
        int min = (int)(millis / 1000L / 60L) - ore * 60;
        int ss = (int)(millis / 1000L) - ore * 60 * 60 - min * 60;
        int ms = (int)millis - ore * 60 * 60 * 1000 - min * 60 * 1000 - ss * 1000;
        return segno + ore + ":" + (String.valueOf(min).length() == 1 ? "0" + min : Integer.valueOf(min)) + ":" + (String.valueOf(ss).length() == 1 ? "0" + ss : Integer.valueOf(ss)) + "." + StringUtils.left((String)String.valueOf(ms), (int)1);
    }

    public static String formatMysqlDate(Object date) {
        return mysqlf1.format(CastUtils.toDate(date));
    }

    public static String formatAccessDate(Object date) {
        return accf1.format(CastUtils.toDate(date));
    }

    public static String formatMysqlTimestamp(Date date) {
        return mysqlf2.format(date);
    }

    public static String formatMysqlTimestamp(Timestamp timestamp) {
        return mysqlf2.format(timestamp);
    }

    public static String formatAccessTimestamp(Date date) {
        return accf2.format(date);
    }

    public static String formatAccessTimestamp(Timestamp timestamp) {
        return accf2.format(timestamp);
    }

    public static double round(double x, int decimals) {
        try {
            if (Double.valueOf(x).isNaN()) {
                x = 0.0;
            }
            int decimali_aggiuntivi_affidabili = 4;
            double numero_che_arrotondo = Math.round(x * Math.pow(10.0, decimals + decimali_aggiuntivi_affidabili));
            return (double)Math.round(numero_che_arrotondo / Math.pow(10.0, decimali_aggiuntivi_affidabili)) / Math.pow(10.0, decimals);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double round_old(double x, int decimals) {
        try {
            if (Double.valueOf(x).isNaN()) {
                x = 0.0;
            }
            BigDecimal bd = new BigDecimal(String.valueOf(x));
            bd = bd.setScale(decimals, 4);
            return bd.doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static String fill(String str, int chars) {
        return FormatUtils.fill(str, chars, false);
    }

    public static String fill(String str, int chars, boolean alignRight) {
        if (str == null) {
            str = "";
        }
        try {
            if (str.length() > chars) {
                str = str.substring(0, chars);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int strlen = str.length();
        int fillerlen = chars;
        if (strlen <= chars) {
            fillerlen = chars - strlen;
        }
        char[] filler = new char[fillerlen];
        Arrays.fill(filler, ' ');
        if (alignRight) {
            return new String(filler) + str;
        }
        return str + new String(filler);
    }

    public static String zeroFill(Number number, int size) {
        return String.format("%0" + size + "d", number);
    }

    public static String zeroFill(String number, int size) {
        return String.format("%0" + size + "d", CastUtils.toInteger0(number));
    }

    public static String formatHHMMFromMinutes(int minutes) {
        float hours = (float)minutes / 60.0f;
        int hoursi = minutes / 60;
        float minf = hours - (float)hoursi;
        return hoursi + ":" + FormatUtils.zeroFill(Math.round(minf * 60.0f), 2);
    }

    public static String formatReadableHHMMFromMinutesIta(int minutes) {
        float hours = (float)minutes / 60.0f;
        int hoursi = minutes / 60;
        float minf = hours - (float)hoursi;
        int mini = (int)Math.ceil(minf * 60.0f);
        if (hoursi == 0 && mini == 0) {
            return "meno di un minuto";
        }
        return (hoursi == 0 ? "" : (hoursi == 1 ? "1 ora e " : hoursi + " ore e ")) + mini + " minut" + (mini == 1 ? "o" : "i");
    }

    public static void main(String[] args) {
        System.out.println(FormatUtils.formatEngNum22Dec(22.12345));
        System.out.println(FormatUtils.formatEngNum22Dec(22.12545));
        System.out.println(FormatUtils.formatEngNum22Dec(1022.12345));
        System.out.println(FormatUtils.formatReadableByteCount(1095L));
        System.out.println(FormatUtils.formatReadableHHMMFromMinutesIta(61));
    }

    public static String formatReadableByteCount(long bytes) {
        return FormatUtils.formatReadableByteCount(bytes, true);
    }

    public static String formatReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String formatNoGroupNoDec(Object val) {
        return nfnogroupnodec.format(val);
    }

    static {
        mysqlf1 = new SimpleDateFormat("yyyy-MM-dd");
        mysqlf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        accf1 = new SimpleDateFormat("MM/dd/yyyy");
        accf2 = new SimpleDateFormat("MM/dd/yyyy");
        nf1 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf1.setMaximumFractionDigits(2);
        nf1.setMinimumFractionDigits(2);
        nf2 = new DecimalFormat("0.##");
        nf3 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf3.setMaximumFractionDigits(5);
        nf3.setMinimumFractionDigits(2);
        nf4 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf4.setMaximumFractionDigits(0);
        nf04 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf04.setMinimumFractionDigits(0);
        nf04.setMaximumFractionDigits(4);
        nf5 = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf5.setMinimumFractionDigits(0);
        nf5.setMaximumFractionDigits(5);
        nfeng22 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfeng22.setMinimumFractionDigits(2);
        nfeng22.setMaximumFractionDigits(2);
        nfeng22.setGroupingUsed(false);
        nfeng02 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfeng02.setMinimumFractionDigits(0);
        nfeng02.setMaximumFractionDigits(2);
        nfeng02.setGroupingUsed(false);
        nfeng25 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfeng25.setMinimumFractionDigits(2);
        nfeng25.setMaximumFractionDigits(5);
        nfeng25.setGroupingUsed(false);
        nfeng05 = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfeng05.setMinimumFractionDigits(0);
        nfeng05.setMaximumFractionDigits(5);
        nfeng05.setGroupingUsed(false);
        nf1d = NumberFormat.getNumberInstance(Locale.ITALIAN);
        nf1d.setMaximumFractionDigits(1);
        nfnogroupnodec = NumberFormat.getNumberInstance(Locale.ENGLISH);
        nfnogroupnodec.setGroupingUsed(false);
        nfnogroupnodec.setMaximumFractionDigits(0);
        nfnogroupnodec.setMinimumFractionDigits(0);
    }
}

