/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FxUtils {
    public static void fadeBackground(JComponent comp, Color c) {
        FxUtils.fadeBackground(comp, c, 25);
    }

    public static void fadeBackground(JComponent comp, Color c, int delay) {
        FxUtils.fadeBackground(comp, c, comp.getBackground(), delay);
    }

    public static void fadeBackground(JComponent comp, Color colore_effetto, Color colore_start, int delay) {
        final FxUtilsFade fx = new FxUtilsFade();
        fx.colore_effetto = colore_effetto;
        fx.colore_start = colore_start;
        fx.comp = comp;
        Timer timerfx = new Timer(delay, new ActionListener(){
            int pass = 0;

            @Override
            public void actionPerformed(final ActionEvent e) {
                ++this.pass;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (fx.comp == null) {
                            ((Timer)e.getSource()).stop();
                            return;
                        }
                        fx.comp.setBackground(fx.getColor(pass));
                        if (pass >= 100) {
                            ((Timer)e.getSource()).stop();
                        }
                    }
                });
            }
        });
        timerfx.start();
    }

    public static void fadeForeground(JComponent comp, Color c) {
        FxUtils.fadeForeground(comp, c, 25);
    }

    public static void fadeForeground(JComponent comp, Color c, int delay) {
        FxUtils.fadeForeground(comp, c, comp.getForeground(), delay, null);
    }

    public static void fadeForeground(JComponent comp, Color colore_effetto, Color colore_start, int delay, final Runnable doWhenFinish) {
        final FxUtilsFade fx = new FxUtilsFade();
        fx.colore_effetto = colore_effetto;
        fx.colore_start = colore_start;
        fx.comp = comp;
        Timer timerfx = new Timer(delay, new ActionListener(){
            int pass = 0;

            @Override
            public void actionPerformed(final ActionEvent e) {
                ++this.pass;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (fx.comp == null) {
                            ((Timer)e.getSource()).stop();
                            if (doWhenFinish != null) {
                                doWhenFinish.run();
                            }
                            return;
                        }
                        fx.comp.setForeground(fx.getColor(pass));
                        if (pass >= 100) {
                            ((Timer)e.getSource()).stop();
                            if (doWhenFinish != null) {
                                doWhenFinish.run();
                            }
                        }
                    }
                });
            }
        });
        timerfx.start();
    }

    static class FxUtilsFade {
        Color colore_effetto = null;
        Color colore_start = null;
        JComponent comp;

        FxUtilsFade() {
        }

        Color getColor(int pass) {
            int r = (int)((double)Math.abs(this.colore_start.getRed() - this.colore_effetto.getRed()) / 100.0 * (double)pass);
            int g = (int)((double)Math.abs(this.colore_start.getGreen() - this.colore_effetto.getGreen()) / 100.0 * (double)pass);
            int b = (int)((double)Math.abs(this.colore_start.getBlue() - this.colore_effetto.getBlue()) / 100.0 * (double)pass);
            int r2 = 0;
            int g2 = 0;
            int b2 = 0;
            r2 = this.colore_effetto.getRed() > this.colore_start.getRed() ? this.colore_effetto.getRed() - r : this.colore_effetto.getRed() + r;
            g2 = this.colore_effetto.getGreen() > this.colore_start.getGreen() ? this.colore_effetto.getGreen() - g : this.colore_effetto.getGreen() + g;
            b2 = this.colore_effetto.getBlue() > this.colore_start.getBlue() ? this.colore_effetto.getBlue() - b : this.colore_effetto.getBlue() + b;
            Color color_new = new Color(r2, g2, b2);
            return color_new;
        }
    }
}

