/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.parser.JSONParser;
import it.tnx.commons.EasySSLProtocolSocketFactory;
import it.tnx.commons.FormatUtils;
import it.tnx.commons.JDialogProxyAuth;
import it.tnx.commons.cu;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.log4j.LogManager;

public class HttpUtils {
    private static boolean debug = false;
    private static HttpClient httpclient = null;
    public static int conta_credentials = 0;

    public static synchronized HttpClient getHttpClient() {
        if (httpclient != null) {
            return httpclient;
        }
        try {
            LogManager.getLogger((String)"it.tnx.commons").setLevel(org.apache.log4j.Level.ERROR);
            LogManager.getLogger((String)"it.tnx.commons.EasyX509TrustManager").setLevel(org.apache.log4j.Level.ERROR);
            LogManager.getLogger((String)"org.apache.commons.httpclient.contrib.ssl").setLevel(org.apache.log4j.Level.ERROR);
            LogManager.getLogger((String)"org.apache.commons.httpclient.contrib.ssl.EasyX509TrustManager").setLevel(org.apache.log4j.Level.ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int timeout = 30;
        try {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            httpclient = new HttpClient((HttpConnectionManager)connectionManager);
            String proxy_host = null;
            Integer proxy_port = null;
            if (System.getProperty("java.net.useSystemProxies", "false").equals("true")) {
                try {
                    List<Proxy> proxys = ProxySelector.getDefault().select(new URI("socket://www.invoicex.it"));
                    System.out.println("HttpUtils getHttpClient proxys socket = " + proxys);
                    proxys = ProxySelector.getDefault().select(new URI("http://www.invoicex.it"));
                    System.out.println("HttpUtils getHttpClient proxys http = " + proxys);
                    InetSocketAddress proxyaddr = (InetSocketAddress)proxys.get(0).address();
                    if (proxyaddr != null) {
                        proxy_host = proxyaddr.getHostName();
                        proxy_port = proxyaddr.getPort();
                    }
                }
                catch (URISyntaxException ex) {
                    ex.printStackTrace();
                }
            } else if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyHost").length() > 0) {
                proxy_host = System.getProperty("http.proxyHost");
                proxy_port = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            if (proxy_host != null) {
                httpclient.getHostConfiguration().setProxy(proxy_host, proxy_port.intValue());
                httpclient.getParams().setParameter("http.authentication.credential-provider", (Object)new CredentialsProvider(){

                    public Credentials getCredentials(AuthScheme as, String proxy_host, int proxy_port, boolean bln) throws CredentialsNotAvailableException {
                        if (++conta_credentials > 10) {
                            return null;
                        }
                        System.out.println("authscheme = " + as + " " + as.getRealm());
                        System.out.println("proxy_host = " + proxy_host);
                        if (System.getProperty("invoicex.proxy.user") != null) {
                            return new UsernamePasswordCredentials(System.getProperty("invoicex.proxy.user"), System.getProperty("invoicex.proxy.password"));
                        }
                        if (System.getProperty("commonstnx.proxy.user") != null) {
                            return new UsernamePasswordCredentials(System.getProperty("commonstnx.proxy.user"), System.getProperty("commonstnx.proxy.password"));
                        }
                        JDialogProxyAuth dialog = new JDialogProxyAuth(null, true);
                        dialog.setTitle("Autenticazione Proxy: " + proxy_host + ":" + proxy_port);
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                        System.setProperty("commonstnx.proxy.proxy", proxy_host + ":" + proxy_port);
                        System.setProperty("commonstnx.proxy.user", dialog.jTextField1.getText());
                        System.setProperty("commonstnx.proxy.password", String.valueOf(dialog.jPasswordField1.getPassword()));
                        return new UsernamePasswordCredentials(dialog.jTextField1.getText(), String.valueOf(dialog.jPasswordField1.getPassword()));
                    }
                });
            }
            httpclient.getParams().setParameter("http.socket.timeout", (Object)new Integer(timeout * 1000));
            httpclient.getParams().setParameter("http.connection.timeout", (Object)new Integer(timeout * 1000));
            httpclient.getParams().setParameter("http.connection-manager.timeout", (Object)new Long(timeout * 1000));
            httpclient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
            return httpclient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUrl(HttpServletRequest req) {
        String out = req.getRequestURI();
        if (req.getQueryString() != null && req.getQueryString().length() > 0) {
            out = out + "?" + req.getQueryString();
        }
        return out;
    }

    public static String getUrlToStringUTF8(String url) throws Exception {
        return HttpUtils.getUrlToStringUTF8(url, null);
    }

    public static String getUrlToStringUTF8(String url, Integer timeout) throws Exception {
        return HttpUtils.getUrlToStringUTF8(url, null, true);
    }

    public static String getUrlToStringUTF8(String url, Integer timeout, boolean nullIf404) throws Exception {
        String ret = null;
        if (debug) {
            System.out.println("httpClient getUrlToStringUTF8: url: " + url);
        }
        HttpClient httpclient = HttpUtils.getHttpClient();
        Integer old_timeout = null;
        System.out.println("PRE timeout = " + timeout + " in httpclient:" + httpclient.getParams().getParameter("http.socket.timeout"));
        if (timeout != null) {
            old_timeout = cu.i(httpclient.getParams().getParameter("http.socket.timeout")) / 1000;
            httpclient.getParams().setParameter("http.socket.timeout", (Object)new Integer(timeout * 1000));
            httpclient.getParams().setParameter("http.connection.timeout", (Object)new Integer(timeout * 1000));
            httpclient.getParams().setParameter("http.connection-manager.timeout", (Object)new Long(timeout * 1000));
        }
        System.out.println("POST timeout = " + timeout + " in httpclient:" + httpclient.getParams().getParameter("http.socket.timeout"));
        GetMethod httpGet = new GetMethod(url);
        try {
            httpclient.executeMethod((HttpMethod)httpGet);
            if (debug) {
                System.out.println("httpClient getUrlToStringUTF8: url: " + url + " status: " + httpGet.getStatusLine());
            }
            ret = httpGet.getStatusCode() == 404 && nullIf404 ? null : new String(httpGet.getResponseBody(), "UTF-8");
        }
        catch (Exception ex) {
            System.out.println("httpClient getUrlToStringUTF8: url: " + url + " ex: " + ex.toString());
            throw ex;
        }
        finally {
            httpGet.releaseConnection();
            if (timeout != null && old_timeout != null) {
                httpclient.getParams().setParameter("http.socket.timeout", (Object)new Integer(old_timeout * 1000));
                httpclient.getParams().setParameter("http.connection.timeout", (Object)new Integer(old_timeout * 1000));
                httpclient.getParams().setParameter("http.connection-manager.timeout", (Object)new Long(old_timeout * 1000));
            }
        }
        if (debug) {
            System.out.println("httpClient getUrlToStringUTF8: url: " + url + " ret: " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(String url) throws Exception {
        HttpClient httpclient = HttpUtils.getHttpClient();
        HeadMethod httpHead = new HeadMethod(url);
        long lastm = 0L;
        try {
            httpclient.executeMethod((HttpMethod)httpHead);
            if (debug) {
                System.out.println(httpHead.getStatusLine());
                for (Header h : httpHead.getResponseHeaders()) {
                    System.out.println("h = " + h);
                }
            }
            lastm = Date.parse(httpHead.getResponseHeader("Last-Modified").getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            httpHead.releaseConnection();
        }
        return lastm;
    }

    public static Date getLastModifiedDate(String url) throws Exception {
        return new Date(HttpUtils.getLastModified(url));
    }

    public static void saveFile(String url, String file) throws Exception {
        HttpUtils.saveFile(url, file, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String url, String file, int bufferSize) throws Exception {
        byte[] buff = new byte[0x100000];
        int readed = 0;
        int readed_tot = 0;
        HttpClient httpclient = HttpUtils.getHttpClient();
        GetMethod httpGet = new GetMethod(url);
        httpGet.addRequestHeader("Pragma", "no-cache");
        httpGet.addRequestHeader("Cache-Control", "no-cache");
        FileOutputStream fileout = null;
        try {
            httpclient.executeMethod((HttpMethod)httpGet);
            if (debug) {
                System.out.println("httpClient saveFile status: " + httpGet.getStatusLine());
                for (Header h : httpGet.getResponseHeaders()) {
                    System.out.println("httpClient saveFile h: " + h);
                }
            }
            if (httpGet.getStatusCode() != 200) {
                throw new Exception(url + " > " + httpGet.getStatusLine().toString());
            }
            long toread = Long.parseLong(httpGet.getResponseHeader("Content-Length").getValue());
            InputStream input = httpGet.getResponseBodyAsStream();
            fileout = new FileOutputStream(file);
            if (input != null) {
                while ((readed = input.read(buff)) > 0) {
                    fileout.write(buff, 0, readed);
                    System.out.println("httpClient saveFile " + FormatUtils.formatPerc((double)(readed_tot += readed) / 1024.0 / 1024.0) + "mb rimane:" + FormatUtils.formatPerc((double)(toread - (long)readed_tot) / 1024.0 / 1024.0) + "mb");
                }
                input.close();
            }
        }
        finally {
            httpGet.releaseConnection();
            if (fileout != null) {
                fileout.close();
            }
        }
    }

    public static byte[] saveFileToBuffer(String url) throws Exception {
        return HttpUtils.saveFileToBuffer(url, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] saveFileToBuffer(String url, int bufferSize) throws Exception {
        byte[] buff = new byte[0x100000];
        int readed = 0;
        int readed_tot = 0;
        HttpClient httpclient = HttpUtils.getHttpClient();
        GetMethod httpGet = new GetMethod(url);
        httpGet.addRequestHeader("Pragma", "no-cache");
        httpGet.addRequestHeader("Cache-Control", "no-cache");
        Object fileout = null;
        try {
            httpclient.executeMethod((HttpMethod)httpGet);
            if (debug) {
                System.out.println("httpClient saveFile status: " + httpGet.getStatusLine());
                for (Header h : httpGet.getResponseHeaders()) {
                    System.out.println("httpClient saveFile h: " + h);
                }
            }
            if (httpGet.getStatusCode() != 200) {
                throw new Exception(url + " > " + httpGet.getStatusLine().toString());
            }
            long toread = Long.parseLong(httpGet.getResponseHeader("Content-Length").getValue());
            InputStream input = httpGet.getResponseBodyAsStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (input != null) {
                while ((readed = input.read(buff)) > 0) {
                    out.write(buff, 0, readed);
                    System.out.println("httpClient saveFileToBuffer " + FormatUtils.formatPerc((double)(readed_tot += readed) / 1024.0 / 1024.0) + "mb rimane:" + FormatUtils.formatPerc((double)(toread - (long)readed_tot) / 1024.0 / 1024.0) + "mb");
                }
                input.close();
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public static void saveBigFile(String url, String file) throws Exception {
        HttpUtils.saveBigFile(url, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBigFile(String url, String file, SaveFileEventListener eventListener) throws Exception {
        byte[] buff = new byte[0x100000];
        int readed = 0;
        int readed_tot = 0;
        FileOutputStream fileout = null;
        HttpClient httpclient = HttpUtils.getHttpClient();
        GetMethod httpGet = new GetMethod(url);
        try {
            httpclient.executeMethod((HttpMethod)httpGet);
            if (debug) {
                try {
                    System.out.println("httpClient saveBigFile status: " + httpGet.getStatusLine());
                    for (Header h : httpGet.getResponseHeaders()) {
                        System.out.println("httpClient saveBigFile h: " + h);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            long toread = Long.parseLong(httpGet.getResponseHeader("Content-Length").getValue());
            InputStream input = httpGet.getResponseBodyAsStream();
            fileout = new FileOutputStream(file);
            if (input != null) {
                while ((readed = input.read(buff)) > 0) {
                    fileout.write(buff, 0, readed);
                    System.out.println("httpClient saveBigFile " + FormatUtils.formatPerc((double)(readed_tot += readed) / 1024.0 / 1024.0) + "mb rimane:" + FormatUtils.formatPerc((double)(toread - (long)readed_tot) / 1024.0 / 1024.0) + "mb");
                    if (eventListener == null) continue;
                    eventListener.event((float)readed_tot * 100.0f / (float)toread);
                }
                input.close();
            }
        }
        finally {
            httpGet.releaseConnection();
            if (fileout != null) {
                fileout.close();
            }
        }
    }

    public static void dumpRequest(HttpServletRequest hr) {
        String en;
        System.out.println("-- inizio dumpRequest hr:" + hr.getRequestURI() + " qs:" + hr.getQueryString());
        System.out.println("\tattributes");
        Enumeration e1 = hr.getAttributeNames();
        while (e1.hasMoreElements()) {
            en = (String)e1.nextElement();
            System.out.println("\t\t" + en + ":" + hr.getAttribute(en));
        }
        System.out.println("\tparams");
        e1 = hr.getParameterNames();
        while (e1.hasMoreElements()) {
            en = (String)e1.nextElement();
            System.out.println("\t\t" + en + ":" + hr.getParameter(en));
        }
        System.out.println("\theaders");
        e1 = hr.getHeaderNames();
        while (e1.hasMoreElements()) {
            en = (String)e1.nextElement();
            System.out.println("\t\t" + en + ":" + hr.getHeader(en));
        }
        System.out.println("-- fine dumpRequest hr:" + hr);
    }

    public static void main(String[] args) {
        try {
            String test = HttpUtils.getUrlToStringUTF8("http://www.panoramio.com/map/get_panoramas.php?order=popularity&set=public&from=0&to=16&minx=7.4591243&miny=43.6795062&maxx=7.8591243&maxy=44.079506200000004&size=square");
            FileOutputStream fout = new FileOutputStream("c:\\test.html");
            fout.write("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" /></head><body>".getBytes());
            JSONParser parser = new JSONParser(new StringReader(test));
            JSONObject obj = (JSONObject)parser.nextValue();
            JSONArray photos = (JSONArray)obj.get("photos");
            ArrayList photosl = new ArrayList();
            for (int i = 0; i < photos.size(); ++i) {
                String title = ((JSONString)((JSONObject)photos.get(i)).get("photo_title")).getValue();
                fout.write((title + "<br />").getBytes());
            }
            fout.write("</body></html>".getBytes());
            fout.close();
            System.err.println("test: " + test);
        }
        catch (Exception ex) {
            Logger.getLogger(HttpUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static interface SaveFileEventListener {
        public void event(float var1);
    }
}

