/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class MapCache<K, V> {
    private final Map<K, Holder<V>> mMap;
    private final long timeToLive;
    private final long cleanUpInterval;
    private final TimerTask cleanUpTask = new TimerTask(){

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            if (!MapCache.this.mMap.isEmpty()) {
                Iterator mIterator = MapCache.this.mMap.entrySet().iterator();
                while (mIterator.hasNext()) {
                    long expiry;
                    Map.Entry e = mIterator.next();
                    long myTimeToLive = MapCache.this.timeToLive;
                    if (((Holder)e.getValue()).timeToLive != null) {
                        myTimeToLive = ((Holder)e.getValue()).timeToLive;
                    }
                    if (now <= (expiry = MapCache.this.timeToLive + ((Holder)e.getValue()).lastAccessed)) continue;
                    System.out.println("MapCache remove: " + e.getKey());
                    mIterator.remove();
                }
            }
        }
    };

    public MapCache(long elementTimeToLiveMillis, long cleanUpIntervalMillis, int cacheSize) {
        this.mMap = new ConcurrentHashMap<K, Holder<V>>(cacheSize);
        this.timeToLive = elementTimeToLiveMillis;
        this.cleanUpInterval = cleanUpIntervalMillis;
        this.setupCleanUpProcess();
    }

    public void put(K key, V value) {
        this.mMap.put(key, new Holder<V>(value));
    }

    public void put(K key, V value, Long millis) {
        this.mMap.put(key, new Holder<V>(value, millis));
    }

    public V get(K key) {
        Holder<V> mHolder = this.mMap.get(key);
        if (mHolder != null) {
            return mHolder.getValue();
        }
        return null;
    }

    public boolean containsKey(K key) {
        return this.mMap.containsKey(key);
    }

    public V remove(K key) {
        Holder<V> mHolder = this.mMap.remove(key);
        if (mHolder != null) {
            return mHolder.getValue();
        }
        return null;
    }

    private void setupCleanUpProcess() {
        new Timer(true).scheduleAtFixedRate(this.cleanUpTask, this.cleanUpInterval, this.cleanUpInterval);
    }

    public Set<K> keySet() {
        return this.mMap.keySet();
    }

    private class Holder<T> {
        long lastAccessed = System.currentTimeMillis();
        T value;
        Long timeToLive;

        Holder(T value) {
            this.value = value;
            this.timeToLive = null;
        }

        Holder(T value, Long timeToLive) {
            this.value = value;
            this.timeToLive = timeToLive;
        }

        T getValue() {
            this.lastAccessed = System.currentTimeMillis();
            return this.value;
        }
    }
}

