/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class PlatformUtilsCommon {
    public static final int WINDOWS = 0;
    public static final int LINUX = 1;
    public static final int SOLARIS = 2;
    public static final int MAC = 3;
    public static final int OTHER = 4;
    public static final int NO_PLATFORM = -1;
    private static int iPlatform = -1;
    private static String sOsName;

    public static boolean isWindows() {
        return PlatformUtilsCommon.getPlatform() == 0;
    }

    public static boolean isLinux() {
        return PlatformUtilsCommon.getPlatform() == 1;
    }

    public static boolean isSolaris() {
        return PlatformUtilsCommon.getPlatform() == 2;
    }

    public static boolean isMac() {
        return PlatformUtilsCommon.getPlatform() == 3;
    }

    public static boolean isOther() {
        return PlatformUtilsCommon.getPlatform() == 4;
    }

    public static int getPlatform() {
        PlatformUtilsCommon.fetchPlatform();
        return iPlatform;
    }

    public static String getPlatformName() {
        PlatformUtilsCommon.fetchPlatform();
        return sOsName;
    }

    private static void fetchPlatform() {
        if (iPlatform == -1) {
            sOsName = System.getProperty("os.name").toLowerCase();
            if (sOsName.indexOf("windows") != -1) {
                iPlatform = 0;
            } else if (sOsName.indexOf("linux") != -1) {
                iPlatform = 1;
            } else if (sOsName.indexOf("solaris") != -1 || sOsName.indexOf("sunos") != -1) {
                iPlatform = 2;
            } else if (sOsName.indexOf("mac") != -1) {
                iPlatform = 3;
            }
        }
    }

    public static boolean is64bit() throws IOException {
        String cmd = null;
        if (PlatformUtilsCommon.isWindows()) {
            File f32 = new File("C:\\Program Files (x86)\\");
            File f64 = new File("C:\\Program Files\\");
            if (f32.exists() && f64.exists()) {
                return true;
            }
            cmd = "cmd /c echo %PROCESSOR_ARCHITECTURE%";
        } else if (PlatformUtilsCommon.isMac()) {
            cmd = "getconf LONG_BIT";
        } else if (PlatformUtilsCommon.isLinux()) {
            cmd = "uname -m";
        }
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream input = p.getInputStream();
        List list = IOUtils.readLines((InputStream)input);
        for (String s : list) {
            if (s.indexOf("64") < 0) continue;
            return true;
        }
        return false;
    }
}

