/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons;

import java.awt.Component;
import java.lang.reflect.Method;

public class ReflectUtils {
    public static Object runMethodWOutExc(String class_name, String method, Object[] args) {
        try {
            return ReflectUtils.runMethod(class_name, method, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object runMethod(String class_name, String method, Object[] args) throws Exception {
        Class<?>[] param_classes;
        Class<?> _class = Class.forName(class_name);
        Method[] methods = _class.getMethods();
        Method mtorun = null;
        for (Method m : methods) {
            if (!m.getName().equals(method)) continue;
            if (args == null) {
                if (m.getParameterTypes() != null && m.getParameterTypes().length != 0) continue;
                mtorun = m;
                break;
            }
            param_classes = m.getParameterTypes();
            if (param_classes.length != args.length) continue;
            boolean ok = true;
            for (int i = 0; i < args.length; ++i) {
                if (param_classes[i].isInstance(args[i]) || ReflectUtils.checkPrimitive(param_classes[i], args[i])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            mtorun = m;
            break;
        }
        if (mtorun == null) {
            for (Method m : methods) {
                if (!m.getName().equals(method) || args == null || (param_classes = m.getParameterTypes()).length != args.length) continue;
                mtorun = m;
                break;
            }
        }
        if (mtorun != null) {
            return mtorun.invoke(_class, args);
        }
        System.err.println("ReflectUtils.runMethod non trovato metodo " + method + " nella classe " + class_name);
        throw new IllegalArgumentException("ReflectUtils.runMethod non trovato metodo " + method + " nella classe " + class_name);
    }

    public static Object getProp(String prop, Component c) {
        try {
            return c.getClass().getField(prop).get(c);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getField(Object parent, String field) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        return parent.getClass().getDeclaredField(field).get(parent);
    }

    private static boolean checkPrimitive(Class pclass, Object arg) {
        if (pclass.isPrimitive()) {
            if (pclass.getName().equals("boolean")) {
                return Boolean.class.isInstance(arg);
            }
            if (pclass.getName().equals("byte")) {
                return Byte.class.isInstance(arg);
            }
            if (pclass.getName().equals("short")) {
                return Short.class.isInstance(arg);
            }
            if (pclass.getName().equals("int")) {
                return Integer.class.isInstance(arg);
            }
            if (pclass.getName().equals("long")) {
                return Long.class.isInstance(arg);
            }
            if (pclass.getName().equals("float")) {
                return Float.class.isInstance(arg);
            }
            if (pclass.getName().equals("double")) {
                return Double.class.isInstance(arg);
            }
        }
        return false;
    }
}

