/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.swing;

import it.tnx.commons.swing.CheckTreeCellRenderer;
import it.tnx.commons.swing.CheckTreeSelectionModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;

    public CheckTreeManager(JTree tree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = tree;
        this.selectionModel = new CheckTreeSelectionModel(tree.getModel());
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), this.selectionModel));
        tree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        boolean selected = this.selectionModel.isPathSelected(path, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
        }
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.tree.treeDidChange();
    }
}

