/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TridentConfig;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Linear;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.TimelineEase;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.swing.SwingRepaintTimeline;

public class CircularWait
extends JPanel {
    private static final int ROTATION_ANIMATOR_DURATION = 4000;
    private static final int SWEEP_ANIMATOR_DURATION = 1200;
    private static final int END_ANIMATOR_DURATION = 400;
    private Rectangle fBounds = new Rectangle(10, 10, 50, 50);
    private Timeline mRotationAnimator;
    private Timeline mSweepAppearingAnimator;
    private Timeline mSweepDisappearingAnimator;
    private boolean mModeAppearing;
    private boolean mRunning;
    private int mCurrentColor;
    private int mCurrentIndexColor = 0;
    private float mCurrentSweepAngle;
    private float mCurrentRotationAngleOffset = 0.0f;
    private float mCurrentRotationAngle = 0.0f;
    private float mCurrentEndRatio = 1.0f;
    private float mBorderWidth = 4.0f;
    private int[] mColors;
    private float mSweepSpeed = 1.0f;
    private float mRotationSpeed = 1.0f;
    private int mMinSweepAngle = 10;
    private int mMaxSweepAngle = 330;
    private boolean mFirstSweepAnimation;
    private Integer angleInterpolator = 0;
    private Integer sweepAppearingInterpolator = 0;
    private Integer sweepDisappearingInterpolator = 0;

    private void setCurrentRotationAngle(float angle) {
        this.mCurrentRotationAngle = angle;
    }

    public CircularWait() {
        TridentConfig.getInstance().addPropertyInterpolator((PropertyInterpolator)new PropertyInterpolator<Integer>(){

            public Class getBasePropertyClass() {
                return Integer.class;
            }

            public Integer interpolate(Integer from, Integer to, float timelinePosition) {
                return from;
            }
        });
        this.setupAnimations();
        new SwingRepaintTimeline((Component)this).playLoop(Timeline.RepeatBehavior.LOOP);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.fBounds = g.getClipBounds();
        float startAngle = this.mCurrentRotationAngle - this.mCurrentRotationAngleOffset;
        float sweepAngle = this.mCurrentSweepAngle;
        if (!this.mModeAppearing) {
            startAngle += 360.0f - sweepAngle;
        }
        startAngle %= 360.0f;
        if (this.mCurrentEndRatio < 1.0f) {
            float newSweepAngle = sweepAngle * this.mCurrentEndRatio;
            startAngle = (startAngle + (sweepAngle - newSweepAngle)) % 360.0f;
            sweepAngle = newSweepAngle;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setColor(new Color(67, 135, 239));
        g2.setStroke(new BasicStroke(6.0f, 1, 1));
        g2.drawArc(this.fBounds.width / 2 - 20, this.fBounds.height / 2 - 20, 40, 40, (int)startAngle, (int)sweepAngle);
    }

    public void setCurrentSweepAngle(float currentSweepAngle) {
        this.mCurrentSweepAngle = currentSweepAngle;
    }

    public float getCurrentSweepAngle() {
        return this.mCurrentSweepAngle;
    }

    private void setDisappearing() {
        this.mModeAppearing = false;
        this.mCurrentRotationAngleOffset += (float)(360 - this.mMaxSweepAngle);
    }

    private void setAppearing() {
        this.mModeAppearing = true;
        this.mCurrentRotationAngleOffset += (float)this.mMinSweepAngle;
    }

    private void setupAnimations() {
        this.mRotationAnimator = new Timeline((Object)this);
        this.mRotationAnimator.addPropertyToInterpolate("angleInterpolator", (Object)0, (Object)360);
        this.mRotationAnimator.setDuration((long)(4000.0f / this.mRotationSpeed));
        this.mRotationAnimator.setEase((TimelineEase)new Linear());
        this.mRotationAnimator.setDuration(1200L);
        this.mRotationAnimator.addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float angle = durationFraction * 360.0f;
                CircularWait.this.setCurrentRotationAngle(angle);
            }
        });
        this.mRotationAnimator.playLoop(Timeline.RepeatBehavior.LOOP);
        this.mSweepAppearingAnimator = new Timeline((Object)this);
        this.mSweepAppearingAnimator.addPropertyToInterpolate("sweepAppearingInterpolator", (Object)this.mMinSweepAngle, (Object)this.mMaxSweepAngle);
        this.mSweepAppearingAnimator.setDuration((long)(1200.0f / this.mSweepSpeed));
        this.mSweepAppearingAnimator.setEase((TimelineEase)new Sine());
        this.mSweepAppearingAnimator.addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                    CircularWait.this.mFirstSweepAnimation = false;
                    CircularWait.this.setDisappearing();
                    CircularWait.this.mSweepDisappearingAnimator.play();
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float animatedFraction = durationFraction;
                float angle = CircularWait.this.mFirstSweepAnimation ? animatedFraction * (float)CircularWait.this.mMaxSweepAngle : (float)CircularWait.this.mMinSweepAngle + animatedFraction * (float)(CircularWait.this.mMaxSweepAngle - CircularWait.this.mMinSweepAngle);
                CircularWait.this.setCurrentSweepAngle(angle);
            }
        });
        this.mModeAppearing = true;
        this.mSweepAppearingAnimator.play();
        this.mSweepDisappearingAnimator = new Timeline((Object)this);
        this.mSweepDisappearingAnimator.addPropertyToInterpolate("sweepDisappearingInterpolator", (Object)this.mMinSweepAngle, (Object)this.mMaxSweepAngle);
        this.mSweepDisappearingAnimator.setDuration((long)(1200.0f / this.mSweepSpeed));
        this.mSweepDisappearingAnimator.setEase((TimelineEase)new Sine());
        this.mSweepDisappearingAnimator.addCallback(new TimelineCallback(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                    CircularWait.this.setAppearing();
                    CircularWait.this.mSweepAppearingAnimator.play();
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                float animatedFraction = durationFraction;
                CircularWait.this.setCurrentSweepAngle((float)CircularWait.this.mMaxSweepAngle - animatedFraction * (float)(CircularWait.this.mMaxSweepAngle - CircularWait.this.mMinSweepAngle));
            }
        });
    }

    public Integer getAngleInterpolator() {
        return this.angleInterpolator;
    }

    public void setAngleInterpolator(Integer angleInterpolator) {
        this.angleInterpolator = angleInterpolator;
    }

    public Integer getSweepAppearingInterpolator() {
        return this.sweepAppearingInterpolator;
    }

    public void setSweepAppearingInterpolator(Integer sweepAppearingInterpolator) {
        this.sweepAppearingInterpolator = sweepAppearingInterpolator;
    }

    public Integer getSweepDisappearingInterpolator() {
        return this.sweepDisappearingInterpolator;
    }

    public void setSweepDisappearingInterpolator(Integer sweepDisappearingInterpolator) {
        this.sweepDisappearingInterpolator = sweepDisappearingInterpolator;
    }
}

