/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.DbUtils;
import it.tnx.commons.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingworker.SwingWorker;

public class CachedResultSetTableModel
extends AbstractTableModel {
    DefaultTableModel mod = null;
    Connection conn;
    private String sql;
    ResultSet r;
    ResultSetMetaData m;
    int offsetcol = 1;
    public Exception ex = null;
    public boolean debug = false;
    public String debug_campo = null;
    private JTable table = null;
    TreeMap<Integer, Object[]> cache = new TreeMap();
    int cachesize = 50;
    boolean loading = false;
    String[] col_names;
    String[] col_classes;
    int index = 0;
    int rows = 0;
    int cols = 0;
    List<String> pks = new ArrayList<String>();

    public CachedResultSetTableModel(String sql, Connection conn) {
        this(sql, conn, 1);
    }

    public CachedResultSetTableModel(String sql, Connection conn, int offsetcol) {
        this(sql, conn, offsetcol, null);
    }

    public CachedResultSetTableModel(String sql, Connection conn, JTable table) {
        this(sql, conn, 1, table);
    }

    public CachedResultSetTableModel(String sql, Connection conn, int offsetcol, JTable table) {
        this.sql = sql;
        this.conn = conn;
        this.offsetcol = offsetcol;
        try {
            String sql2 = StringUtils.replace((String)sql.toLowerCase(), (String)"select ", (String)"select SQL_CALC_FOUND_ROWS ");
            sql2 = sql2 + " limit " + this.cachesize * 2;
            ResultSet r = conn.createStatement().executeQuery(sql2);
            ResultSetMetaData m = r.getMetaData();
            this.cols = m.getColumnCount();
            this.col_names = new String[this.cols];
            this.col_classes = new String[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                this.col_names[i] = m.getColumnName(i + 1);
                this.col_classes[i] = m.getColumnClassName(i + 1);
            }
            ResultSet r2 = conn.createStatement().executeQuery("SELECT FOUND_ROWS()");
            if (r2.next()) {
                this.rows = r2.getInt(1);
            }
            DatabaseMetaData dm = conn.getMetaData();
            System.out.println("pks: " + m.getCatalogName(1) + "|" + m.getSchemaName(1) + "|" + m.getTableName(1));
            ResultSet rpks = dm.getPrimaryKeys(m.getCatalogName(1), m.getSchemaName(1), m.getTableName(1));
            while (rpks.next()) {
                String primaryKeyColumn = rpks.getString("COLUMN_NAME");
                System.out.println("Primary Key Column: " + primaryKeyColumn);
                this.pks.add(primaryKeyColumn);
            }
            this.prendi(r, 0);
            r2.getStatement().close();
            r2.close();
            r.getStatement().close();
            r.close();
        }
        catch (Exception ex) {
            this.ex = ex;
            ex.printStackTrace();
        }
        if (table != null) {
            this.table = table;
            final JPopupMenu pop = new JPopupMenu("Tabella");
            JMenuItem elimina = new JMenuItem("elimina");
            elimina.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("elimina:" + CachedResultSetTableModel.this.table.getSelectedRow());
                    CachedResultSetTableModel.this.deleteRow(CachedResultSetTableModel.this.table.getSelectedRow());
                }
            });
            pop.add(elimina);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(CachedResultSetTableModel.this.table, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(CachedResultSetTableModel.this.table, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    private synchronized void prendi(ResultSet r, int i) throws SQLException {
        int ls;
        int li = i - this.cachesize;
        if (li < 0) {
            li = 0;
        }
        if ((ls = i + this.cachesize) > this.rows) {
            ls = this.rows;
        }
        System.out.println("aggiungo: da " + li + " a " + ls);
        for (int conta = 0; conta < ls - li; ++conta) {
            r.next();
            Object[] row = new Object[this.cols];
            for (int icol = 0; icol < this.cols; ++icol) {
                row[icol] = r.getObject(icol + 1);
            }
            this.cache.put(li + conta, row);
        }
    }

    public void refresh() {
        try {
            try {
                DbUtils.tryExecQuery(this.conn, "select 1");
            }
            catch (Exception e) {
                this.setConn(this.getConnection());
            }
            String sql2 = StringUtils.replace((String)this.sql.toLowerCase(), (String)"select ", (String)"select SQL_CALC_FOUND_ROWS ");
            sql2 = sql2 + " limit " + this.cachesize * 2;
            ResultSet r = this.conn.createStatement().executeQuery(sql2);
            ResultSetMetaData m = r.getMetaData();
            this.cols = m.getColumnCount();
            this.col_names = new String[this.cols];
            this.col_classes = new String[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                this.col_names[i] = m.getColumnName(i + 1);
                this.col_classes[i] = m.getColumnClassName(i + 1);
            }
            ResultSet r2 = this.conn.createStatement().executeQuery("SELECT FOUND_ROWS()");
            if (r2.next()) {
                this.rows = r2.getInt(1);
            }
            this.cache.clear();
            r2.getStatement().close();
            r2.close();
            r.getStatement().close();
            r.close();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Connection getConnection() {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.cols;
    }

    @Override
    public Object getValueAt(final int rowIndex, int columnIndex) {
        if (rowIndex <= this.index - this.cachesize || rowIndex >= this.index + this.cachesize || this.cache == null || this.cache.size() == 0) {
            if (this.loading) {
                return null;
            }
            this.loading = true;
            SwingWorker w = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    String sql2 = CachedResultSetTableModel.this.sql + " limit " + ((rowIndex < CachedResultSetTableModel.this.cachesize ? CachedResultSetTableModel.this.cachesize : rowIndex) - CachedResultSetTableModel.this.cachesize) + ", " + CachedResultSetTableModel.this.cachesize * 2;
                    System.out.println("getValueAt: " + rowIndex + " index: " + CachedResultSetTableModel.this.index + " sql2 = " + sql2);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtils.mouse_wait();
                        }
                    });
                    try {
                        ResultSet r = CachedResultSetTableModel.this.conn.createStatement().executeQuery(sql2);
                        CachedResultSetTableModel.this.cache.clear();
                        CachedResultSetTableModel.this.prendi(r, rowIndex);
                        CachedResultSetTableModel.this.index = rowIndex;
                        System.out.println("nuovo index:" + CachedResultSetTableModel.this.index);
                        r.getStatement().close();
                        r.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtils.mouse_def();
                        }
                    });
                    return null;
                }

                @Override
                protected void done() {
                    int min = rowIndex - CachedResultSetTableModel.this.cachesize;
                    int max = rowIndex + CachedResultSetTableModel.this.cachesize;
                    CachedResultSetTableModel.this.fireTableRowsUpdated(min < 0 ? 0 : min, max > CachedResultSetTableModel.this.rows - 1 ? CachedResultSetTableModel.this.rows - 1 : max);
                    CachedResultSetTableModel.this.loading = false;
                }
            };
            w.execute();
            return null;
        }
        try {
            return this.cache.get(rowIndex)[columnIndex];
        }
        catch (Exception e0) {
            System.err.println(this.getClass() + " getValueAt " + e0.getMessage());
            System.out.println("get rowIndex:" + rowIndex + " index:" + this.index + " cond:" + rowIndex + " <= " + (this.index - this.cachesize) + " || " + rowIndex + " >= " + (this.index + this.cachesize));
            try {
                System.out.println("cache:" + this.cache);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                System.out.println("cache.get(rowIndex):" + this.cache.get(rowIndex));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                System.out.println("cache.get(rowIndex)[columnIndex]:" + this.cache.get(rowIndex)[columnIndex]);
            }
            catch (Exception e) {
                // empty catch block
            }
            return "?";
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        try {
            return Class.forName(this.col_classes[columnIndex]);
        }
        catch (ClassNotFoundException ex) {
            return Object.class;
        }
        catch (Exception ex) {
            return Object.class;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.col_names[column];
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        System.out.println("setValue:" + aValue + " : " + rowIndex + " " + columnIndex);
        if (rowIndex == this.rows) {
            try {
                this.r.moveToInsertRow();
                this.r.updateObject(columnIndex + 1, aValue);
                this.r.insertRow();
                ++this.rows;
                this.fireTableRowsInserted(this.rows, this.rows);
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtils.showErrorMessage(this.table, "Errore nel salvataggio\n" + e.getMessage());
            }
        } else {
            try {
                int i;
                String sql2 = StringUtils.substringBefore((String)this.sql.toLowerCase(), (String)" where");
                sql2 = StringUtils.substringBefore((String)sql2.toLowerCase(), (String)" order by");
                for (i = 0; i < this.col_names.length && !this.col_names[i].equalsIgnoreCase(this.pks.get(0)); ++i) {
                }
                sql2 = sql2 + " where " + this.pks.get(0) + " = '" + this.getValueAt(rowIndex, i) + "'";
                System.out.println("sql2:" + sql2);
                this.r = DbUtils.tryOpenResultSetEditable(this.conn, sql2);
                if (this.r.next()) {
                    this.r.updateObject(columnIndex + 1, aValue);
                    this.r.updateRow();
                    if (this.debug) {
                        SwingUtils.showFlashMessage2("setValue row:" + (rowIndex + 1) + " col:" + (columnIndex + 1) + " value:" + aValue + " (campo debug:" + this.r.getString(this.debug_campo) + ")", 10);
                    }
                    Object[] row = this.cache.get(rowIndex);
                    row[columnIndex] = aValue;
                    this.cache.put(rowIndex, row);
                } else if (this.debug) {
                    SwingUtils.showFlashMessage2("Non trovato il record !!!", 10);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.debug) {
                    SwingUtils.showFlashMessage2(e.getLocalizedMessage(), 10);
                }
                SwingUtils.showErrorMessage(this.table, "Errore nel salvataggio\n" + e.getMessage());
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void deleteRow(int rowindex) {
        try {
            this.r.absolute(rowindex + 1);
            this.r.deleteRow();
            --this.rows;
            this.fireTableRowsDeleted(rowindex + 1, rowindex + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }
}

