/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.cu;
import it.tnx.commons.table.CustomColumn;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class ListMapTableModel
extends AbstractTableModel {
    List<Map> list = null;
    List columns = null;
    Map editableColumns = null;

    public ListMapTableModel(List<Map> list, List columns) {
        this.list = list;
        this.columns = columns;
    }

    public List<Map> getList() {
        return this.list;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public String getColumnName(int column) {
        if (this.columns.get(column) instanceof CustomColumn) {
            return ((CustomColumn)this.columns.get(column)).getName();
        }
        return cu.s(this.columns.get(column));
    }

    @Override
    public int getColumnCount() {
        if (this.columns != null) {
            return this.columns.size();
        }
        if (this.list != null && this.list.size() > 0 && this.list.get(0) != null) {
            this.list.get(0).size();
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.editableColumns == null) {
            return true;
        }
        return this.editableColumns.containsKey(this.getColumnName(columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.list == null) {
            return null;
        }
        try {
            return this.list.get(rowIndex).get(this.columns.get(columnIndex));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            Object col = this.columns.get(columnIndex);
            String sCol = cu.s(col);
            if (col instanceof CustomColumn) {
                sCol = ((CustomColumn)col).getName();
            }
            this.list.get(rowIndex).put(sCol, aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addRow(Map row) {
        this.list.add(row);
        this.fireTableRowsInserted(this.list.size(), this.list.size());
    }

    public void removeRow(int row) {
        this.list.remove(row);
        this.fireTableRowsDeleted(row, row);
    }
}

