/*
 * Decompiled with CFR 0.152.
 */
package it.tnx.commons.table;

import it.tnx.commons.DbUtils;
import it.tnx.commons.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;

public class ResultSetTableModel
extends AbstractTableModel {
    DefaultTableModel mod = null;
    Connection conn;
    private String sql;
    ResultSet r;
    ResultSetMetaData m;
    int rowcount = 0;
    int offsetcol = 1;
    public Exception ex = null;
    public boolean debug = false;
    public String debug_campo = null;
    private JTable table = null;

    public ResultSetTableModel(String sql, Connection conn) {
        this(sql, conn, 1);
    }

    public ResultSetTableModel(String sql, Connection conn, int offsetcol) {
        this(sql, conn, offsetcol, null);
    }

    public ResultSetTableModel(String sql, Connection conn, JTable table) {
        this(sql, conn, 1, table);
    }

    public ResultSetTableModel(String sql, Connection conn, int offsetcol, JTable table) {
        this.sql = sql;
        this.conn = conn;
        this.offsetcol = offsetcol;
        try {
            this.r = DbUtils.tryOpenResultSetEditable(conn, sql);
            this.m = this.r.getMetaData();
            this.r.last();
            this.rowcount = this.r.getRow();
            this.r.beforeFirst();
        }
        catch (Exception ex) {
            this.ex = ex;
            ex.printStackTrace();
        }
        if (table != null) {
            this.table = table;
            final JPopupMenu pop = new JPopupMenu("Tabella");
            JMenuItem elimina = new JMenuItem("elimina");
            elimina.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("elimina:" + ResultSetTableModel.this.table.getSelectedRow());
                    ResultSetTableModel.this.deleteRow(ResultSetTableModel.this.table.getSelectedRow());
                }
            });
            pop.add(elimina);
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(ResultSetTableModel.this.table, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        pop.show(ResultSetTableModel.this.table, e.getX(), e.getY());
                    }
                }
            });
        }
    }

    public void refresh() {
        try {
            this.r = DbUtils.tryOpenResultSetEditable(this.conn, this.getSql());
            this.m = this.r.getMetaData();
            this.r.last();
            this.rowcount = this.r.getRow();
            this.r.beforeFirst();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            this.ex = ex;
            ex.printStackTrace();
        }
    }

    @Override
    public int getRowCount() {
        return this.rowcount;
    }

    @Override
    public int getColumnCount() {
        try {
            return this.m.getColumnCount();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            if (rowIndex < this.rowcount) {
                this.r.absolute(rowIndex + 1);
                return this.r.getObject(columnIndex + 1);
            }
            return null;
        }
        catch (SQLException ex) {
            System.err.println(this.getClass() + ":getValueAt(" + rowIndex + "," + columnIndex + "):" + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.m.getColumnName(column + this.offsetcol);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public Object getFromResultSet(String column, int rowIndex) {
        try {
            this.r.absolute(rowIndex + 1);
            return this.r.getObject(column);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        System.out.println("setValue:" + aValue + " : " + rowIndex + " " + columnIndex);
        if (rowIndex == this.rowcount) {
            try {
                this.r.moveToInsertRow();
                this.r.updateObject(columnIndex + 1, aValue);
                this.r.insertRow();
                ++this.rowcount;
                this.fireTableRowsInserted(this.rowcount, this.rowcount);
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtils.showErrorMessage(this.table, "Errore nel salvataggio\n" + e.getMessage());
            }
        } else {
            try {
                this.r.absolute(rowIndex + 1);
                this.r.updateObject(columnIndex + 1, aValue);
                this.r.updateRow();
                if (this.debug) {
                    SwingUtils.showFlashMessage2("setValue row:" + (rowIndex + 1) + " col:" + (columnIndex + 1) + " value:" + aValue + " (campo debug:" + this.r.getString(this.debug_campo) + ")", 10);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.debug) {
                    SwingUtils.showFlashMessage2(e.getLocalizedMessage(), 10);
                }
                SwingUtils.showErrorMessage(this.table, "Errore nel salvataggio\n" + e.getMessage());
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void deleteRow(int rowindex) {
        try {
            this.r.absolute(rowindex + 1);
            this.r.deleteRow();
            --this.rowcount;
            this.fireTableRowsDeleted(rowindex + 1, rowindex + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

