/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryConstants;
import org.apache.sanselan.common.RationalNumber;

public class BinaryInputStream
extends InputStream
implements BinaryConstants {
    protected boolean debug = false;
    private final InputStream is;
    private int byteOrder = 77;

    public final void setDebug(boolean b) {
        this.debug = b;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public BinaryInputStream(InputStream is, int byteOrder) {
        this.byteOrder = byteOrder;
        this.is = is;
    }

    public BinaryInputStream(InputStream is) {
        this.is = is;
    }

    protected void setByteOrder(int a, int b) throws ImageReadException, IOException {
        if (a != b) {
            throw new ImageReadException("Byte Order bytes don't match (" + a + ", " + b + ").");
        }
        if (a == 77) {
            this.byteOrder = a;
        } else if (a == 73) {
            this.byteOrder = a;
        } else {
            throw new ImageReadException("Unknown Byte Order hint: " + a);
        }
    }

    protected void setByteOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    protected int getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes) {
        return this.convertByteArrayToInt(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, byte[] bytes) {
        return this.convertByteArrayToShort(name, bytes, this.byteOrder);
    }

    public final int convertByteArrayToShort(String name, int start, byte[] bytes) {
        return this.convertByteArrayToShort(name, start, bytes, this.byteOrder);
    }

    public final int read4Bytes(String name, String exception) throws ImageReadException, IOException {
        return this.read4Bytes(name, exception, this.byteOrder);
    }

    public final int read3Bytes(String name, String exception) throws ImageReadException, IOException {
        return this.read3Bytes(name, exception, this.byteOrder);
    }

    public final int read2Bytes(String name, String exception) throws ImageReadException, IOException {
        return this.read2Bytes(name, exception, this.byteOrder);
    }

    protected final void readRandomBytes() throws ImageReadException, IOException {
        for (int counter = 0; counter < 100; ++counter) {
            this.readByte("" + counter, "Random Data");
        }
    }

    public final void debugNumber(String msg, int data) {
        this.debugNumber(msg, data, 1);
    }

    public final void debugNumber(String msg, int data, int bytes) {
        System.out.print(msg + ": " + data + " (");
        int byteData = data;
        for (int i = 0; i < bytes; ++i) {
            if (i > 0) {
                System.out.print(",");
            }
            int singleByte = 0xFF & byteData;
            System.out.print((char)singleByte + " [" + singleByte + "]");
            byteData >>= 8;
        }
        System.out.println(") [0x" + Integer.toHexString(data) + ", " + Integer.toBinaryString(data) + "]");
    }

    public final void readAndVerifyBytes(byte[] expected, String exception) throws ImageReadException, IOException {
        for (int i = 0; i < expected.length; ++i) {
            int data = this.is.read();
            byte b = (byte)(0xFF & data);
            if (data >= 0 && b == expected[i]) continue;
            System.out.println("i: " + i);
            this.debugByteArray("expected", expected);
            this.debugNumber("data[" + i + "]", b);
            throw new ImageReadException(exception);
        }
    }

    protected final void readAndVerifyBytes(String name, byte[] expected, String exception) throws ImageReadException, IOException {
        byte[] bytes = this.readByteArray(name, expected.length, exception);
        for (int i = 0; i < expected.length; ++i) {
            if (bytes[i] == expected[i]) continue;
            System.out.println("i: " + i);
            this.debugNumber("bytes[" + i + "]", bytes[i]);
            this.debugNumber("expected[" + i + "]", expected[i]);
            throw new ImageReadException(exception);
        }
    }

    public final void skipBytes(int length, String exception) throws IOException {
        long skipped;
        for (long total = 0L; (long)length != total; total += skipped) {
            skipped = this.is.skip((long)length - total);
            if (skipped >= 1L) continue;
            throw new IOException(exception + " (" + skipped + ")");
        }
    }

    protected final void scanForByte(byte value) throws IOException {
        int count = 0;
        int i = 0;
        while (count < 3) {
            int b = this.is.read();
            if (b < 0) {
                return;
            }
            if ((0xFF & b) == value) {
                System.out.println("\t" + i + ": match.");
                ++count;
            }
            ++i;
        }
    }

    public final byte readByte(String name, String exception) throws IOException {
        int result = this.is.read();
        if (result < 0) {
            System.out.println(name + ": " + result);
            throw new IOException(exception);
        }
        if (this.debug) {
            this.debugNumber(name, result);
        }
        return (byte)(0xFF & result);
    }

    protected final RationalNumber[] convertByteArrayToRationalArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 8;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        RationalNumber[] result = new RationalNumber[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToRational(name, bytes, start + i * 8, byteOrder);
        }
        return result;
    }

    protected final RationalNumber convertByteArrayToRational(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToRational(name, bytes, 0, byteOrder);
    }

    protected final RationalNumber convertByteArrayToRational(String name, byte[] bytes, int start, int byteOrder) {
        int numerator = this.convertByteArrayToInt(name, bytes, start + 0, 4, byteOrder);
        int divisor = this.convertByteArrayToInt(name, bytes, start + 4, 4, byteOrder);
        return new RationalNumber(numerator, divisor);
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToInt(name, bytes, 0, 4, byteOrder);
    }

    protected final int convertByteArrayToInt(String name, byte[] bytes, int start, int length, int byteOrder) {
        byte byte0 = bytes[start + 0];
        byte byte1 = bytes[start + 1];
        byte byte2 = bytes[start + 2];
        byte byte3 = 0;
        if (length == 4) {
            byte3 = bytes[start + 3];
        }
        int result = byteOrder == 77 ? ((0xFF & byte0) << 24) + ((0xFF & byte1) << 16) + ((0xFF & byte2) << 8) + ((0xFF & byte3) << 0) : ((0xFF & byte3) << 24) + ((0xFF & byte2) << 16) + ((0xFF & byte1) << 8) + ((0xFF & byte0) << 0);
        if (this.debug) {
            this.debugNumber(name, result, 4);
        }
        return result;
    }

    protected final int[] convertByteArrayToIntArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 4;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToInt(name, bytes, start + i * 4, 4, byteOrder);
        }
        return result;
    }

    protected final int convertByteArrayToShort(String name, byte[] bytes, int byteOrder) {
        return this.convertByteArrayToShort(name, 0, bytes, byteOrder);
    }

    protected final int convertByteArrayToShort(String name, int start, byte[] bytes, int byteOrder) {
        byte byte0 = bytes[start + 0];
        byte byte1 = bytes[start + 1];
        int result = byteOrder == 77 ? ((0xFF & byte0) << 8) + ((0xFF & byte1) << 0) : ((0xFF & byte1) << 8) + ((0xFF & byte0) << 0);
        if (this.debug) {
            this.debugNumber(name, result, 2);
        }
        return result;
    }

    protected final int[] convertByteArrayToShortArray(String name, byte[] bytes, int start, int length, int byteOrder) {
        int expectedLength = start + length * 2;
        if (bytes.length < expectedLength) {
            System.out.println(name + ": expected length: " + expectedLength + ", actual length: " + bytes.length);
            return null;
        }
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.convertByteArrayToShort(name, start + i * 2, bytes, byteOrder);
        }
        return result;
    }

    public final byte[] readByteArray(String name, int length, String exception) throws ImageReadException, IOException {
        int count;
        byte[] result = new byte[length];
        for (int read = 0; read < length; read += count) {
            count = this.is.read(result, read, length - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        if (this.debug) {
            for (int i = 0; i < length && i < 150; ++i) {
                this.debugNumber(name + " (" + i + ")", 0xFF & result[i]);
            }
        }
        return result;
    }

    protected final void debugByteArray(String name, byte[] bytes) {
        System.out.println(name + ": " + bytes.length);
        for (int i = 0; i < bytes.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", bytes[i]);
        }
    }

    protected final void debugNumberArray(String name, int[] numbers, int length) {
        System.out.println(name + ": " + numbers.length);
        for (int i = 0; i < numbers.length && i < 50; ++i) {
            this.debugNumber(name + " (" + i + ")", numbers[i], length);
        }
    }

    public final byte[] readBytearray(String name, byte[] bytes, int start, int count) {
        if (bytes.length < start + count) {
            return null;
        }
        byte[] result = new byte[count];
        System.arraycopy(bytes, start, result, 0, count);
        if (this.debug) {
            this.debugByteArray(name, result);
        }
        return result;
    }

    protected final byte[] getBytearrayTail(String name, byte[] bytes, int count) {
        return this.readBytearray(name, bytes, count, bytes.length - count);
    }

    protected final byte[] getBytearrayHead(String name, byte[] bytes, int count) {
        return this.readBytearray(name, bytes, 0, bytes.length - count);
    }

    public final boolean compareByteArrays(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < bStart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[bStart + i]) continue;
            this.debugNumber("a[" + (aStart + i) + "]", a[aStart + i]);
            this.debugNumber("b[" + (bStart + i) + "]", b[bStart + i]);
            return false;
        }
        return true;
    }

    protected final int read4Bytes(String name, String exception, int byteOrder) throws ImageReadException, IOException {
        int count;
        int size = 4;
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += count) {
            count = this.is.read(bytes, read, size - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return this.convertByteArrayToInt(name, bytes, byteOrder);
    }

    protected final int read3Bytes(String name, String exception, int byteOrder) throws ImageReadException, IOException {
        int count;
        int size = 3;
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += count) {
            count = this.is.read(bytes, read, size - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return this.convertByteArrayToInt(name, bytes, 0, 3, byteOrder);
    }

    protected final int read2Bytes(String name, String exception, int byteOrder) throws ImageReadException, IOException {
        int count;
        int size = 2;
        byte[] bytes = new byte[size];
        for (int read = 0; read < size; read += count) {
            count = this.is.read(bytes, read, size - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return this.convertByteArrayToShort(name, bytes, byteOrder);
    }

    protected final void printCharQuad(String msg, int i) {
        System.out.println(msg + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & i >> 0) + "'");
    }

    protected final void printByteBits(String msg, byte i) {
        System.out.println(msg + ": '" + Integer.toBinaryString(0xFF & i));
    }

    protected static final int CharsToQuad(char c1, char c2, char c3, char c4) {
        return (0xFF & c1) << 24 | (0xFF & c2) << 16 | (0xFF & c3) << 8 | (0xFF & c4) << 0;
    }

    public final int findNull(byte[] src) {
        return this.findNull(src, 0);
    }

    public final int findNull(byte[] src, int start) {
        for (int i = start; i < src.length; ++i) {
            if (src[i] != 0) continue;
            return i;
        }
        return -1;
    }

    protected final byte[] getRAFBytes(RandomAccessFile raf, long pos, int length, String exception) throws IOException {
        int count;
        byte[] result = new byte[length];
        if (this.debug) {
            System.out.println("getRAFBytes pos: " + pos);
            System.out.println("getRAFBytes length: " + length);
        }
        raf.seek(pos);
        for (int read = 0; read < length; read += count) {
            count = raf.read(result, read, length - read);
            if (count >= 1) continue;
            throw new IOException(exception);
        }
        return result;
    }

    protected void skipBytes(int length) throws IOException {
        this.skipBytes(length, "Couldn't skip bytes");
    }
}

