/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;
import org.apache.sanselan.formats.bmp.ImageContents;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParser;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserBitFields;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserRgb;
import org.apache.sanselan.formats.bmp.pixelparsers.PixelParserRle;
import org.apache.sanselan.formats.bmp.writers.BMPWriter;
import org.apache.sanselan.formats.bmp.writers.BMPWriterPalette;
import org.apache.sanselan.formats.bmp.writers.BMPWriterRGB;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.palette.SimplePalette;
import org.apache.sanselan.util.Debug;

public class BmpImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".bmp";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".bmp"};
    private static final byte[] BMP_HEADER_SIGNATURE = new byte[]{66, 77};
    private static final int BI_RGB = 0;
    private static final int BI_RLE4 = 2;
    private static final int BI_RLE8 = 1;
    private static final int BI_BITFIELDS = 3;
    private static final int BITMAP_FILE_HEADER_SIZE = 14;
    private static final int BITMAP_INFO_HEADER_SIZE = 40;

    public BmpImageParser() {
        super.setByteOrder(73);
    }

    @Override
    public String getName() {
        return "Bmp-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_BMP};
    }

    private BmpHeaderInfo readBmpHeaderInfo(InputStream is, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        byte Identifier1 = this.readByte("Identifier1", is, "Not a Valid BMP File");
        byte Identifier2 = this.readByte("Identifier2", is, "Not a Valid BMP File");
        if (formatCompliance != null) {
            formatCompliance.compare_bytes("Signature", BMP_HEADER_SIGNATURE, new byte[]{Identifier1, Identifier2});
        }
        int FileSize = this.read4Bytes("File Size", is, "Not a Valid BMP File");
        int Reserved = this.read4Bytes("Reserved", is, "Not a Valid BMP File");
        int BitmapDataOffset = this.read4Bytes("Bitmap Data Offset", is, "Not a Valid BMP File");
        int BitmapHeaderSize = this.read4Bytes("Bitmap Header Size", is, "Not a Valid BMP File");
        int Width = this.read4Bytes("Width", is, "Not a Valid BMP File");
        int Height = this.read4Bytes("Height", is, "Not a Valid BMP File");
        int Planes = this.read2Bytes("Planes", is, "Not a Valid BMP File");
        int BitsPerPixel = this.read2Bytes("Bits Per Pixel", is, "Not a Valid BMP File");
        int Compression2 = this.read4Bytes("Compression", is, "Not a Valid BMP File");
        int BitmapDataSize = this.read4Bytes("Bitmap Data Size", is, "Not a Valid BMP File");
        int HResolution = this.read4Bytes("HResolution", is, "Not a Valid BMP File");
        int VResolution = this.read4Bytes("VResolution", is, "Not a Valid BMP File");
        int ColorsUsed = this.read4Bytes("ColorsUsed", is, "Not a Valid BMP File");
        int ColorsImportant = this.read4Bytes("ColorsImportant", is, "Not a Valid BMP File");
        BmpHeaderInfo result = new BmpHeaderInfo(Identifier1, Identifier2, FileSize, Reserved, BitmapDataOffset, BitmapHeaderSize, Width, Height, Planes, BitsPerPixel, Compression2, BitmapDataSize, HResolution, VResolution, ColorsUsed, ColorsImportant);
        return result;
    }

    private byte[] getRLEBytes(InputStream is, int RLESamplesPerByte) throws ImageReadException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean done = false;
        block5: while (!done) {
            int a = 0xFF & this.readByte("RLE a", is, "BMP: Bad RLE");
            baos.write(a);
            int b = 0xFF & this.readByte("RLE b", is, "BMP: Bad RLE");
            baos.write(b);
            if (a != 0) continue;
            switch (b) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    done = true;
                    continue block5;
                }
                case 2: {
                    int c = 0xFF & this.readByte("RLE c", is, "BMP: Bad RLE");
                    baos.write(c);
                    int d = 0xFF & this.readByte("RLE d", is, "BMP: Bad RLE");
                    baos.write(d);
                    continue block5;
                }
            }
            int size = b / RLESamplesPerByte;
            if (b % RLESamplesPerByte > 0) {
                ++size;
            }
            if (size % 2 != 0) {
                ++size;
            }
            byte[] bytes = this.readByteArray("bytes", size, is, "RLE: Absolute Mode");
            baos.write(bytes);
        }
        return baos.toByteArray();
    }

    private ImageContents readImageContents(InputStream is, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        PixelParser pixelParser;
        int extra_bytes;
        int paletteLength;
        BmpHeaderInfo bhi = this.readBmpHeaderInfo(is, formatCompliance);
        int colorTableSize = bhi.colorsUsed;
        if (colorTableSize == 0) {
            colorTableSize = 1 << bhi.bitsPerPixel;
        }
        if (this.debug) {
            this.debugNumber("ColorsUsed", bhi.colorsUsed, 4);
            this.debugNumber("BitsPerPixel", bhi.bitsPerPixel, 4);
            this.debugNumber("ColorTableSize", colorTableSize, 4);
            this.debugNumber("Compression", bhi.compression, 4);
        }
        int rleSamplesPerByte = 0;
        boolean rle = false;
        switch (bhi.compression) {
            case 0: {
                if (this.debug) {
                    System.out.println("Compression: BI_RGB");
                }
                if (bhi.bitsPerPixel <= 8) {
                    paletteLength = 4 * colorTableSize;
                    break;
                }
                paletteLength = 0;
                break;
            }
            case 2: {
                if (this.debug) {
                    System.out.println("Compression: BI_RLE4");
                }
                paletteLength = 4 * colorTableSize;
                rleSamplesPerByte = 2;
                rle = true;
                break;
            }
            case 1: {
                if (this.debug) {
                    System.out.println("Compression: BI_RLE8");
                }
                paletteLength = 4 * colorTableSize;
                rleSamplesPerByte = 1;
                rle = true;
                break;
            }
            case 3: {
                if (this.debug) {
                    System.out.println("Compression: BI_BITFIELDS");
                }
                paletteLength = 12;
                break;
            }
            default: {
                throw new ImageReadException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        byte[] colorTable = null;
        if (paletteLength > 0) {
            colorTable = this.readByteArray("ColorTable", paletteLength, is, "Not a Valid BMP File");
        }
        if (this.debug) {
            this.debugNumber("PaletteLength", paletteLength, 4);
            System.out.println("ColorTable: " + (colorTable == null ? "null" : "" + colorTable.length));
        }
        int pixelCount = bhi.width * bhi.height;
        int imageLineLength = (bhi.bitsPerPixel * bhi.width + 7) / 8;
        if (this.debug) {
            this.debugNumber("bhi.Width", bhi.width, 4);
            this.debugNumber("bhi.Height", bhi.height, 4);
            this.debugNumber("ImageLineLength", imageLineLength, 4);
            this.debugNumber("PixelCount", pixelCount, 4);
        }
        while (imageLineLength % 4 != 0) {
            ++imageLineLength;
        }
        int header_size = 54;
        int expected_data_offset = 54 + paletteLength;
        if (this.debug) {
            this.debugNumber("bhi.BitmapDataOffset", bhi.bitmapDataOffset, 4);
            this.debugNumber("expected_data_offset", expected_data_offset, 4);
        }
        if ((extra_bytes = bhi.bitmapDataOffset - expected_data_offset) < 0) {
            throw new ImageReadException("BMP: Strange BitmapDataOffset: " + bhi.bitmapDataOffset + " (expected: " + expected_data_offset + ", PaletteLength: " + paletteLength + ", header_size: " + 54 + ")");
        }
        if (extra_bytes > 0) {
            this.readByteArray("BitmapDataOffset", extra_bytes, is, "Not a Valid BMP File");
        }
        int ImageDataSize = bhi.height * imageLineLength;
        if (this.debug) {
            this.debugNumber("ImageDataSize", ImageDataSize, 4);
        }
        byte[] ImageData = rle ? this.getRLEBytes(is, rleSamplesPerByte) : this.readByteArray("ImageData", ImageDataSize, is, "Not a Valid BMP File");
        if (this.debug) {
            this.debugNumber("ImageData.length", ImageData.length, 4);
        }
        switch (bhi.compression) {
            case 1: 
            case 2: {
                pixelParser = new PixelParserRle(bhi, colorTable, ImageData);
                break;
            }
            case 0: {
                pixelParser = new PixelParserRgb(bhi, colorTable, ImageData);
                break;
            }
            case 3: {
                pixelParser = new PixelParserBitFields(bhi, colorTable, ImageData);
                break;
            }
            default: {
                throw new ImageReadException("BMP: Unknown Compression: " + bhi.compression);
            }
        }
        return new ImageContents(bhi, colorTable, ImageData, pixelParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BmpHeaderInfo readBmpHeaderInfo(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            BmpHeaderInfo bmpHeaderInfo = this.readBmpHeaderInfo(is, null);
            return bmpHeaderInfo;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        BmpHeaderInfo bhi = this.readBmpHeaderInfo(byteSource);
        if (bhi == null) {
            throw new ImageReadException("BMP: couldn't read header");
        }
        return new Dimension(bhi.width, bhi.height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private String getBmpTypeDescription(int Identifier1, int Identifier2) {
        if (Identifier1 == 66 && Identifier2 == 77) {
            return "Windows 3.1x, 95, NT,";
        }
        if (Identifier1 == 66 && Identifier2 == 65) {
            return "OS/2 Bitmap Array";
        }
        if (Identifier1 == 67 && Identifier2 == 73) {
            return "OS/2 Color Icon";
        }
        if (Identifier1 == 67 && Identifier2 == 80) {
            return "OS/2 Color Pointer";
        }
        if (Identifier1 == 73 && Identifier2 == 67) {
            return "OS/2 Icon";
        }
        if (Identifier1 == 80 && Identifier2 == 84) {
            return "OS/2 Pointer";
        }
        return "Unknown";
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ImageContents ic = this.readImageContents(byteSource.getInputStream(), FormatCompliance.getDefault());
        if (ic == null) {
            throw new ImageReadException("Couldn't read BMP Data");
        }
        BmpHeaderInfo bhi = ic.bhi;
        byte[] colorTable = ic.colorTable;
        if (bhi == null) {
            throw new ImageReadException("BMP: couldn't read header");
        }
        int Height = bhi.height;
        int Width = bhi.width;
        ArrayList Comments = new ArrayList();
        int bitsPerPixel = bhi.bitsPerPixel;
        ImageFormat format = ImageFormat.IMAGE_FORMAT_BMP;
        String fName = "BMP Windows Bitmap";
        String mimeType = "image/x-ms-bmp";
        int numberOfImages = -1;
        boolean isProgressive = false;
        int physicalWidthDpi = (int)((double)bhi.hResolution * 1000.0 / 2.54);
        float physicalWidthInch = (float)((double)Width / (double)physicalWidthDpi);
        int physicalHeightDpi = (int)((double)bhi.vResolution * 1000.0 / 2.54);
        float physicalHeightInch = (float)((double)Height / (double)physicalHeightDpi);
        String formatDetails = "Bmp (" + (char)bhi.identifier1 + (char)bhi.identifier2 + ": " + this.getBmpTypeDescription(bhi.identifier1, bhi.identifier2) + ")";
        boolean isTransparent = false;
        boolean usesPalette = colorTable != null;
        int ColorType = 2;
        String compressionAlgorithm = "RLE: Run-Length Encoding";
        ImageInfo result = new ImageInfo(formatDetails, bitsPerPixel, Comments, format, fName, Height, mimeType, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, Width, isProgressive, isTransparent, usesPalette, ColorType, compressionAlgorithm);
        return result;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("bmp.dumpImageFile");
        ImageInfo imageData = this.getImageInfo(byteSource, null);
        if (imageData == null) {
            return false;
        }
        imageData.toString(pw, "");
        pw.println("");
        return true;
    }

    @Override
    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        FormatCompliance result = new FormatCompliance(byteSource.getDescription());
        this.readImageContents(byteSource.getInputStream(), result);
        return result;
    }

    @Override
    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ImageContents ic = this.readImageContents(byteSource.getInputStream(), FormatCompliance.getDefault());
        if (ic == null) {
            throw new ImageReadException("Couldn't read BMP Data");
        }
        BmpHeaderInfo bhi = ic.bhi;
        int width = bhi.width;
        int height = bhi.height;
        boolean hasAlpha = false;
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        if (this.debug) {
            System.out.println("width: " + width);
            System.out.println("height: " + height);
            System.out.println("width*height: " + width * height);
            System.out.println("width*height*4: " + width * height * 4);
        }
        PixelParser pixelParser = ic.pixelParser;
        pixelParser.processImage(result);
        return result;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        if ((params = new HashMap(params)).containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        SimplePalette palette = new PaletteFactory().makePaletteSimple(src, 256);
        BMPWriter writer = null;
        writer = palette == null ? new BMPWriterRGB() : new BMPWriterPalette(palette);
        byte[] imagedata = writer.getImageData(src);
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        os.write(66);
        os.write(77);
        int filesize = 54 + 4 * writer.getPaletteSize() + imagedata.length;
        bos.write4Bytes(filesize);
        bos.write4Bytes(0);
        bos.write4Bytes(54 + 4 * writer.getPaletteSize());
        int width = src.getWidth();
        int height = src.getHeight();
        bos.write4Bytes(40);
        bos.write4Bytes(width);
        bos.write4Bytes(height);
        bos.write2Bytes(1);
        bos.write2Bytes(writer.getBitsPerPixel());
        bos.write4Bytes(0);
        bos.write4Bytes(imagedata.length);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        writer.writePalette(bos);
        bos.writeByteArray(imagedata);
    }
}

