/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.util.Debug;

public class JpegUtils
extends BinaryFileParser
implements JpegConstants {
    public JpegUtils() {
        this.setByteOrder(77);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseJFIF(ByteSource byteSource, Visitor visitor) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            this.readAndVerifyBytes(is, SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            int byteOrder = this.getByteOrder();
            int markerCount = 0;
            while (true) {
                byte[] segmentData;
                byte[] markerBytes;
                int marker;
                if ((marker = this.convertByteArrayToShort("marker", markerBytes = this.readByteArray("markerBytes", 2, is, "markerBytes"), byteOrder)) == 65497 || marker == 65498) {
                    if (!visitor.beginSOS()) {
                        return;
                    }
                    byte[] imageData = this.getStreamBytes(is);
                    visitor.visitSOS(marker, markerBytes, imageData);
                    break;
                }
                byte[] markerLengthBytes = this.readByteArray("markerLengthBytes", 2, is, "markerLengthBytes");
                int markerLength = this.convertByteArrayToShort("markerLength", markerLengthBytes, byteOrder);
                if (!visitor.visitSegment(marker, markerBytes, markerLength, markerLengthBytes, segmentData = this.readByteArray("Segment Data", markerLength - 2, is, "Invalid Segment: insufficient data"))) {
                    return;
                }
                ++markerCount;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public static String getMarkerName(int marker) {
        switch (marker) {
            case 65498: {
                return "SOS_Marker";
            }
            case 65505: {
                return "JPEG_APP1_Marker";
            }
            case 65506: {
                return "JPEG_APP2_Marker";
            }
            case 65517: {
                return "JPEG_APP13_Marker";
            }
            case 65518: {
                return "JPEG_APP14_Marker";
            }
            case 65519: {
                return "JPEG_APP15_Marker";
            }
            case 65504: {
                return "JFIFMarker";
            }
            case 65472: {
                return "SOF0Marker";
            }
            case 65473: {
                return "SOF1Marker";
            }
            case 65474: {
                return "SOF2Marker";
            }
            case 65475: {
                return "SOF3Marker";
            }
            case 65476: {
                return "SOF4Marker";
            }
            case 65477: {
                return "SOF5Marker";
            }
            case 65478: {
                return "SOF6Marker";
            }
            case 65479: {
                return "SOF7Marker";
            }
            case 65480: {
                return "SOF8Marker";
            }
            case 65481: {
                return "SOF9Marker";
            }
            case 65482: {
                return "SOF10Marker";
            }
            case 65483: {
                return "SOF11Marker";
            }
            case 65484: {
                return "SOF12Marker";
            }
            case 65485: {
                return "SOF13Marker";
            }
            case 65486: {
                return "SOF14Marker";
            }
            case 65487: {
                return "SOF15Marker";
            }
        }
        return "Unknown";
    }

    public void dumpJFIF(ByteSource byteSource) throws ImageReadException, IOException, ImageWriteException {
        Visitor visitor = new Visitor(){

            @Override
            public boolean beginSOS() {
                return true;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                Debug.debug("SOS marker.  " + imageData.length + " bytes of image data.");
                Debug.debug("");
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) {
                Debug.debug("Segment marker: " + Integer.toHexString(marker) + " (" + JpegUtils.getMarkerName(marker) + "), " + segmentData.length + " bytes of segment data.");
                return true;
            }
        };
        this.traverseJFIF(byteSource, visitor);
    }

    public static interface Visitor {
        public boolean beginSOS();

        public void visitSOS(int var1, byte[] var2, byte[] var3);

        public boolean visitSegment(int var1, byte[] var2, int var3, byte[] var4, byte[] var5) throws ImageReadException, IOException;
    }
}

