/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.segments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.jpeg.IptcElement;
import org.apache.sanselan.formats.jpeg.IptcType;
import org.apache.sanselan.formats.jpeg.JpegImageParser;
import org.apache.sanselan.formats.jpeg.segments.APPNSegment;

public class App13Segment
extends APPNSegment {
    protected final JpegImageParser parser;
    public final ArrayList elements = new ArrayList();

    public App13Segment(JpegImageParser parser, int marker, byte[] segmentData) throws ImageReadException, IOException {
        this(parser, marker, segmentData.length, new ByteArrayInputStream(segmentData));
    }

    public App13Segment(JpegImageParser parser, int marker, int marker_length, InputStream is) throws ImageReadException, IOException {
        super(marker, marker_length, is);
        this.parser = parser;
        boolean verbose = false;
        if (!this.compareByteArrays(this.bytes, 0, JpegImageParser.PhotoshopIdentificationString, 0, JpegImageParser.PhotoshopIdentificationString.length)) {
            throw new ImageReadException("Invalid App13 Segment");
        }
        int index = JpegImageParser.PhotoshopIdentificationString.length;
        while (index < this.bytes.length) {
            if (!this.compareByteArrays(this.bytes, index, JpegImageParser.CONST_8BIM, 0, JpegImageParser.CONST_8BIM.length)) {
                throw new ImageReadException("Invalid .CONST_8BIM Segment");
            }
            int segmentType = this.convertByteArrayToShort("SegmentType", index += JpegImageParser.CONST_8BIM.length, this.bytes);
            if (verbose) {
                this.debugNumber("segmentType", segmentType, 2);
            }
            index += 2;
            int segmentSize = this.convertByteArrayToShort("SegmentSize", index += 4, this.bytes);
            if (verbose) {
                this.debugNumber("segmentSize", segmentSize, 2);
            }
            int index2 = index += 2;
            index += segmentSize;
            while (index2 + 1 < index) {
                int iptcPrefix = this.convertByteArrayToShort("IPTCPrefix", index2, this.bytes);
                if (verbose) {
                    this.debugNumber("IPTCPrefix", iptcPrefix, 2);
                }
                index2 += 2;
                if (iptcPrefix != 7170) break;
                byte iptcSegmentType = this.bytes[index2];
                int iptcSegmentSize = this.convertByteArrayToShort("IPTCSegmentSize", ++index2, this.bytes);
                byte[] iptcData = this.readBytearray("iptc_data", this.bytes, index2 += 2, iptcSegmentSize);
                index2 += iptcSegmentSize;
                String value = new String(iptcData);
                IptcType iptcType = IptcType.getIptcType(iptcSegmentType);
                IptcElement element = new IptcElement(iptcType, value);
                this.elements.add(element);
            }
            if (segmentSize % 2 == 0) continue;
            ++index;
        }
    }
}

