/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileFunctions;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;

public abstract class FieldType
extends BinaryFileFunctions
implements TiffConstants {
    public final int type;
    public final int length;
    public final String name;

    public FieldType(int type, int length, String name) {
        this.type = type;
        this.length = length;
        this.name = name;
    }

    public boolean isLocalValue(TiffField entry) {
        return this.length > 0 && this.length * entry.length <= 4;
    }

    public int getBytesLength(TiffField entry) throws ImageReadException {
        if (this.length < 1) {
            throw new ImageReadException("Unknown field type");
        }
        return this.length * entry.length;
    }

    public static final byte[] getStubLocalValue() {
        return new byte[4];
    }

    public final byte[] getStubValue(int count) {
        return new byte[count * this.length];
    }

    public String getDisplayValue(TiffField entry) throws ImageReadException {
        Object o = this.getSimpleValue(entry);
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }

    public final byte[] getRawBytes(TiffField entry) {
        if (this.isLocalValue(entry)) {
            return this.readBytearray(this.name, entry.valueOffsetBytes, 0, this.length * entry.length);
        }
        return entry.oversizeValue;
    }

    public abstract Object getSimpleValue(TiffField var1) throws ImageReadException;

    public String toString() {
        return "[" + this.getClass().getName() + ". type: " + this.type + ", name: " + this.name + ", length: " + this.length + "]";
    }

    public abstract byte[] writeData(Object var1, int var2) throws ImageWriteException;
}

