/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.sampleUsage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.RationalNumber;
import org.apache.sanselan.formats.jpeg.JpegImageMetadata;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;

public class MetadataExample {
    public static void metadataExample(File file) throws ImageReadException, IOException {
        IImageMetadata metadata = Sanselan.getMetadata(file);
        if (metadata instanceof JpegImageMetadata) {
            TiffImageMetadata.GPSInfo gpsInfo;
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            System.out.println("file: " + file.getPath());
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_XRESOLUTION);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.TIFF_TAG_DATE_TIME);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_CREATE_DATE);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_ISO);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_SHUTTER_SPEED_VALUE);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_APERTURE_VALUE);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.EXIF_TAG_BRIGHTNESS_VALUE);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.GPS_TAG_GPS_LATITUDE_REF);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.GPS_TAG_GPS_LATITUDE);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.GPS_TAG_GPS_LONGITUDE_REF);
            MetadataExample.printTagValue(jpegMetadata, TiffConstants.GPS_TAG_GPS_LONGITUDE);
            System.out.println();
            TiffImageMetadata exifMetadata = jpegMetadata.getExif();
            if (null != exifMetadata && null != (gpsInfo = exifMetadata.getGPS())) {
                String gpsDescription = gpsInfo.toString();
                double longitude = gpsInfo.getLongitudeAsDegreesEast();
                double latitude = gpsInfo.getLatitudeAsDegreesNorth();
                System.out.println("\tGPS Description: " + gpsInfo);
                System.out.println("\tGPS Longitude (Degrees East): " + longitude);
                System.out.println("\tGPS Latitude (Degrees North): " + latitude);
            }
            TiffField gpsLatitudeRefField = jpegMetadata.findEXIFValue(TiffConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField gpsLatitudeField = jpegMetadata.findEXIFValue(TiffConstants.GPS_TAG_GPS_LATITUDE);
            TiffField gpsLongitudeRefField = jpegMetadata.findEXIFValue(TiffConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField gpsLongitudeField = jpegMetadata.findEXIFValue(TiffConstants.GPS_TAG_GPS_LONGITUDE);
            if (gpsLatitudeRefField != null && gpsLatitudeField != null && gpsLongitudeRefField != null && gpsLongitudeField != null) {
                String gpsLatitudeRef = (String)gpsLatitudeRefField.getValue();
                RationalNumber[] gpsLatitude = (RationalNumber[])gpsLatitudeField.getValue();
                String gpsLongitudeRef = (String)gpsLongitudeRefField.getValue();
                RationalNumber[] gpsLongitude = (RationalNumber[])gpsLongitudeField.getValue();
                RationalNumber gpsLatitudeDegrees = gpsLatitude[0];
                RationalNumber gpsLatitudeMinutes = gpsLatitude[1];
                RationalNumber gpsLatitudeSeconds = gpsLatitude[2];
                RationalNumber gpsLongitudeDegrees = gpsLongitude[0];
                RationalNumber gpsLongitudeMinutes = gpsLongitude[1];
                RationalNumber gpsLongitudeSeconds = gpsLongitude[2];
                System.out.println("\tGPS Latitude: " + gpsLatitudeDegrees.toDisplayString() + " degrees, " + gpsLatitudeMinutes.toDisplayString() + " minutes, " + gpsLatitudeSeconds.toDisplayString() + " seconds " + gpsLatitudeRef);
                System.out.println("\tGPS Longitude: " + gpsLongitudeDegrees.toDisplayString() + " degrees, " + gpsLongitudeMinutes.toDisplayString() + " minutes, " + gpsLongitudeSeconds.toDisplayString() + " seconds " + gpsLongitudeRef);
            }
            System.out.println();
            ArrayList items = jpegMetadata.getItems();
            for (int i = 0; i < items.size(); ++i) {
                Object item = items.get(i);
                System.out.println("\titem: " + item);
            }
            System.out.println();
        }
    }

    private static void printTagValue(JpegImageMetadata jpegMetadata, TagInfo tagInfo) throws ImageReadException, IOException {
        TiffField field = jpegMetadata.findEXIFValue(tagInfo);
        if (field == null) {
            System.out.println(tagInfo.name + ": " + "Not Found.");
        } else {
            System.out.println(tagInfo.name + ": " + field.getValueDescription());
        }
    }
}

