/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.messages;

import com.rapid7.client.dcerpc.io.Hexify;
import com.rapid7.client.dcerpc.io.HexifyImpl;
import com.rapid7.client.dcerpc.io.Packet;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import java.io.EOFException;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class RequestResponse
extends HexifyImpl
implements Packet,
Hexify {
    private int returnValue;

    public int getReturnValue() {
        return this.returnValue;
    }

    public SystemErrorCode getReturnCode() {
        return SystemErrorCode.getErrorCode(this.getReturnValue());
    }

    public boolean isSuccess() {
        return this.getReturnCode() == SystemErrorCode.ERROR_SUCCESS;
    }

    @Override
    public void unmarshal(PacketInput packetIn) throws IOException {
        this.unmarshalResponse(packetIn);
        packetIn.align(Alignment.FOUR);
        this.returnValue = packetIn.readInt();
        try {
            packetIn.readByte();
        }
        catch (EOFException e) {
            return;
        }
        throw new UnmarshalException("At least one byte remained after reading the return code. Is this response aligned properly?");
    }

    public abstract void unmarshalResponse(PacketInput var1) throws IOException;

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        throw new UnsupportedOperationException("Marshal Not Implemented.");
    }
}

