/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTranslatedSID;
import java.io.IOException;
import java.util.Arrays;

public class LSAPRTranslatedSIDs
implements Unmarshallable {
    private LSAPRTranslatedSID[] sids;

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int entries = in.readInt();
        this.sids = in.readReferentID() != 0 ? new LSAPRTranslatedSID[entries] : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.sids != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.sids.length; ++i) {
                LSAPRTranslatedSID lsaprTranslatedSID = new LSAPRTranslatedSID();
                lsaprTranslatedSID.unmarshalPreamble(in);
                this.sids[i] = lsaprTranslatedSID;
            }
            for (LSAPRTranslatedSID lsaprTranslatedSID : this.sids) {
                lsaprTranslatedSID.unmarshalEntity(in);
            }
            for (LSAPRTranslatedSID lsaprTranslatedSID : this.sids) {
                lsaprTranslatedSID.unmarshalDeferrals(in);
            }
        }
    }

    public LSAPRTranslatedSID[] getSIDs() {
        return this.sids;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRTranslatedSIDs)) {
            return false;
        }
        return Arrays.equals(this.sids, ((LSAPRTranslatedSIDs)obj).sids);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sids);
    }

    public String toString() {
        return String.format("LSAPR_TRANSLATED_SIDS{Sids:%s", Arrays.toString(this.sids));
    }
}

