/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msrrp;

import com.google.common.base.Strings;
import com.rapid7.client.dcerpc.RPCException;
import com.rapid7.client.dcerpc.io.ndr.arrays.RPCConformantVaryingByteArray;
import com.rapid7.client.dcerpc.messages.HandleResponse;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.msrrp.dto.FileTime;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryHive;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryKey;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryKeyInfo;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryValue;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryValueType;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegEnumKeyRequest;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegEnumKeyResponse;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegEnumValueRequest;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegEnumValueResponse;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegGetKeySecurityRequest;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegGetKeySecurityResponse;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegOpenKey;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegQueryInfoKeyRequest;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegQueryInfoKeyResponse;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegQueryValueRequest;
import com.rapid7.client.dcerpc.msrrp.messages.BaseRegQueryValueResponse;
import com.rapid7.client.dcerpc.msrrp.messages.HandleRequest;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import com.rapid7.client.dcerpc.service.Service;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RegistryService
extends Service {
    private static final int MAX_REGISTRY_KEY_NAME_SIZE = Short.MAX_VALUE;
    private static final int MAX_REGISTRY_KEY_CLASS_SIZE = Short.MAX_VALUE;
    private static final int MAX_REGISTRY_VALUE_NAME_SIZE = Short.MAX_VALUE;
    private static final int MAX_REGISTRY_VALUE_DATA_SIZE = 0x100000;
    private static final int MAXIMUM_ALLOWED = 0x2000000;
    private static final int ACCESS_SYSTEM_SECURITY = 0x1000000;
    private final Map<RegistryHive, byte[]> hiveCache = new HashMap<RegistryHive, byte[]>();
    private final Map<RegistryHandleKey, byte[]> keyPathCache = new HashMap<RegistryHandleKey, byte[]>();

    public RegistryService(RPCTransport transport) {
        super(transport);
    }

    public boolean doesKeyExist(String hiveName, String keyPath) throws IOException {
        try {
            this.openKey(hiveName, keyPath);
        }
        catch (RPCException exception) {
            if (this.isFileNotFound(exception)) {
                return false;
            }
            throw exception;
        }
        return true;
    }

    public boolean doesValueExist(String hiveName, String keyPath, String valueName) throws IOException {
        try {
            this.getValue(hiveName, keyPath, valueName);
        }
        catch (RPCException exception) {
            if (this.isFileNotFound(exception)) {
                return false;
            }
            throw exception;
        }
        return true;
    }

    public RegistryKeyInfo getKeyInfo(String hiveName, String keyPath) throws IOException {
        byte[] handle = this.openKey(hiveName, keyPath);
        BaseRegQueryInfoKeyRequest request = new BaseRegQueryInfoKeyRequest(handle);
        BaseRegQueryInfoKeyResponse response = this.callExpectSuccess(request, "BaseRegQueryInfoKey");
        return new RegistryKeyInfo(response.getSubKeys(), response.getMaxSubKeyLen(), response.getMaxClassLen(), response.getValues(), response.getMaxValueNameLen(), response.getMaxValueLen(), response.getSecurityDescriptor(), response.getLastWriteTime());
    }

    public List<RegistryKey> getSubKeys(String hiveName, String keyPath) throws IOException {
        LinkedList<RegistryKey> keyNames = new LinkedList<RegistryKey>();
        byte[] handle = this.openKey(hiveName, keyPath);
        int index = 0;
        while (true) {
            BaseRegEnumKeyRequest request;
            BaseRegEnumKeyResponse response;
            int returnCode;
            if (!SystemErrorCode.ERROR_SUCCESS.is(returnCode = (response = this.call(request = new BaseRegEnumKeyRequest(handle, index, Short.MAX_VALUE, Short.MAX_VALUE))).getReturnValue())) {
                if (SystemErrorCode.ERROR_NO_MORE_ITEMS.is(returnCode)) {
                    return Collections.unmodifiableList(new ArrayList(keyNames));
                }
                throw new RPCException("BaseRegEnumKey", returnCode);
            }
            keyNames.add(new RegistryKey(this.parseRPCUnicodeString(response.getLpNameOut()), new FileTime(response.getLastWriteTime())));
            ++index;
        }
    }

    public List<RegistryValue> getValues(String hiveName, String keyPath) throws IOException {
        LinkedList<RegistryValue> values = new LinkedList<RegistryValue>();
        byte[] handle = this.openKey(hiveName, keyPath);
        int index = 0;
        while (true) {
            BaseRegEnumValueRequest request;
            BaseRegEnumValueResponse response;
            int returnCode;
            if (!SystemErrorCode.ERROR_SUCCESS.is(returnCode = (response = this.call(request = new BaseRegEnumValueRequest(handle, index, Short.MAX_VALUE, 0x100000))).getReturnValue())) {
                if (SystemErrorCode.ERROR_NO_MORE_ITEMS.is(returnCode)) {
                    return Collections.unmodifiableList(new ArrayList(values));
                }
                throw new RPCException("BaseRegEnumValue", returnCode);
            }
            values.add(new RegistryValue(this.parseRPCUnicodeString(response.getName()), RegistryValueType.getRegistryValueType(response.getType()), response.getData().getArray()));
            ++index;
        }
    }

    public RegistryValue getValue(String hiveName, String keyPath, String valueName) throws IOException {
        String canonicalizedValueName = Strings.nullToEmpty((String)valueName);
        byte[] handle = this.openKey(hiveName, keyPath);
        BaseRegQueryValueRequest request = new BaseRegQueryValueRequest(handle, RPCUnicodeString.NullTerminated.of(canonicalizedValueName), 0x100000);
        BaseRegQueryValueResponse response = this.callExpectSuccess(request, "BaseRegQueryValue");
        RPCConformantVaryingByteArray data = response.getData();
        return new RegistryValue(canonicalizedValueName, RegistryValueType.getRegistryValueType(response.getType()), data == null ? null : data.getArray());
    }

    public byte[] getKeySecurity(String hiveName, String keyPath, int securityDescriptorType) throws IOException {
        byte[] handle = this.openKey(hiveName, keyPath, 0x3000000);
        int size = this.getKeyInfo(hiveName, keyPath).getSecurityDescriptor();
        BaseRegGetKeySecurityRequest request = new BaseRegGetKeySecurityRequest(handle, securityDescriptorType, size);
        BaseRegGetKeySecurityResponse response = this.callExpectSuccess(request, "BaseRegGetKeySecurity");
        return response.getpRpcSecurityDescriptorOut().getLpSecurityDescriptor();
    }

    protected String canonicalize(String keyPath) {
        keyPath = Strings.nullToEmpty((String)keyPath);
        keyPath = keyPath.toLowerCase();
        while (keyPath.contains("\\\\")) {
            keyPath = keyPath.replace("\\\\", "\\");
        }
        if (keyPath.endsWith("\\")) {
            keyPath = keyPath.substring(0, keyPath.length() - 1);
        }
        return keyPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] openHive(String hiveName) throws IOException {
        if (hiveName == null) {
            throw new IllegalArgumentException("Invalid hive: null");
        }
        RegistryHive hive = RegistryHive.getRegistryHiveByName(hiveName);
        if (hive == null) {
            throw new IllegalArgumentException("Unknown hive: " + hiveName);
        }
        Map<RegistryHive, byte[]> map = this.hiveCache;
        synchronized (map) {
            if (this.hiveCache.containsKey((Object)hive)) {
                return this.hiveCache.get((Object)hive);
            }
            short opNum = hive.getOpNum();
            HandleRequest request = new HandleRequest(opNum, 0x2000000);
            HandleResponse response = this.callExpectSuccess(request, hive.getOpName());
            byte[] handle = response.getHandle();
            this.hiveCache.put(hive, handle);
            return handle;
        }
    }

    protected byte[] openKey(String hiveName, String keyPath) throws IOException {
        return this.openKey(hiveName, keyPath, 0x2000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] openKey(String hiveName, String keyPath, int desiredAccess) throws IOException {
        String canonicalizedKeyPath = this.canonicalize(keyPath);
        if (canonicalizedKeyPath.isEmpty()) {
            return this.openHive(hiveName);
        }
        Map<RegistryHandleKey, byte[]> map = this.keyPathCache;
        synchronized (map) {
            RegistryHandleKey cachingKey = new RegistryHandleKey(canonicalizedKeyPath, desiredAccess);
            if (this.keyPathCache.containsKey(cachingKey)) {
                return this.keyPathCache.get(cachingKey);
            }
            byte[] hiveHandle = this.openHive(hiveName);
            BaseRegOpenKey request = new BaseRegOpenKey(hiveHandle, RPCUnicodeString.NullTerminated.of(canonicalizedKeyPath), 0, desiredAccess);
            HandleResponse response = this.callExpectSuccess(request, "BaseRegOpenKey");
            byte[] keyHandle = response.getHandle();
            this.keyPathCache.put(cachingKey, keyHandle);
            return keyHandle;
        }
    }

    private boolean isFileNotFound(RPCException exception) {
        return exception != null && exception.getErrorCode() == SystemErrorCode.ERROR_FILE_NOT_FOUND;
    }

    private static class RegistryHandleKey {
        private final String path;
        private final int access;

        RegistryHandleKey(String path, int access) {
            this.path = Objects.requireNonNull(path);
            this.access = access;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegistryHandleKey)) {
                return false;
            }
            RegistryHandleKey other = (RegistryHandleKey)o;
            return this.path.equals(other.path) && this.access == other.access;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.access);
        }
    }
}

